/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.omegat.core.STEComparator;
import org.omegat.core.glossary.GlossaryEntry;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.SourceTextEntry;
import org.omegat.core.threads.CommandThread;
import org.omegat.util.StaticUtils;

public class StringEntry {
    private SortedSet m_parentList = new TreeSet(new STEComparator());
    private SortedSet m_nearList = new TreeSet();
    private LinkedList m_glosList = new LinkedList();
    private String m_srcText;
    private String m_translation;

    public StringEntry(String string) {
        this.m_srcText = string;
        this.m_translation = "";
    }

    public String getSrcText() {
        return this.m_srcText;
    }

    public List getSrcTokenList() {
        return StaticUtils.tokenizeText(this.m_srcText);
    }

    public List getSrcTokenListAll() {
        return StaticUtils.tokenizeText(this.m_srcText, true);
    }

    public SortedSet getParentList() {
        return this.m_parentList;
    }

    public void addParent(SourceTextEntry sourceTextEntry) {
        this.m_parentList.add(sourceTextEntry);
    }

    public List getNearListTranslated() {
        ArrayList<NearString> arrayList = new ArrayList<NearString>(5);
        boolean bl = false;
        Iterator iterator = this.m_nearList.iterator();
        while (iterator.hasNext() && arrayList.size() < 5) {
            NearString nearString = (NearString)iterator.next();
            if (nearString.str.getTranslation().length() == 0) continue;
            arrayList.add(nearString);
        }
        return arrayList;
    }

    public void addNearString(StringEntry stringEntry, int n, int n2, byte[] byArray, String string) {
        if (this.m_nearList.size() >= 50) {
            NearString nearString = (NearString)this.m_nearList.last();
            if (n > nearString.score || n == nearString.score && n2 > nearString.adjustedScore) {
                this.m_nearList.remove(nearString);
            } else {
                return;
            }
        }
        this.m_nearList.add(new NearString(stringEntry, n, n2, byArray, string));
    }

    public List getGlossaryEntries() {
        return this.m_glosList;
    }

    public void addGlossaryEntry(GlossaryEntry glossaryEntry) {
        this.m_glosList.add(glossaryEntry);
    }

    public List getTransTokenList() {
        return StaticUtils.tokenizeText(this.m_translation);
    }

    public String getTranslation() {
        return this.m_translation;
    }

    public void setTranslation(String string) {
        boolean bl;
        if (string == null) {
            string = "";
        }
        boolean bl2 = bl = !"".equals(this.m_translation);
        if (!string.equals(this.m_translation)) {
            boolean bl3;
            CommandThread.core.markAsDirty();
            this.m_translation = string;
            boolean bl4 = bl3 = !"".equals(this.m_translation);
            if (bl && !bl3) {
                CommandThread.core.decreaseTranslated();
            } else if (!bl && bl3) {
                CommandThread.core.increaseTranslated();
            }
        }
    }

    public boolean isTranslated() {
        return this.m_translation != null && this.m_translation.length() > 0;
    }
}

