/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.omegat.core.segmentation.LanguageCodes;

public class MapRule
implements Serializable {
    private String languageCode;
    private Pattern pattern;
    private List rules;

    public MapRule() {
    }

    public MapRule(String string, String string2, List list) {
        this.setLanguage(string);
        this.setPattern(string2);
        this.setRules(list);
    }

    public String getLanguage() {
        String string = LanguageCodes.getLanguageName(this.languageCode);
        if (string == null || string.length() == 0) {
            string = this.languageCode;
        }
        return string;
    }

    public void setLanguage(String string) {
        this.languageCode = string;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getPattern() {
        if (this.pattern != null) {
            return this.pattern.pattern();
        }
        return null;
    }

    public Pattern getCompiledPattern() {
        return this.pattern;
    }

    public void setPattern(String string) throws PatternSyntaxException {
        this.pattern = Pattern.compile(string, 2);
    }

    public List getRules() {
        return this.rules;
    }

    public void setRules(List list) {
        this.rules = list;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        MapRule mapRule = (MapRule)object;
        return this.getPattern().equals(mapRule.getPattern()) && this.getLanguage().equals(mapRule.getLanguage()) && ((Object)this.getRules()).equals(mapRule.getRules());
    }

    public int hashCode() {
        return this.getPattern().hashCode() + this.getLanguage().hashCode() + ((Object)this.getRules()).hashCode();
    }

    public String toString() {
        return this.getLanguage() + " (" + this.getPattern() + ") " + this.getRules().toString();
    }
}

