/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import org.omegat.core.spellchecker.DictionaryFileNameFilter;
import org.omegat.util.PatternConsts;
import org.omegat.util.StaticUtils;

public class DictionaryManager {
    private File dir;

    public DictionaryManager(String string) {
        this.dir = new File(string);
    }

    public String getDirectory() {
        return this.dir.getAbsolutePath();
    }

    private String getFileNameOnly(String string) {
        int n = string.indexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    public ArrayList getDictionaryNameList(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            String[] stringArray = string.split("_");
            Locale locale = stringArray.length == 1 ? new Locale(stringArray[0]) : new Locale(stringArray[0], stringArray[1]);
            arrayList2.add(string + " - " + locale.getDisplayName());
        }
        return arrayList2;
    }

    public ArrayList getLocalDictionaryNameList() {
        return this.getDictionaryNameList(this.getLocalDictionaryCodeList());
    }

    public ArrayList getLocalDictionaryCodeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.dir.list(new DictionaryFileNameFilter(".aff"));
        String[] stringArray2 = this.dir.list(new DictionaryFileNameFilter(".dic"));
        if (stringArray != null && stringArray2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = false;
                String string = this.getFileNameOnly(stringArray[i]);
                if (string == null || string.equals("")) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string2 = this.getFileNameOnly(stringArray2[j]);
                    if (string2 == null || string2.equals("") || !string.equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public boolean uninstallDictionary(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = this.getDirectory() + File.separator + string;
        File file = new File(string2 + ".aff");
        if (!file.delete()) {
            return false;
        }
        File file2 = new File(string2 + ".dic");
        return file2.delete();
    }

    public ArrayList getInstallableDictionaryNameList() throws IOException {
        return this.getDictionaryNameList(this.getInstallableDictionaryCodeList());
    }

    public ArrayList getInstallableDictionaryCodeList() throws IOException {
        ArrayList arrayList = this.getLocalDictionaryCodeList();
        ArrayList arrayList2 = this.getRemoteDictionaryCodeList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = (String)arrayList2.get(i);
            if (arrayList.contains(string)) continue;
            arrayList3.add(string);
        }
        return arrayList3;
    }

    private ArrayList getRemoteDictionaryCodeList() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = StaticUtils.downloadFileToString("http://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/dictionaries/");
        Matcher matcher = PatternConsts.DICTIONARY_ZIP.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            int n = string2.indexOf(".");
            arrayList.add(string2.substring(1, n));
        }
        return arrayList;
    }

    public void installRemoteDictionary(String string) throws MalformedURLException, IOException {
        String string2 = "http://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/dictionaries//" + string + ".zip";
        File file = File.createTempFile(string, ".zip");
        String string3 = file.getAbsolutePath();
        StaticUtils.downloadFileToDisk(string2, string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string + ".aff");
        arrayList.add(string + ".dic");
        this.dir.mkdirs();
        StaticUtils.extractFileFromJar(string3, arrayList, this.dir.getAbsolutePath());
    }
}

