/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.TransMemory;
import org.omegat.core.matching.SourceTextEntry;
import org.omegat.core.threads.CommandThread;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.SearchWindow;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class SearchThread
extends Thread {
    private SearchWindow m_window;
    private boolean m_searching;
    private String m_searchDir;
    private boolean m_searchRecursive;
    private String m_curFileName;
    private boolean m_tmSearch;
    private HashSet m_entrySet;
    private ArrayList m_matchers;
    private int m_numFinds;
    private ArrayList m_extList;
    private ArrayList m_extMapList;

    public SearchThread(MainWindow mainWindow, SearchWindow searchWindow, String string) {
        this.setPriority(1);
        this.m_window = searchWindow;
        this.m_searchDir = null;
        this.m_searchRecursive = false;
        this.m_searching = false;
        this.m_tmSearch = false;
        this.m_entrySet = null;
        this.m_numFinds = 0;
        this.m_curFileName = "";
        this.m_extList = new ArrayList();
        this.m_extMapList = new ArrayList();
    }

    public void requestSearch(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (!this.m_searching) {
            int n;
            this.m_searchDir = string2;
            this.m_searchRecursive = bl;
            this.m_tmSearch = bl6;
            this.m_searching = true;
            this.m_entrySet = new HashSet();
            this.m_matchers = new ArrayList();
            int n2 = n = bl4 ? 0 : 66;
            if (bl2) {
                if (!bl5) {
                    string = StaticUtils.escapeNonRegex(string, false);
                }
                this.m_matchers.add(Pattern.compile(string, n).matcher(""));
            } else if ((string = string.trim()).length() > 0) {
                int n3 = 0;
                while (n3 < string.length()) {
                    String string3;
                    int n4 = string.indexOf(32, n3);
                    String string4 = string3 = n4 == -1 ? string.substring(n3, string.length()).trim() : string.substring(n3, n4).trim();
                    if (string3.length() > 0) {
                        if (!bl5) {
                            string3 = StaticUtils.escapeNonRegex(string3, false);
                        }
                        this.m_matchers.add(Pattern.compile(string3, n).matcher(""));
                    }
                    n3 = n4 == -1 ? string.length() : n4 + 1;
                }
            }
        }
    }

    public void run() {
        boolean bl = true;
        try {
            while (!SearchThread.interrupted()) {
                try {
                    SearchThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
                if (bl) {
                    bl = false;
                    this.m_window.setSearchControlFocus();
                }
                if (!this.m_searching) continue;
                if (this.m_searchDir == null) {
                    this.searchProject();
                } else {
                    String string;
                    try {
                        this.searchFiles();
                    }
                    catch (IOException iOException) {
                        string = OStrings.getString("ST_FILE_SEARCH_ERROR");
                        CommandThread.core.displayError(string, iOException);
                    }
                    catch (TranslationException translationException) {
                        string = OStrings.getString("ST_FILE_SEARCH_ERROR");
                        CommandThread.core.displayError(string, translationException);
                    }
                }
                if (this.m_numFinds == 0) {
                    this.m_window.postMessage(OStrings.getString("ST_NOTHING_FOUND"));
                }
                this.m_window.displayResults();
                this.m_searching = false;
                this.m_entrySet = null;
            }
        }
        catch (RuntimeException runtimeException) {
            String string = OStrings.getString("ST_FATAL_ERROR");
            CommandThread.core.displayError(string, runtimeException);
            this.m_window.threadDied();
        }
    }

    private void foundString(int n, String string, String string2, String string3) {
        if (this.m_numFinds++ > 1000) {
            return;
        }
        if (n >= 0) {
            if (!this.m_entrySet.contains(string2 + string3)) {
                this.m_window.addEntry(n + 1, null, n + 1 + "> " + string2, string3);
                this.m_entrySet.add(string2 + string3);
            }
        } else {
            this.m_window.addEntry(n, string, string2, string3);
        }
        if (this.m_numFinds >= 1000) {
            this.m_window.postMessage(StaticUtils.format(OStrings.getString("SW_MAX_FINDS_REACHED"), new Object[]{new Integer(1000)}));
        }
    }

    private void searchProject() {
        String string;
        Object object;
        Object object2;
        int n;
        this.m_numFinds = 0;
        for (n = 0; n < CommandThread.core.numEntries(); ++n) {
            object2 = CommandThread.core.getSTE(n);
            object = ((SourceTextEntry)object2).getSrcText();
            string = ((SourceTextEntry)object2).getTranslation();
            if (this.searchString((String)object) || this.searchString(string)) {
                this.foundString(n, null, (String)object, string);
            }
            if (this.m_numFinds >= 1000) break;
        }
        if (this.m_tmSearch) {
            object2 = CommandThread.core.getTransMemory();
            for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                object = (TransMemory)((ArrayList)object2).get(n);
                string = ((TransMemory)object).source;
                String string2 = ((TransMemory)object).target;
                if (this.searchString(string) || this.searchString(string2)) {
                    this.foundString(-1, ((TransMemory)object).file, string, string2);
                }
                if (this.m_numFinds >= 1000) break;
            }
        }
    }

    private void searchFiles() throws IOException, TranslationException {
        ArrayList arrayList = new ArrayList(256);
        if (!this.m_searchDir.endsWith(File.separator)) {
            this.m_searchDir = this.m_searchDir + File.separator;
        }
        StaticUtils.buildFileList(arrayList, new File(this.m_searchDir), this.m_searchRecursive);
        FilterMaster filterMaster = FilterMaster.getInstance();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            File file = new File(string);
            if (hashSet.contains(file)) continue;
            this.m_curFileName = string.substring(this.m_searchDir.length());
            filterMaster.searchFile(string, this, hashSet);
        }
    }

    private boolean searchString(String string) {
        if (string == null || this.m_matchers == null || this.m_matchers.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.m_matchers.size(); ++i) {
            Matcher matcher = (Matcher)this.m_matchers.get(i);
            matcher.reset(string);
            if (matcher.find()) continue;
            return false;
        }
        return true;
    }

    public void searchText(String string) {
        if (this.m_numFinds >= 1000) {
            return;
        }
        if (this.searchString(string)) {
            this.foundString(-1, this.m_curFileName, string, null);
        }
    }
}

