/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.htmlparser.Parser;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.html2.EditOptionsDialog;
import org.omegat.filters2.html2.FilterVisitor;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.filters2.html2.HTMLReader;
import org.omegat.filters2.html2.HTMLWriter;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class HTMLFilter2
extends AbstractFilter {
    private String sourceEncoding;
    private String targetEncoding;
    private Pattern skipRegExpPattern;
    private HTMLOptions options;

    public BufferedReader createReader(File file, String string) throws UnsupportedEncodingException, IOException {
        HTMLReader hTMLReader = new HTMLReader(file.getAbsolutePath(), string);
        this.sourceEncoding = hTMLReader.getEncoding();
        return new BufferedReader(hTMLReader);
    }

    public BufferedWriter createWriter(File file, String string) throws UnsupportedEncodingException, IOException {
        HTMLOptions hTMLOptions = (HTMLOptions)this.getOptions();
        this.targetEncoding = string == null ? this.sourceEncoding : string;
        HTMLWriter hTMLWriter = new HTMLWriter(file.getAbsolutePath(), this.targetEncoding, hTMLOptions);
        return new BufferedWriter(hTMLWriter);
    }

    public void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException, TranslationException {
        Object object;
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = new StringBuffer();
            object = new char[1000];
            int n = -1;
            while ((n = bufferedReader.read((char[])object)) > 0) {
                stringBuffer.append((char[])object, 0, n);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            stringBuffer = null;
            System.gc();
            throw new IOException(OStrings.getString("HTML__FILE_TOO_BIG"));
        }
        if (this.hasOptions()) {
            this.options = (HTMLOptions)this.getOptions();
            if (this.options == null) {
                this.options = new HTMLOptions();
            }
        }
        if ((object = (Object)this.options.getskipRegExp()) != null && ((String)object).length() > 0) {
            try {
                this.skipRegExpPattern = Pattern.compile((String)object, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Log.log(patternSyntaxException);
            }
        }
        Parser parser = new Parser();
        try {
            parser.setInputHTML(stringBuffer.toString());
            parser.visitAllNodesWith((NodeVisitor)new FilterVisitor(this, bufferedWriter));
        }
        catch (ParserException parserException) {
            System.out.println((Object)parserException);
        }
    }

    String privateProcessEntry(String string) {
        if (this.skipRegExpPattern != null) {
            if (this.skipRegExpPattern.matcher(string).matches()) {
                return string;
            }
            return super.processEntry(string);
        }
        return super.processEntry(string);
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    public boolean isSourceEncodingVariable() {
        return true;
    }

    public String getFileFormatName() {
        return OStrings.getString("HTML__FILTER_NAME");
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.htm", null, "UTF-8"), new Instance("*.html", null, "UTF-8"), new Instance("*.xhtml", null, "UTF-8")};
    }

    public String getHint() {
        return OStrings.getString("HTML_NOTE");
    }

    public boolean hasOptions() {
        return true;
    }

    public Serializable changeOptions(Dialog dialog, Serializable serializable) {
        try {
            HTMLOptions hTMLOptions = (HTMLOptions)serializable;
            EditOptionsDialog editOptionsDialog = new EditOptionsDialog(dialog, hTMLOptions);
            editOptionsDialog.setVisible(true);
            if (1 == editOptionsDialog.getReturnStatus()) {
                return editOptionsDialog.getOptions();
            }
            return serializable;
        }
        catch (Exception exception) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS");
            Log.log(exception);
            return serializable;
        }
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }
}

