/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class FontSelectionDialog
extends JDialog {
    public static final int RET_CANCEL_OR_UNCHANGED = 0;
    public static final int RET_OK_CHANGED = 1;
    private Font oldFont;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JComboBox fontComboBox;
    private JLabel fontLabel;
    private JButton okButton;
    private JTextArea previewTextArea;
    private JLabel sizeLabel;
    private JSpinner sizeSpinner;
    private int returnStatus = 0;

    public Font getSelectedFont() {
        return new Font((String)this.fontComboBox.getSelectedItem(), 0, ((Number)this.sizeSpinner.getValue()).intValue());
    }

    public FontSelectionDialog(Frame frame, Font font) {
        super(frame, true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSelectionDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.oldFont = font;
        this.previewTextArea.setFont(this.oldFont);
        this.fontComboBox.setSelectedItem(this.oldFont.getName());
        this.sizeSpinner.setValue(new Integer(this.oldFont.getSize()));
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.fontComboBox = new JComboBox<String>(StaticUtils.getFontNames());
        this.fontLabel = new JLabel();
        this.sizeSpinner = new JSpinner();
        this.sizeLabel = new JLabel();
        this.previewTextArea = new JTextArea();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(OStrings.getString("TF_SELECT_FONTS_TITLE"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FontSelectionDialog.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSelectionDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSelectionDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.fontComboBox.setMaximumRowCount(20);
        this.fontComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSelectionDialog.this.fontComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.fontComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.fontLabel, (String)OStrings.getString("TF_SELECT_SOURCE_FONT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.fontLabel, gridBagConstraints);
        this.sizeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FontSelectionDialog.this.sizeSpinnerStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.sizeSpinner, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.sizeLabel, (String)OStrings.getString("TF_SELECT_FONTSIZE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.sizeLabel, gridBagConstraints);
        this.previewTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.previewTextArea.setEditable(false);
        this.previewTextArea.setLineWrap(true);
        this.previewTextArea.setText(OStrings.getString("TF_FONT_SAMPLE_TEXT"));
        this.previewTextArea.setWrapStyleWord(true);
        this.previewTextArea.setBorder(new TitledBorder(null, OStrings.getString("TF_FONT_SAMPLE_TITLE"), 0, 0, this.fontLabel.getFont()));
        this.previewTextArea.setPreferredSize(new Dimension(116, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.previewTextArea, gridBagConstraints);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void fontComboBoxActionPerformed(ActionEvent actionEvent) {
        this.previewTextArea.setFont(this.getSelectedFont());
    }

    private void sizeSpinnerStateChanged(ChangeEvent changeEvent) {
        this.previewTextArea.setFont(this.getSelectedFont());
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.getSelectedFont().equals(this.oldFont)) {
            this.doClose(1);
        } else {
            this.doClose(0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

