/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class WorkflowOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JCheckBox allowTranslationEqualToSource;
    private JButton cancelButton;
    private JRadioButton defaultRadio;
    private JTextArea descriptionTextArea;
    private JCheckBox insertFuzzyCheckBox;
    private JRadioButton leaveEmptyRadio;
    private JButton okButton;
    private ButtonGroup ourButtonGroup;
    private JLabel prefixLabel;
    private JTextField prefixText;
    private JLabel similarityLabel;
    private JSpinner similaritySpinner;
    private int returnStatus = 0;

    public WorkflowOptionsDialog(Frame frame) {
        super(frame, true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowOptionsDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.leaveEmptyRadio.setSelected(Preferences.isPreference("wf_noSourceText"));
        this.insertFuzzyCheckBox.setSelected(Preferences.isPreference("wf_insertBestMatch"));
        this.similarityLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.similaritySpinner.setValue(new Integer(Preferences.getPreferenceDefault("wf_minimalSimilarity", "80")));
        this.similaritySpinner.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixText.setText(Preferences.getPreferenceDefault("wf_explanatoryText", OStrings.getString("WF_DEFAULT_PREFIX")));
        this.prefixText.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.allowTranslationEqualToSource.setSelected(Preferences.isPreference("wf_allowTransEqualToSrc"));
        this.invalidate();
        this.pack();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.ourButtonGroup = new ButtonGroup();
        this.similarityLabel = new JLabel();
        this.similaritySpinner = new JSpinner(new SpinnerNumberModel(new Integer(90), new Integer(1), new Integer(100), new Integer(1)));
        this.descriptionTextArea = new JTextArea();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.allowTranslationEqualToSource = new JCheckBox();
        this.defaultRadio = new JRadioButton();
        this.leaveEmptyRadio = new JRadioButton();
        this.prefixLabel = new JLabel();
        this.prefixText = new JTextField();
        this.insertFuzzyCheckBox = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(OStrings.getString("GUI_TITLE_Workflow_Options"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                WorkflowOptionsDialog.this.closeDialog(windowEvent);
            }
        });
        this.similarityLabel.setLabelFor(this.similaritySpinner);
        Mnemonics.setLocalizedText((JLabel)this.similarityLabel, (String)OStrings.getString("GUI_WORKFLOW_OPTION_Minimal_Similarity"));
        this.similarityLabel.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.getContentPane().add((Component)this.similarityLabel, gridBagConstraints);
        this.similaritySpinner.setEnabled(false);
        this.similaritySpinner.setValue(new Integer(90));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.similaritySpinner, gridBagConstraints);
        this.descriptionTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(new JLabel().getFont());
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(OStrings.getString("GUI_WORKFLOW_DESCRIPTION"));
        this.descriptionTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.descriptionTextArea, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowOptionsDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowOptionsDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.allowTranslationEqualToSource, (String)OStrings.getString("WF_OPTION_ALLOW_TRANS_EQ_TO_SRC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.allowTranslationEqualToSource, gridBagConstraints);
        this.ourButtonGroup.add(this.defaultRadio);
        this.defaultRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultRadio, (String)OStrings.getString("WF_OPTION_INSERT_SOURCE"));
        this.defaultRadio.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.defaultRadio.setMargin(new Insets(0, 0, 0, 0));
        this.defaultRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowOptionsDialog.this.radiosActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.defaultRadio, gridBagConstraints);
        this.ourButtonGroup.add(this.leaveEmptyRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.leaveEmptyRadio, (String)OStrings.getString("WF_OPTION_INSERT_NOTHTHING"));
        this.leaveEmptyRadio.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.leaveEmptyRadio.setMargin(new Insets(0, 0, 0, 0));
        this.leaveEmptyRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowOptionsDialog.this.radiosActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.leaveEmptyRadio, gridBagConstraints);
        this.prefixLabel.setLabelFor(this.prefixText);
        Mnemonics.setLocalizedText((JLabel)this.prefixLabel, (String)OStrings.getString("WF_OPTION_INSERT_FUZZY_PREFIX"));
        this.prefixLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.getContentPane().add((Component)this.prefixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.prefixText, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.insertFuzzyCheckBox, (String)OStrings.getString("WF_OPTION_INSERT_FUZZY_MATCH"));
        this.insertFuzzyCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowOptionsDialog.this.radiosActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.insertFuzzyCheckBox, gridBagConstraints);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void radiosActionPerformed(ActionEvent actionEvent) {
        this.similarityLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.similaritySpinner.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixText.setEnabled(this.insertFuzzyCheckBox.isSelected());
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        Preferences.setPreference("wf_noSourceText", this.leaveEmptyRadio.isSelected());
        Preferences.setPreference("wf_insertBestMatch", this.insertFuzzyCheckBox.isSelected());
        if (this.insertFuzzyCheckBox.isSelected()) {
            Preferences.setPreference("wf_minimalSimilarity", this.similaritySpinner.getValue().toString());
            Preferences.setPreference("wf_explanatoryText", this.prefixText.getText());
        }
        Preferences.setPreference("wf_allowTransEqualToSrc", this.allowTranslationEqualToSource.isSelected());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

