/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.filters;

import java.util.Locale;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Text;

public class StringFilter
implements NodeFilter {
    protected String mPattern;
    protected String mUpperPattern;
    protected boolean mCaseSensitive;
    protected Locale mLocale;

    public StringFilter() {
        this("", false);
    }

    public StringFilter(String pattern) {
        this(pattern, false);
    }

    public StringFilter(String pattern, boolean sensitive) {
        this(pattern, sensitive, null);
    }

    public StringFilter(String pattern, boolean sensitive, Locale locale) {
        this.mPattern = pattern;
        this.mCaseSensitive = sensitive;
        this.mLocale = null == locale ? Locale.getDefault() : locale;
        this.setUpperPattern();
    }

    protected void setUpperPattern() {
        this.mUpperPattern = this.getCaseSensitive() ? this.getPattern() : this.getPattern().toUpperCase(this.getLocale());
    }

    public boolean getCaseSensitive() {
        return this.mCaseSensitive;
    }

    public void setCaseSensitive(boolean sensitive) {
        this.mCaseSensitive = sensitive;
        this.setUpperPattern();
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public void setLocale(Locale locale) {
        this.mLocale = locale;
        this.setUpperPattern();
    }

    public String getPattern() {
        return this.mPattern;
    }

    public void setPattern(String pattern) {
        this.mPattern = pattern;
        this.setUpperPattern();
    }

    public boolean accept(Node node) {
        boolean ret = false;
        if (node instanceof Text) {
            String string = ((Text)node).getText();
            if (!this.getCaseSensitive()) {
                string = string.toUpperCase(this.getLocale());
            }
            ret = -1 != string.indexOf(this.mUpperPattern);
        }
        return ret;
    }
}

