/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class BooleanReturnNull
extends OpcodeStackDetector {
    BugReporter bugReporter;

    public BooleanReturnNull(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code code) {
        String s = this.getMethodSig();
        SignatureParser sp = new SignatureParser(s);
        boolean interesting = "Ljava/lang/Boolean;".equals(sp.getReturnTypeSignature());
        if (interesting) {
            super.visit(code);
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 176 && this.getPrevOpcode(1) == 1) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NP_BOOLEAN_RETURN_NULL", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }
}

