/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.ArrayList;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindPuzzlers
extends OpcodeStackDetector {
    private static final boolean VAMISMATCH_DEBUG = SystemProperties.getBoolean((String)"vamismatch.debug");
    final BugReporter bugReporter;
    final BugAccumulator bugAccumulator;
    int imul_constant;
    int imul_distance;
    boolean imul_operand_is_parameter;
    int prevOpcodeIncrementedRegister;
    int valueOfConstantArgumentToShift;
    int best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG;
    boolean constantArgumentToShift;
    boolean shiftOfNonnegativeValue;
    int ternaryConversionState = 0;
    int badlyComputingOddState;
    int prevOpCode;
    XMethod previousMethodInvocation;
    boolean isTigerOrHigher;
    private static final int FS_STATE_NONE = 0;
    private static final int FS_STATE_SAW_STR_LOAD = 1;
    private static final int FS_STATE_SAW_CONST_PUSH = 2;
    private static final int FS_STATE_SAW_NEWARRAY = 3;
    private int prevConst = -1;
    private int fsState = 0;
    private int fsAAStores = 0;
    private String fsFmtStr = null;

    public FindPuzzlers(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code obj) {
        this.prevOpcodeIncrementedRegister = -1;
        this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG = 4;
        this.prevOpCode = 0;
        this.previousMethodInvocation = null;
        this.badlyComputingOddState = 0;
        this.resetIMulCastLong();
        this.imul_distance = 10000;
        this.ternaryConversionState = 0;
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    public void visit(JavaClass obj) {
        this.isTigerOrHigher = obj.getMajor() >= 49;
    }

    private void resetIMulCastLong() {
        this.imul_constant = 1;
        this.imul_operand_is_parameter = false;
    }

    private int adjustPriority(int factor, int priority) {
        if (factor <= 4) {
            return 5;
        }
        if (factor <= 10000) {
            return priority + 1;
        }
        if (factor <= 3600000) {
            return priority;
        }
        return priority - 1;
    }

    private int adjustMultiplier(Object constant, int mul) {
        if (!(constant instanceof Integer)) {
            return mul;
        }
        return Math.abs((Integer)constant) * mul;
    }

    public void sawOpcode(int seen) {
        String signature;
        int v;
        int pos;
        OpcodeStack.Item item;
        Object o;
        String sig;
        int v2;
        OpcodeStack.Item item2;
        Object o2;
        OpcodeStack.Item index;
        String clazz;
        if (seen != 177 && this.isReturn(seen) && this.isRegisterStore(this.getPrevOpcode(1))) {
            int priority = 2;
            if (this.getMethodSig().endsWith(")Z")) {
                priority = 1;
            } else {
                if (this.getMethodSig().endsWith(")Ljava/lang/String;")) {
                    priority = 3;
                }
                if (this.getPC() == this.getCode().getCode().length - 1) {
                    ++priority;
                }
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DLS_DEAD_LOCAL_STORE_IN_RETURN", priority).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (seen == 104) {
            if (this.imul_distance != 1) {
                this.resetIMulCastLong();
            }
            this.imul_distance = 0;
            if (this.stack.getStackDepth() > 1) {
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                this.imul_constant = this.adjustMultiplier(item0.getConstant(), this.imul_constant);
                this.imul_constant = this.adjustMultiplier(item1.getConstant(), this.imul_constant);
                if (item0.isInitialParameter() || item1.isInitialParameter()) {
                    this.imul_operand_is_parameter = true;
                }
            }
        } else {
            ++this.imul_distance;
        }
        if (this.prevOpCode == 104 && seen == 133) {
            int priority = this.adjustPriority(this.imul_constant, 2);
            if (priority >= 3 && this.imul_constant != 1000 && this.imul_operand_is_parameter) {
                priority = 2;
            }
            if (priority <= this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG) {
                this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG = priority;
                this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "ICAST_INTEGER_MULTIPLY_CAST_TO_LONG", priority).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
            }
        }
        if (this.getMethodName().equals("<clinit>") && (seen == 179 || seen == 178 || seen == 184) && !(clazz = this.getClassConstantOperand()).equals(this.getClassName())) {
            try {
                JavaClass targetClass = Repository.lookupClass((String)clazz);
                if (Repository.instanceOf((JavaClass)targetClass, (JavaClass)this.getThisClass())) {
                    int priority = 2;
                    if (seen == 178) {
                        --priority;
                    }
                    if (!targetClass.isPublic()) {
                        ++priority;
                    }
                    this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION", priority).addClassAndMethod((PreorderVisitor)this).addClass(this.getDottedClassConstantOperand()), (BytecodeScanningDetector)this);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((seen >= 46 && seen <= 53 || seen >= 79 && seen <= 86) && (index = this.stack.getStackItem(0)).getSpecialKind() == 6) {
            SourceLineAnnotation where = index.getPC() >= 0 ? SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this, (int)index.getPC()) : SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this);
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "IM_AVERAGE_COMPUTATION_COULD_OVERFLOW", 2).addClassAndMethod((PreorderVisitor)this), where);
        }
        if (!(seen != 153 && seen != 154 || this.getPrevOpcode(1) != 104 || this.getPrevOpcode(2) != 17 && this.getPrevOpcode(2) != 16 || this.getPrevOpcode(3) != 112)) {
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "IM_MULTIPLYING_RESULT_OF_IREM", 3).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
        }
        if (!((seen != 147 || this.getPrevOpcode(1) != 124 || this.shiftOfNonnegativeValue || this.constantArgumentToShift && this.valueOfConstantArgumentToShift % 16 == 0) && (seen != 145 || this.getPrevOpcode(1) != 124 || this.shiftOfNonnegativeValue || this.constantArgumentToShift && this.valueOfConstantArgumentToShift % 8 == 0))) {
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "ICAST_QUESTIONABLE_UNSIGNED_RIGHT_SHIFT", 2).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
        }
        this.constantArgumentToShift = false;
        this.shiftOfNonnegativeValue = false;
        if (seen == 124 || seen == 122 || seen == 120) {
            if (this.stack.getStackDepth() <= 1) {
                this.constantArgumentToShift = true;
                this.valueOfConstantArgumentToShift = 8;
            } else {
                Object rightHandSide = this.stack.getStackItem(0).getConstant();
                Object leftHandSide = this.stack.getStackItem(1).getConstant();
                this.shiftOfNonnegativeValue = this.stack.getStackItem(1).isNonNegative();
                if (rightHandSide instanceof Integer) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = (Integer)rightHandSide;
                    if (this.valueOfConstantArgumentToShift < 0 || this.valueOfConstantArgumentToShift >= 32) {
                        this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "ICAST_BAD_SHIFT_AMOUNT", this.valueOfConstantArgumentToShift < 0 ? 3 : 1).addClassAndMethod((PreorderVisitor)this).addInt(this.valueOfConstantArgumentToShift).describe("INT_SHIFT"), (BytecodeScanningDetector)this);
                    }
                }
                if (leftHandSide != null && leftHandSide instanceof Integer && (Integer)leftHandSide > 0) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = 8;
                }
            }
        }
        if (seen == 182 && this.stack.getStackDepth() > 0 && this.getClassConstantOperand().equals("java/util/Date") && this.getNameConstantOperand().equals("setMonth") && this.getSigConstantOperand().equals("(I)V") && (o2 = (item2 = this.stack.getStackItem(0)).getConstant()) != null && o2 instanceof Integer && ((v2 = ((Integer)o2).intValue()) < 0 || v2 > 11)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_BAD_MONTH", 1).addClassAndMethod((PreorderVisitor)this).addInt(v2).describe("INT_VALUE").addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if ((seen == 182 && this.stack.getStackDepth() > 1 && this.getClassConstantOperand().equals("java/util/Calendar") && this.getNameConstantOperand().equals("set") || seen == 183 && this.stack.getStackDepth() > 1 && this.getClassConstantOperand().equals("java/util/GregorianCalendar") && this.getNameConstantOperand().equals("<init>")) && (sig = this.getSigConstantOperand()).startsWith("(III") && (o = (item = this.stack.getStackItem(pos = sig.length() - 5)).getConstant()) != null && o instanceof Integer && ((v = ((Integer)o).intValue()) < 0 || v > 11)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_BAD_MONTH", 2).addClassAndMethod((PreorderVisitor)this).addInt(v).describe("INT_VALUE").addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (this.isRegisterStore() && (seen == 54 || seen == 59 || seen == 60 || seen == 61 || seen == 62) && this.getRegisterOperand() == this.prevOpcodeIncrementedRegister) {
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "DLS_OVERWRITTEN_INCREMENT", 1).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
        }
        this.prevOpcodeIncrementedRegister = seen == 132 ? this.getRegisterOperand() : -1;
        switch (this.badlyComputingOddState) {
            case 0: {
                if (seen != 5) break;
                ++this.badlyComputingOddState;
                break;
            }
            case 1: {
                if (seen == 112) {
                    item = this.stack.getStackItem(1);
                    if (!item.isNonNegative() && item.getSpecialKind() != 11) {
                        ++this.badlyComputingOddState;
                        break;
                    }
                    this.badlyComputingOddState = 0;
                    break;
                }
                this.badlyComputingOddState = 0;
                break;
            }
            case 2: {
                if (seen == 4) {
                    ++this.badlyComputingOddState;
                    break;
                }
                this.badlyComputingOddState = 0;
                break;
            }
            case 3: {
                if (seen == 159 || seen == 160) {
                    this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "IM_BAD_CHECK_FOR_ODD", 2).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
                }
                this.badlyComputingOddState = 0;
            }
        }
        if (seen == 182 && this.stack.getStackDepth() > 0 && (this.getNameConstantOperand().equals("toString") && this.getSigConstantOperand().equals("()Ljava/lang/String;") || this.getNameConstantOperand().equals("append") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Ljava/lang/StringBuilder;") && this.getClassConstantOperand().equals("java/lang/StringBuilder") || this.getNameConstantOperand().equals("append") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Ljava/lang/StringBuffer;") && this.getClassConstantOperand().equals("java/lang/StringBuffer")) && (signature = (item = this.stack.getStackItem(0)).getSignature()) != null && signature.startsWith("[")) {
            String name = null;
            int reg = item.getRegisterNumber();
            ArrayList<LocalVariableAnnotation> as = new ArrayList<LocalVariableAnnotation>();
            if (reg != -1) {
                LocalVariableAnnotation lva = LocalVariableAnnotation.getLocalVariableAnnotation((Method)this.getMethod(), (int)reg, (int)this.getPC(), (int)(this.getPC() - 1));
                name = "array " + lva.getName() + "[]";
                as.add(lva);
            }
            if (name != null) {
                this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "DMI_INVOKING_TOSTRING_ON_ARRAY", 2).addClassAndMethod((PreorderVisitor)this).addAnnotations(as), (BytecodeScanningDetector)this);
            } else {
                this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "DMI_INVOKING_TOSTRING_ON_ANONYMOUS_ARRAY", 2).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
            }
        }
        if (this.isTigerOrHigher) {
            if (this.previousMethodInvocation != null && this.prevOpCode == 183 && seen == 182) {
                String classNameForPreviousMethod = this.previousMethodInvocation.getClassName();
                String classNameForThisMethod = this.getClassConstantOperand();
                if (classNameForPreviousMethod.startsWith("java.lang.") && classNameForPreviousMethod.equals(classNameForThisMethod.replace('/', '.')) && this.getNameConstantOperand().endsWith("Value") && this.getSigConstantOperand().length() == 3) {
                    if (this.getSigConstantOperand().charAt(2) == this.previousMethodInvocation.getSignature().charAt(1)) {
                        this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "BX_BOXING_IMMEDIATELY_UNBOXED", 2).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
                    } else {
                        this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "BX_BOXING_IMMEDIATELY_UNBOXED_TO_PERFORM_COERCION", 2).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
                    }
                    this.ternaryConversionState = 1;
                } else {
                    this.ternaryConversionState = 0;
                }
            } else if (seen == 182) {
                this.ternaryConversionState = this.getClassConstantOperand().startsWith("java/lang") && this.getNameConstantOperand().endsWith("Value") && this.getSigConstantOperand().length() == 3 ? 1 : 0;
            } else if (this.ternaryConversionState == 1) {
                this.ternaryConversionState = 133 <= seen && seen <= 147 ? 2 : 0;
            } else if (this.ternaryConversionState == 2) {
                this.ternaryConversionState = 0;
                if (seen == 167) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "BX_UNBOXED_AND_COERCED_FOR_TERNARY_OPERATOR", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
        if (seen == 184 && (this.getNameConstantOperand().startsWith("assert") || this.getNameConstantOperand().startsWith("fail")) && this.getMethodName().equals("run") && this.implementsRunnable(this.getThisClass())) {
            try {
                JavaClass targetClass;
                int size1 = Util.getSizeOfSurroundingTryBlock((ConstantPool)this.getConstantPool(), (Code)this.getMethod().getCode(), (String)"java/lang/Throwable", (int)this.getPC());
                int size2 = Util.getSizeOfSurroundingTryBlock((ConstantPool)this.getConstantPool(), (Code)this.getMethod().getCode(), (String)"java/lang/Error", (int)this.getPC());
                int size3 = Util.getSizeOfSurroundingTryBlock((ConstantPool)this.getConstantPool(), (Code)this.getMethod().getCode(), (String)"java/lang/AssertionFailureError", (int)this.getPC());
                int size = Math.min(Math.min(size1, size2), size3);
                if (size == Integer.MAX_VALUE && (targetClass = AnalysisContext.currentAnalysisContext().lookupClass(this.getClassConstantOperand().replace('/', '.'))).getSuperclassName().startsWith("junit")) {
                    this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, "IJU_ASSERT_METHOD_INVOKED_FROM_RUN_METHOD", 2).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass((ClassNotFoundException)e);
            }
        }
        this.previousMethodInvocation = seen == 183 && this.getClassConstantOperand().startsWith("java/lang/") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().length() == 4 ? XFactory.createReferencedXMethod((DismantleBytecode)this) : (seen == 184 && this.getClassConstantOperand().startsWith("java/lang/") && this.getNameConstantOperand().equals("valueOf") && this.getSigConstantOperand().length() == 4 ? XFactory.createReferencedXMethod((DismantleBytecode)this) : null);
        this.prevOpCode = seen;
        if (this.fsState == 0) {
            Constant c;
            if (seen == 18 && (c = this.getConstantRefOperand()) instanceof ConstantString) {
                this.fsFmtStr = this.getStringConstantOperand();
                if (VAMISMATCH_DEBUG) {
                    System.out.println("Format str: " + this.fsFmtStr);
                }
                this.fsState = 1;
            }
        } else if (this.fsState == 1) {
            if (seen == 3) {
                this.prevConst = 0;
                this.fsState = 2;
            } else if (seen == 4) {
                this.prevConst = 1;
                this.fsState = 2;
            } else if (seen == 5) {
                this.prevConst = 2;
                this.fsState = 2;
            } else if (seen == 6) {
                this.prevConst = 3;
                this.fsState = 2;
            } else if (seen == 7) {
                this.prevConst = 4;
                this.fsState = 2;
            } else if (seen == 8) {
                this.prevConst = 5;
                this.fsState = 2;
            } else if (seen == 16) {
                this.prevConst = this.getIntConstant();
                this.fsState = 2;
            } else {
                this.prevConst = -1;
                this.fsState = 0;
            }
        } else if (this.fsState == 2) {
            if (seen == 189) {
                if (VAMISMATCH_DEBUG) {
                    System.out.println("New array with const: " + this.prevConst);
                }
                this.fsState = 3;
                this.fsAAStores = 0;
            } else {
                this.fsState = 0;
            }
        } else if (this.fsState == 3) {
            if (seen == 83) {
                ++this.fsAAStores;
                if (VAMISMATCH_DEBUG) {
                    System.out.println("Saw an AASTORE; new count: " + this.fsAAStores);
                }
                if (this.fsAAStores > this.prevConst) {
                    if (VAMISMATCH_DEBUG) {
                        System.out.println("Oops, " + this.fsAAStores + " is too many");
                    }
                    this.fsState = 0;
                }
            } else if (this.fsAAStores == this.prevConst && (seen == 183 || seen == 182 || seen == 184)) {
                String cl = this.getClassConstantOperand();
                String nm = this.getNameConstantOperand();
                XMethod xm = XFactory.createReferencedXMethod((DismantleBytecode)this);
                int flags = xm.getAccessFlags();
                if ((flags & 0x80) != 0) {
                    if (VAMISMATCH_DEBUG) {
                        System.out.println("Found VARARGS method: " + cl + "." + nm);
                    }
                    if ("java/util/Formatter".equals(cl) && "format".equals(nm) || "java/lang/String".equals(cl) && "format".equals(nm) || "java/io/PrintStream".equals(cl) && "format".equals(nm) || "java/io/PrintStream".equals(cl) && "printf".equals(nm)) {
                        int pcts = 0;
                        int highAbs = 0;
                        for (int i = 0; i < this.fsFmtStr.length(); ++i) {
                            if (this.fsFmtStr.charAt(i) != '%') continue;
                            if (i < this.fsFmtStr.length() - 1 && (this.fsFmtStr.charAt(i + 1) == '%' || this.fsFmtStr.charAt(i + 1) == 'n')) {
                                ++i;
                                continue;
                            }
                            if (i < this.fsFmtStr.length() - 1 && this.fsFmtStr.charAt(i + 1) == '<') {
                                ++i;
                                continue;
                            }
                            if (i < this.fsFmtStr.length() - 1 && this.fsFmtStr.charAt(i + 1) >= '0' && this.fsFmtStr.charAt(i + 1) <= '9') {
                                int idx = this.fsFmtStr.charAt(i + 1) - 48;
                                ++i;
                                while (i + 1 < this.fsFmtStr.length()) {
                                    if (this.fsFmtStr.charAt(i + 1) >= '0' && this.fsFmtStr.charAt(i + 1) <= '9') {
                                        idx *= 10;
                                        idx += this.fsFmtStr.charAt(i + 1) - 48;
                                    } else {
                                        if (this.fsFmtStr.charAt(i + 1) == '$') break;
                                        idx = 0;
                                        ++pcts;
                                        break;
                                    }
                                    ++i;
                                }
                                if (idx > highAbs) {
                                    if (VAMISMATCH_DEBUG) {
                                        System.out.println("New highest abs idx: " + idx);
                                    }
                                    highAbs = idx;
                                    continue;
                                }
                                if (!VAMISMATCH_DEBUG) continue;
                                System.out.println("Not highest abs idx: " + idx + " (highest: " + highAbs + ")");
                                continue;
                            }
                            ++pcts;
                        }
                        int consumedPcts = Math.max(pcts, highAbs);
                        if (VAMISMATCH_DEBUG) {
                            System.out.println("Consumed pcts is: " + consumedPcts + ", normal pcts: " + pcts + ", highest absolute: " + highAbs);
                        }
                        if (consumedPcts != this.prevConst) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "VA_FORMAT_STRING_ARG_MISMATCH", 2).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addString(this.fsFmtStr).addInt(consumedPcts).describe("INT_EXPECTED_ARGUMENTS").addInt(this.prevConst).describe("INT_ACTUAL_ARGUMENTS").addSourceLine((BytecodeScanningDetector)this));
                            if (VAMISMATCH_DEBUG) {
                                System.out.println("WARNING: # consumed percent signs (" + consumedPcts + ") doesn't match vararg array size: " + this.prevConst);
                            }
                        } else if (VAMISMATCH_DEBUG) {
                            System.out.println("# consumed percent signs (" + consumedPcts + ") matchs vararg array size: " + this.prevConst);
                        }
                    } else if (VAMISMATCH_DEBUG) {
                        System.out.println("Not a VARARGS I'm familiar with");
                    }
                } else if (("java/util/Formatter".equals(cl) && "format".equals(nm) || "java/lang/String".equals(cl) && "format".equals(nm) || "java/io/PrintStream".equals(cl) && "format".equals(nm) || "java/io/PrintStream".equals(cl) && "printf".equals(nm)) && VAMISMATCH_DEBUG) {
                    System.out.println("Oops: " + cl + "." + nm + " not a VARARGS");
                }
                this.fsState = 0;
            }
        }
    }

    boolean implementsRunnable(JavaClass obj) {
        if (obj.getSuperclassName().equals("java.lang.Thread")) {
            return true;
        }
        for (String s : obj.getInterfaceNames()) {
            if (!s.equals("java.lang.Runnable")) continue;
            return true;
        }
        return false;
    }
}

