/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Method;

public class InfiniteLoop
extends OpcodeStackDetector {
    private static final boolean active = true;
    ArrayList<BitSet> regModifiedAt = new ArrayList();
    BugReporter bugReporter;
    HashSet<Jump> backwardReach = new HashSet();
    HashSet<BackwardsBranch> backwardBranches = new HashSet();
    HashSet<ForwardConditionalBranch> forwardConditionalBranches = new HashSet();
    LinkedList<Jump> forwardJumps = new LinkedList();

    @NonNull
    BitSet getModifiedBitSet(int reg) {
        while (this.regModifiedAt.size() <= reg) {
            this.regModifiedAt.add(new BitSet());
        }
        return this.regModifiedAt.get(reg);
    }

    private void regModifiedAt(int reg, int pc) {
        BitSet b = this.getModifiedBitSet(reg);
        b.set(pc);
    }

    private void clearRegModified() {
        for (BitSet b : this.regModifiedAt) {
            b.clear();
        }
    }

    private boolean isRegModified(int reg, int firstPC, int lastPC) {
        if (reg < 0) {
            return false;
        }
        BitSet b = this.getModifiedBitSet(reg);
        int modified = b.nextSetBit(firstPC);
        return modified >= firstPC && modified <= lastPC;
    }

    void purgeForwardJumps(int before) {
    }

    void addForwardJump(int from, int to) {
        if (from >= to) {
            return;
        }
        this.purgeForwardJumps(from);
        this.forwardJumps.add(new Jump(from, to));
    }

    int getFurthestJump(int from) {
        int result = Integer.MIN_VALUE;
        int from2 = this.getBackwardsReach(from);
        assert (from2 <= from);
        from = from2;
        for (Jump f : this.forwardJumps) {
            if (f.from < from || f.to <= result) continue;
            result = f.to;
        }
        return result;
    }

    public InfiniteLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.clearRegModified();
        this.backwardBranches.clear();
        this.forwardConditionalBranches.clear();
        this.forwardJumps.clear();
        this.backwardReach.clear();
        super.visit(obj);
        block0: for (BackwardsBranch bb : this.backwardBranches) {
            int reg1;
            LinkedList<ForwardConditionalBranch> myForwardBranches = new LinkedList<ForwardConditionalBranch>();
            int myBackwardsReach = this.getBackwardsReach(bb.to);
            for (ForwardConditionalBranch fcb : this.forwardConditionalBranches) {
                if (myBackwardsReach >= fcb.from || fcb.from >= bb.from || bb.from >= fcb.to) continue;
                myForwardBranches.add(fcb);
            }
            if (myForwardBranches.size() != 1) continue;
            ForwardConditionalBranch fcb = (ForwardConditionalBranch)myForwardBranches.get(0);
            for (Jump fj : this.forwardJumps) {
                if (fcb.from == fj.from || myBackwardsReach >= fj.from || fj.from >= bb.from || bb.from >= fj.to) continue;
                continue block0;
            }
            if (!this.isConstant(fcb.item0, bb) || !this.isConstant(fcb.item1, bb)) continue;
            BugInstance bug = new BugInstance((Detector)this, "IL_INFINITE_LOOP", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, fcb.from).addSourceLine((BytecodeScanningDetector)this, bb.from).describe("SOURCE_LINE_LOOP_BOTTOM\t");
            int reg0 = fcb.item0.getRegisterNumber();
            boolean reg0Invariant = true;
            if (reg0 >= 0) {
                reg0Invariant = !this.isRegModified(reg0, myBackwardsReach, bb.from);
                bug.add((BugAnnotation)LocalVariableAnnotation.getLocalVariableAnnotation((Method)this.getMethod(), (int)reg0, (int)fcb.from, (int)bb.from)).addSourceLine((BytecodeScanningDetector)this, this.constantSince(fcb.item0)).describe("SOURCE_LINE_LAST_CHANGE");
            }
            if ((reg1 = fcb.item1.getRegisterNumber()) >= 0 && reg1 != reg0) {
                bug.add((BugAnnotation)LocalVariableAnnotation.getLocalVariableAnnotation((Method)this.getMethod(), (int)reg1, (int)fcb.from, (int)bb.from)).addSourceLine((BytecodeScanningDetector)this, this.constantSince(fcb.item1)).describe("SOURCE_LINE_LAST_CHANGE");
            }
            boolean reg1Invariant = true;
            if (reg1 >= 0) {
                boolean bl = reg1Invariant = !this.isRegModified(reg1, myBackwardsReach, bb.from);
            }
            if (!reg0Invariant || !reg1Invariant) continue;
            this.bugReporter.reportBug(bug);
        }
    }

    private boolean isConstant(OpcodeStack.Item item0, BackwardsBranch bb) {
        int reg = item0.getRegisterNumber();
        if (reg >= 0) {
            return bb.invariantRegisters.contains(reg) || reg >= bb.numLastUpdates;
        }
        return item0.getConstant() != null;
    }

    public void sawBranchTo(int target) {
        this.addForwardJump(this.getPC(), target);
    }

    public void sawOpcode(int seen) {
        if (this.isRegisterStore()) {
            this.regModifiedAt(this.getRegisterOperand(), this.getPC());
        }
        switch (seen) {
            case 167: {
                if (this.getBranchOffset() >= 0) break;
                BackwardsBranch bb = new BackwardsBranch(this.stack, this.getPC(), this.getBranchTarget());
                if (bb.invariantRegisters.size() > 0) {
                    this.backwardBranches.add(bb);
                }
                this.addBackwardsReach();
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.addForwardJump(this.getPC(), Integer.MAX_VALUE);
                break;
            }
            case 170: 
            case 171: {
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                if (this.getDefaultSwitchOffset() > 0) {
                    this.forwardConditionalBranches.add(new ForwardConditionalBranch(item0, item0, this.getPC(), this.getPC() + this.getDefaultSwitchOffset()));
                }
                for (int offset : this.getSwitchOffsets()) {
                    if (offset <= 0) continue;
                    this.forwardConditionalBranches.add(new ForwardConditionalBranch(item0, item0, this.getPC(), this.getPC() + offset));
                }
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.addBackwardsReach();
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                int target = this.getBranchTarget();
                if (this.getBranchOffset() > 0) {
                    this.forwardConditionalBranches.add(new ForwardConditionalBranch(item0, item0, this.getPC(), target));
                    break;
                }
                if (this.getFurthestJump(target) > this.getPC() || !this.constantSince(item0, target)) break;
                int since0 = this.constantSince(item0);
                BugInstance bug = new BugInstance((Detector)this, "IL_INFINITE_LOOP", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.getPC());
                int reg0 = item0.getRegisterNumber();
                if (reg0 >= 0) {
                    bug.add((BugAnnotation)LocalVariableAnnotation.getLocalVariableAnnotation((Method)this.getMethod(), (int)reg0, (int)this.getPC(), (int)target)).addSourceLine((BytecodeScanningDetector)this, since0);
                }
                if (reg0 >= 0 && this.isRegModified(reg0, target, this.getPC())) break;
                this.reportPossibleBug(bug);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                int reg1;
                this.addBackwardsReach();
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                int target = this.getBranchTarget();
                if (this.getBranchOffset() > 0) {
                    this.forwardConditionalBranches.add(new ForwardConditionalBranch(item0, item1, this.getPC(), target));
                    break;
                }
                if (this.getFurthestJump(target) > this.getPC() || !this.constantSince(item0, target) || !this.constantSince(item1, target)) break;
                BugInstance bug = new BugInstance((Detector)this, "IL_INFINITE_LOOP", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.getPC());
                int reg0 = item0.getRegisterNumber();
                if (reg0 >= 0) {
                    bug.add((BugAnnotation)LocalVariableAnnotation.getLocalVariableAnnotation((Method)this.getMethod(), (int)reg0, (int)this.getPC(), (int)target));
                }
                if ((reg1 = item1.getRegisterNumber()) >= 0) {
                    bug.add((BugAnnotation)LocalVariableAnnotation.getLocalVariableAnnotation((Method)this.getMethod(), (int)reg1, (int)this.getPC(), (int)target));
                }
                this.reportPossibleBug(bug);
            }
        }
    }

    private void addBackwardsReach() {
        if (this.getBranchOffset() >= 0) {
            return;
        }
        int target = this.getBranchTarget();
        for (Jump j : this.backwardReach) {
            if (j.to >= target || target > j.from) continue;
            target = j.to;
        }
        assert (target <= this.getBranchTarget());
        assert (target < this.getPC());
        Iterator<Jump> i = this.backwardReach.iterator();
        while (i.hasNext()) {
            Jump j;
            j = i.next();
            if (target > j.to || this.getPC() < j.from) continue;
            i.remove();
        }
        this.backwardReach.add(new Jump(this.getPC(), target));
    }

    private int getBackwardsReach(int target) {
        int originalTarget = target;
        for (Jump j : this.backwardReach) {
            if (j.to >= target || target > j.from) continue;
            target = j.to;
        }
        assert (target <= originalTarget);
        return target;
    }

    private boolean constantSince(OpcodeStack.Item item1, int branchTarget) {
        int reg = item1.getRegisterNumber();
        if (reg >= 0) {
            return this.stack.getLastUpdate(reg) < this.getBackwardsReach(branchTarget);
        }
        return item1.getConstant() != null;
    }

    private int constantSince(OpcodeStack.Item item1) {
        int reg = item1.getRegisterNumber();
        if (reg >= 0) {
            return this.stack.getLastUpdate(reg);
        }
        return Integer.MAX_VALUE;
    }

    void reportPossibleBug(BugInstance bug) {
        int catchSize = Util.getSizeOfSurroundingTryBlock((ConstantPool)this.getConstantPool(), (Code)this.getCode(), (String)"java/io/EOFException", (int)this.getPC());
        if (catchSize < Integer.MAX_VALUE) {
            bug.lowerPriorityALot();
        } else {
            catchSize = Util.getSizeOfSurroundingTryBlock((ConstantPool)this.getConstantPool(), (Code)this.getCode(), (String)"java/lang/NoSuchElementException", (int)this.getPC());
            if (catchSize < Integer.MAX_VALUE) {
                bug.lowerPriorityALot();
            } else {
                LocalVariableAnnotation lv = bug.getPrimaryLocalVariableAnnotation();
                if (lv == null && this.getMethodName().equals("run")) {
                    bug.lowerPriority();
                }
            }
        }
        this.bugReporter.reportBug(bug);
    }

    static class ForwardConditionalBranch
    extends Jump {
        final OpcodeStack.Item item0;
        final OpcodeStack.Item item1;

        ForwardConditionalBranch(OpcodeStack.Item item0, OpcodeStack.Item item1, int from, int to) {
            super(from, to);
            this.item0 = item0;
            this.item1 = item1;
        }

        public int hashCode() {
            return 37 * super.hashCode() + 17 * this.item0.hashCode() + this.item1.hashCode();
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            ForwardConditionalBranch that = (ForwardConditionalBranch)o;
            return this.item0.equals((Object)that.item0) && this.item1.equals((Object)that.item1);
        }
    }

    static class BackwardsBranch
    extends Jump {
        final List<Integer> invariantRegisters = new LinkedList<Integer>();
        final int numLastUpdates;

        BackwardsBranch(OpcodeStack stack, int from, int to) {
            super(from, to);
            this.numLastUpdates = stack.getNumLastUpdates();
            for (int i = 0; i < this.numLastUpdates; ++i) {
                if (stack.getLastUpdate(i) >= to) continue;
                this.invariantRegisters.add(i);
            }
        }

        public int hashCode() {
            return 37 * super.hashCode() + 17 * ((Object)this.invariantRegisters).hashCode() + this.numLastUpdates;
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            BackwardsBranch that = (BackwardsBranch)o;
            return ((Object)this.invariantRegisters).equals(that.invariantRegisters) && this.numLastUpdates == that.numLastUpdates;
        }
    }

    static class Jump {
        final int from;
        final int to;

        Jump(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return this.from + " -> " + this.to;
        }

        public int hashCode() {
            return this.from * 37 + this.to;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Jump that = (Jump)o;
            return this.from == that.from && this.to == that.to;
        }
    }
}

