/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SwitchHandler;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class SwitchFallthrough
extends OpcodeStackDetector
implements StatelessDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"switchFallthrough.debug");
    private static final boolean LOOK_IN_SOURCE_FOR_FALLTHRU_COMMENT = SystemProperties.getBoolean((String)"findbugs.sf.comment");
    private SwitchHandler switchHdlr;
    private boolean reachable;
    private BugReporter bugReporter;
    private int lastPC;
    private BitSet potentiallyDeadStores = new BitSet();
    private Set<XField> potentiallyDeadFields = new HashSet<XField>();
    private BitSet potentiallyDeadStoresFromBeforeFallthrough = new BitSet();
    private Set<XField> potentiallyDeadFieldsFromBeforeFallthrough = new HashSet<XField>();
    private LocalVariableAnnotation deadStore = null;
    private int priority;
    private int fallthroughDistance;
    Collection<SourceLineAnnotation> found = new LinkedList<SourceLineAnnotation>();

    public SwitchFallthrough(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void visit(Code obj) {
        this.reachable = false;
        this.lastPC = 0;
        this.found.clear();
        this.switchHdlr = new SwitchHandler();
        this.clearAll();
        this.deadStore = null;
        this.priority = 2;
        this.fallthroughDistance = 1000;
        super.visit(obj);
        if (!this.found.isEmpty()) {
            if (this.found.size() >= 4 && this.priority == 2) {
                this.priority = 3;
            }
            BugInstance bug = new BugInstance((Detector)this, "SF_SWITCH_FALLTHROUGH", this.priority).addClassAndMethod((PreorderVisitor)this).addAnnotations(this.found);
            this.bugReporter.reportBug(bug);
        }
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item obj;
        if (DEBUG) {
            System.out.println(this.getPC() + ": " + OPCODE_NAMES[seen] + " " + this.reachable + " " + this.switchHdlr.isOnSwitchOffset((DismantleBytecode)this));
        }
        if (this.reachable && this.switchHdlr.isOnSwitchOffset((DismantleBytecode)this)) {
            SourceLineAnnotation sourceLineAnnotation;
            if (DEBUG) {
                System.out.println("Fallthrough at : " + this.getPC() + ": " + OPCODE_NAMES[seen]);
            }
            this.fallthroughDistance = 0;
            this.potentiallyDeadStoresFromBeforeFallthrough = (BitSet)this.potentiallyDeadStores.clone();
            this.potentiallyDeadFieldsFromBeforeFallthrough = new HashSet<XField>(this.potentiallyDeadFields);
            if (!this.hasFallThruComment(this.lastPC + 1, this.getPC() - 1) && (sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstructionRange((ClassContext)this.getClassContext(), (PreorderVisitor)this, (int)this.lastPC, (int)this.getPC())) != null) {
                this.found.add(sourceLineAnnotation);
            }
        }
        if (SwitchFallthrough.isBranch((int)seen) || SwitchFallthrough.isSwitch((int)seen) || seen == 167 || seen == 176 || seen == 172 || seen == 177 || seen == 173 || seen == 175 || seen == 174) {
            this.clearAll();
        }
        if (seen == 180 && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item top = this.stack.getStackItem(0);
            if (top.getRegisterNumber() == 0) {
                this.potentiallyDeadFields.remove(this.getXFieldOperand());
            }
        } else if (seen == 181 && this.stack.getStackDepth() >= 2 && (obj = this.stack.getStackItem(1)).getRegisterNumber() == 0) {
            XField f = this.getXFieldOperand();
            if (this.potentiallyDeadFields.contains(f) && this.potentiallyDeadFieldsFromBeforeFallthrough.contains(f)) {
                this.priority = 1;
                BugInstance bug = new BugInstance((Detector)this, "SF_DEAD_STORE_DUE_TO_SWITCH_FALLTHROUGH", this.priority).addClassAndMethod((PreorderVisitor)this).addField(f).addSourceLine((BytecodeScanningDetector)this);
                this.bugReporter.reportBug(bug);
            }
            this.potentiallyDeadFields.add(f);
        }
        if (this.isRegisterLoad()) {
            this.potentiallyDeadStores.clear(this.getRegisterOperand());
        } else if (this.isRegisterStore() && !this.atCatchBlock()) {
            int register = this.getRegisterOperand();
            if (this.potentiallyDeadStores.get(register) && this.potentiallyDeadStoresFromBeforeFallthrough.get(register)) {
                this.priority = 1;
                this.deadStore = LocalVariableAnnotation.getLocalVariableAnnotation((Method)this.getMethod(), (int)register, (int)(this.getPC() - 1), (int)this.getPC());
                BugInstance bug = new BugInstance((Detector)this, "SF_DEAD_STORE_DUE_TO_SWITCH_FALLTHROUGH", this.priority).addClassAndMethod((PreorderVisitor)this).add((BugAnnotation)this.deadStore).addSourceLine((BytecodeScanningDetector)this);
                this.bugReporter.reportBug(bug);
            }
            this.potentiallyDeadStores.set(register);
        }
        switch (seen) {
            case 170: 
            case 171: {
                this.reachable = false;
                this.switchHdlr.enterSwitch((DismantleBytecode)this);
                break;
            }
            case 167: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: 
            case 200: {
                this.reachable = false;
                break;
            }
            case 184: {
                this.reachable = !"exit".equals(this.getNameConstantOperand()) || !"java/lang/System".equals(this.getClassConstantOperand());
                break;
            }
            default: {
                this.reachable = true;
            }
        }
        this.lastPC = this.getPC();
        ++this.fallthroughDistance;
    }

    private void clearAll() {
        this.potentiallyDeadStores.clear();
        this.potentiallyDeadStoresFromBeforeFallthrough.clear();
        this.potentiallyDeadFields.clear();
        this.potentiallyDeadFieldsFromBeforeFallthrough.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFallThruComment(int startPC, int endPC) {
        if (!LOOK_IN_SOURCE_FOR_FALLTHRU_COMMENT) return false;
        BufferedReader r = null;
        try {
            String line;
            int i;
            SourceLineAnnotation srcLine = SourceLineAnnotation.fromVisitedInstructionRange((BytecodeScanningDetector)this, (int)this.lastPC, (int)this.getPC());
            SourceFinder sourceFinder = AnalysisContext.currentAnalysisContext().getSourceFinder();
            SourceFile sourceFile = sourceFinder.findSourceFile(srcLine.getPackageName(), srcLine.getSourceFile());
            int startLine = srcLine.getStartLine();
            int numLines = srcLine.getEndLine() - startLine - 1;
            if (numLines <= 0) {
                boolean bl = false;
                return bl;
            }
            r = new BufferedReader(new InputStreamReader(sourceFile.getInputStream()));
            for (i = 0; i < startLine; ++i) {
                line = r.readLine();
                if (line != null) continue;
                boolean bl = false;
                return bl;
            }
            i = 0;
            while (i < numLines) {
                line = r.readLine();
                if (line == null) {
                    boolean bl = false;
                    return bl;
                }
                if ((line = line.toLowerCase()).indexOf("fall") >= 0 || line.indexOf("nobreak") >= 0) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

