/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassNotFoundExceptionParser;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentException;

public abstract class AbstractBugReporter
implements BugReporter {
    private static final boolean DEBUG = SystemProperties.getBoolean("abreporter.debug");
    private static final boolean DEBUG_MISSING_CLASSES = SystemProperties.getBoolean("findbugs.debug.missingclasses");
    private int verbosityLevel = 1;
    private int priorityThreshold;
    private boolean analysisUnderway;
    private boolean relaxed;
    private LinkedHashSet<String> missingClassMessageList = new LinkedHashSet();
    private Set<Error> errorSet = new HashSet<Error>();
    private List<BugReporterObserver> observerList = new LinkedList<BugReporterObserver>();
    private ProjectStats projectStats = new ProjectStats();
    private int errorCount;

    public void setErrorVerbosity(int level) {
        this.verbosityLevel = level;
    }

    public void setPriorityThreshold(int threshold) {
        this.priorityThreshold = threshold;
    }

    public final void reportBug(BugInstance bugInstance) {
        ClassAnnotation primaryClass;
        if (this.priorityThreshold == 0) {
            throw new IllegalStateException("Priority threshold not set");
        }
        if (!this.analysisUnderway) {
            if (FindBugsAnalysisFeatures.isRelaxedMode()) {
                this.relaxed = true;
            }
            this.analysisUnderway = true;
        }
        if ((primaryClass = bugInstance.getPrimaryClass()) != null && !AnalysisContext.currentAnalysisContext().isApplicationClass(primaryClass.getClassName())) {
            if (DEBUG) {
                System.out.println("AbstractBugReporter: Filtering due to non-primary class");
            }
            return;
        }
        if (bugInstance.getPriority() <= this.priorityThreshold || this.relaxed) {
            this.doReportBug(bugInstance);
        } else if (DEBUG) {
            System.out.println("AbstractBugReporter: Filtering due to priorityThreshold " + bugInstance.getPriority() + " > " + this.priorityThreshold);
        }
    }

    public final void reportBugsFromXml(InputStream in, Project theProject) throws IOException, DocumentException {
        SortedBugCollection theCollection = new SortedBugCollection();
        theCollection.readXML(in, theProject);
        for (BugInstance bug : theCollection.getCollection()) {
            this.doReportBug(bug);
        }
    }

    public static String getMissingClassName(ClassNotFoundException ex) {
        String className;
        String message = ex.getMessage();
        if (message == null) {
            message = "";
        }
        if ((className = ClassNotFoundExceptionParser.getMissingClassName(ex)) != null) {
            if (className.indexOf(47) >= 0) {
                className = className.replace('/', '.');
            }
            return className;
        }
        return message;
    }

    public void reportMissingClass(ClassNotFoundException ex) {
        if (DEBUG_MISSING_CLASSES) {
            System.out.println("Missing class: " + ex.toString());
            ex.printStackTrace(System.out);
        }
        if (this.verbosityLevel == 0) {
            return;
        }
        String message = AbstractBugReporter.getMissingClassName(ex);
        if (message.startsWith("[")) {
            return;
        }
        if (message.trim().equals("")) {
            return;
        }
        assert (message.indexOf(60) == -1) : "message is " + message;
        this.logMissingClass(message);
    }

    public void reportMissingClass(ClassDescriptor classDescriptor) {
        if (DEBUG_MISSING_CLASSES) {
            System.out.println("Missing class: " + classDescriptor);
            new Throwable().printStackTrace(System.out);
        }
        if (this.verbosityLevel == 0) {
            return;
        }
        String dottedClassName = classDescriptor.toDottedClassName();
        if (dottedClassName.charAt(0) == '[') {
            return;
        }
        if (dottedClassName.endsWith("package-info")) {
            return;
        }
        this.logMissingClass(dottedClassName);
    }

    private void logMissingClass(String message) {
        if (message == null || message.length() == 0) {
            throw new AssertionError((Object)("Bad missing class" + message));
        }
        if (message.charAt(0) == '[' || message.endsWith(".package-info")) {
            return;
        }
        this.missingClassMessageList.add(message);
    }

    public void reportSkippedAnalysis(MethodDescriptor method) {
    }

    public void logError(String message) {
        Error error;
        if (this.verbosityLevel == 0) {
            return;
        }
        if (!this.errorSet.contains(error = new Error(this.errorCount++, message))) {
            this.errorSet.add(error);
        }
    }

    public void logError(String message, Throwable e) {
        Error error;
        if (e instanceof MethodUnprofitableException) {
            return;
        }
        if (e instanceof edu.umd.cs.findbugs.classfile.MissingClassException) {
            edu.umd.cs.findbugs.classfile.MissingClassException e2 = (edu.umd.cs.findbugs.classfile.MissingClassException)e;
            this.reportMissingClass(e2.getClassDescriptor());
            return;
        }
        if (e instanceof MissingClassException) {
            MissingClassException missingClassEx = (MissingClassException)e;
            ClassNotFoundException cnfe = missingClassEx.getClassNotFoundException();
            this.reportMissingClass(cnfe);
            return;
        }
        if (this.verbosityLevel == 0) {
            return;
        }
        if (!this.errorSet.contains(error = new Error(this.errorCount++, message, e))) {
            this.errorSet.add(error);
        }
    }

    public void reportQueuedErrors() {
        Error[] errorList = this.errorSet.toArray(new Error[this.errorSet.size()]);
        Arrays.sort(errorList, new Comparator<Error>(){

            @Override
            public int compare(Error o1, Error o2) {
                return o1.getSequence() - o2.getSequence();
            }
        });
        for (Error error : errorList) {
            this.reportAnalysisError(new AnalysisError(error.getMessage(), error.getCause()));
        }
        for (String aMissingClassMessageList : this.missingClassMessageList) {
            this.reportMissingClass(aMissingClassMessageList);
        }
    }

    public void addObserver(BugReporterObserver observer) {
        this.observerList.add(observer);
    }

    public ProjectStats getProjectStats() {
        return this.projectStats;
    }

    protected void notifyObservers(BugInstance bugInstance) {
        for (BugReporterObserver aObserverList : this.observerList) {
            aObserverList.reportBug(bugInstance);
        }
    }

    protected abstract void doReportBug(BugInstance var1);

    public abstract void reportAnalysisError(AnalysisError var1);

    public abstract void reportMissingClass(String var1);

    private static class Error {
        private int sequence;
        private String message;
        private Throwable cause;

        public Error(int sequence, String message) {
            this(sequence, message, null);
        }

        public Error(int sequence, String message, Throwable cause) {
            this.sequence = sequence;
            this.message = message;
            this.cause = cause;
        }

        public int getSequence() {
            return this.sequence;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public int hashCode() {
            int hashCode = this.message.hashCode();
            if (this.cause != null) {
                hashCode += 1009 * this.cause.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Error other = (Error)obj;
            if (!this.message.equals(other.message)) {
                return false;
            }
            if (this.cause == other.cause) {
                return true;
            }
            if (this.cause == null || other.cause == null) {
                return false;
            }
            return this.cause.equals(other.cause);
        }
    }
}

