/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

public class CheckBcel {
    private static boolean isFinal(Class c) {
        return (c.getModifiers() & 0x10) != 0;
    }

    private static void error(String cname) {
        System.err.println("BCEL class compatability error.");
        System.err.println("The version of class " + cname + " found was not compatible with\n" + "FindBugs.  Please remove any BCEL libraries that may be interfering.  This may happen\n" + "if you have an old version of BCEL or a library that includes an old version of BCEL\n" + "in an \"endorsed\" directory.");
    }

    public static boolean check() {
        Class<?> repository;
        Class<?> emptyVis;
        Class<?> constants;
        Class<?> type;
        Class<?> objectType;
        try {
            objectType = Class.forName("org.apache.bcel.generic.ObjectType");
            type = Class.forName("org.apache.bcel.generic.Type");
            constants = Class.forName("org.apache.bcel.Constants");
            emptyVis = Class.forName("org.apache.bcel.generic.EmptyVisitor");
            repository = Class.forName("org.apache.bcel.util.Repository");
        }
        catch (ClassNotFoundException e) {
            System.out.println("One or more required BCEL classes were missing.");
            return false;
        }
        if (CheckBcel.isFinal(objectType)) {
            CheckBcel.error("org.apache.bcel.generic.ObjectType");
            return false;
        }
        if (CheckBcel.isFinal(type)) {
            CheckBcel.error("org.apache.bcel.generic.Type");
            return false;
        }
        if (CheckBcel.isFinal(constants)) {
            CheckBcel.error("org.apache.bcel.Constants");
            return false;
        }
        if (CheckBcel.isFinal(emptyVis)) {
            CheckBcel.error("org.apache.bcel.generic.EmptyVisitor");
            return false;
        }
        if (CheckBcel.isFinal(repository)) {
            CheckBcel.error("org.apache.bcel.util.Repository");
            return false;
        }
        return true;
    }
}

