/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.RunnableWithExceptions;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;

public class JUnitDetectorAdapter
implements Detector2 {
    private Throwable throwable;
    private boolean testExecuted;
    private static InheritableThreadLocal<JUnitDetectorAdapter> instance = new InheritableThreadLocal();
    private static InheritableThreadLocal<RunnableWithExceptions> runnableInstance = new InheritableThreadLocal();

    public JUnitDetectorAdapter(BugReporter bugReporter) {
        instance.set(this);
    }

    public static JUnitDetectorAdapter instance() {
        return (JUnitDetectorAdapter)instance.get();
    }

    public static void setRunnable(RunnableWithExceptions runnable) {
        runnableInstance.set(runnable);
    }

    public void finishTest() throws Exception {
        if (this.throwable instanceof Exception) {
            throw (Exception)this.throwable;
        }
        if (this.throwable instanceof Error) {
            throw (Error)this.throwable;
        }
        if (this.throwable != null) {
            throw new Error(this.throwable);
        }
    }

    public void finishPass() {
    }

    public String getDetectorClassName() {
        return this.getClass().getName();
    }

    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        if (this.testExecuted) {
            return;
        }
        this.testExecuted = true;
        try {
            ((RunnableWithExceptions)runnableInstance.get()).run();
        }
        catch (Throwable e) {
            this.throwable = e;
        }
    }
}

