/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DebugRepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFGPrinter {
    private CFG cfg;
    private boolean isForwards;

    public CFGPrinter(CFG cfg) {
        this.cfg = cfg;
        this.isForwards = true;
    }

    public void setIsForwards(boolean isForwards) {
        this.isForwards = isForwards;
    }

    public boolean isForwards() {
        return this.isForwards;
    }

    public void print(PrintStream out) {
        Iterator<BasicBlock> i = this.cfg.blockIterator();
        while (i.hasNext()) {
            Iterator edgeIter;
            CodeExceptionGen exceptionGen;
            BasicBlock bb = i.next();
            out.println();
            out.println("BASIC BLOCK: " + bb.getLabel() + (bb.isExceptionThrower() ? " [EXCEPTION THROWER]" : "") + this.blockStartAnnotate(bb));
            if (bb.isExceptionThrower()) {
                out.println("  Exception thrower: " + bb.getExceptionThrower());
            }
            if ((exceptionGen = bb.getExceptionGen()) != null) {
                out.println("\tCATCHES " + exceptionGen.getCatchType());
            }
            Iterator<InstructionHandle> j = this.instructionIterator(bb);
            while (j.hasNext()) {
                InstructionHandle handle = j.next();
                out.println(handle + this.instructionAnnotate(handle, bb));
            }
            out.println("END" + this.blockAnnotate(bb));
            Iterator iterator = edgeIter = this.isForwards ? this.cfg.outgoingEdgeIterator(bb) : this.cfg.incomingEdgeIterator(bb);
            while (edgeIter.hasNext()) {
                Edge edge = (Edge)edgeIter.next();
                out.println("  " + edge.formatAsString(!this.isForwards) + " " + this.edgeAnnotate(edge));
            }
        }
    }

    public String edgeAnnotate(Edge edge) {
        return "";
    }

    public String blockStartAnnotate(BasicBlock block) {
        return "";
    }

    public String blockAnnotate(BasicBlock block) {
        return "";
    }

    public String instructionAnnotate(InstructionHandle handle, BasicBlock bb) {
        return "";
    }

    protected Iterator<InstructionHandle> instructionIterator(BasicBlock bb) {
        if (this.isForwards) {
            return bb.instructionIterator();
        }
        return bb.instructionReverseIterator();
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length == 0 || argv.length > 2) {
            System.out.println("Usage: " + CFGPrinter.class.getName() + " <class file> [outputFile]");
            System.exit(1);
        }
        String className = argv[0];
        JavaClass cls = new ClassParser(className).parse();
        DebugRepositoryLookupFailureCallback lookupFailureCallback = new DebugRepositoryLookupFailureCallback();
        AnalysisContext analysisContext = AnalysisContext.create(lookupFailureCallback);
        ClassContext classContext = analysisContext.getClassContext(cls);
        Method[] methods = cls.getMethods();
        String methodName = SystemProperties.getProperty("cfg.method");
        PrintStream out = System.err;
        if (argv.length == 2) {
            out = new PrintStream(new FileOutputStream(argv[1]));
        }
        for (Method method : methods) {
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || methodName != null && !method.getName().equals(methodName)) continue;
            out.println();
            out.println("----------------------------------------------------------------------------");
            out.println("Method " + SignatureConverter.convertMethodSignature(methodGen));
            out.println("----------------------------------------------------------------------------");
            CFG cfg = classContext.getCFG(method);
            CFGPrinter printer = new CFGPrinter(cfg);
            printer.print(out);
        }
    }
}

