/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.ba.obl.NonexistentObligationException;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.ObligationSet;
import edu.umd.cs.findbugs.ba.obl.State;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateSet {
    private boolean isTop = false;
    private boolean isBottom = false;
    private Map<ObligationSet, State> stateMap = new HashMap<ObligationSet, State>();
    private ObligationFactory factory;

    public StateSet(ObligationFactory factory) {
        this.factory = factory;
    }

    public void setTop() {
        this.isTop = true;
        this.isBottom = false;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public void setBottom() {
        this.isBottom = true;
        this.isTop = false;
    }

    public boolean isBottom() {
        return this.isBottom;
    }

    public boolean isValid() {
        return !this.isTop && !this.isBottom;
    }

    public Iterator<State> stateIterator() {
        return this.stateMap.values().iterator();
    }

    public State getStateWithObligationSet(ObligationSet obligationSet) {
        return this.stateMap.get(obligationSet);
    }

    public void initEntryFact(ObligationFactory factory) {
        this.isBottom = false;
        this.isTop = false;
        this.stateMap.clear();
        State initState = new State(factory.getMaxObligationTypes(), factory);
        this.stateMap.put(initState.getObligationSet(), initState);
    }

    public void copyFrom(StateSet other) {
        this.isTop = other.isTop;
        this.isBottom = other.isBottom;
        this.stateMap.clear();
        for (State state : other.stateMap.values()) {
            State dup = state.duplicate();
            this.stateMap.put(dup.getObligationSet(), dup);
        }
    }

    public StateSet duplicate() {
        StateSet dup = new StateSet(this.factory);
        dup.copyFrom(this);
        return dup;
    }

    public void addObligation(final Obligation obligation) {
        final HashMap<ObligationSet, State> updatedStateMap = new HashMap<ObligationSet, State>();
        try {
            this.applyToAllStatesAndUpdateMap(new StateCallback(){

                public void apply(State state) {
                    state.getObligationSet().add(obligation);
                    updatedStateMap.put(state.getObligationSet(), state);
                }
            }, updatedStateMap);
        }
        catch (NonexistentObligationException nonexistentObligationException) {
            // empty catch block
        }
    }

    public void deleteObligation(final Obligation obligation) throws NonexistentObligationException {
        final HashMap<ObligationSet, State> updatedStateMap = new HashMap<ObligationSet, State>();
        this.applyToAllStatesAndUpdateMap(new StateCallback(){

            public void apply(State state) throws NonexistentObligationException {
                state.getObligationSet().remove(obligation);
                updatedStateMap.put(state.getObligationSet(), state);
            }
        }, updatedStateMap);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StateSet other = (StateSet)o;
        return this.isTop == other.isTop && this.isBottom == other.isBottom && ((Object)this.stateMap).equals(other.stateMap);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.isTop) {
            return "TOP";
        }
        if (this.isBottom) {
            return "BOTTOM";
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        Iterator<State> i = this.stateIterator();
        while (i.hasNext()) {
            State state = i.next();
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(state.toString());
        }
        return buf.toString();
    }

    public Map<ObligationSet, State> createEmptyMap() {
        return new HashMap<ObligationSet, State>();
    }

    public void applyToAllStatesAndUpdateMap(StateCallback callback, Map<ObligationSet, State> updatedStateMap) throws NonexistentObligationException {
        this.applyToAllStates(callback);
        this.stateMap = updatedStateMap;
    }

    public void applyToAllStates(StateCallback callback) throws NonexistentObligationException {
        for (State state : this.stateMap.values()) {
            callback.apply(state);
        }
    }

    public static interface StateCallback {
        public void apply(State var1) throws NonexistentObligationException;
    }
}

