/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.log;

import edu.umd.cs.findbugs.SystemProperties;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profiler {
    static final boolean REPORT = SystemProperties.getBoolean("profiler.report");
    private static Profiler instance = new Profiler();
    ThreadLocal<Stack<Clock>> startTimes = new ThreadLocal<Stack<Clock>>(){

        @Override
        public Stack<Clock> initialValue() {
            return new Stack<Clock>();
        }
    };
    ConcurrentHashMap<Class<?>, AtomicLong> profile = new ConcurrentHashMap();

    private Profiler() {
    }

    public static Profiler getInstance() {
        return instance;
    }

    public void start(Class<?> c) {
        long currentNanoTime = System.nanoTime();
        Stack<Clock> stack = this.startTimes.get();
        if (!stack.isEmpty()) {
            stack.peek().accumulateTime(currentNanoTime);
        }
        stack.push(new Clock(c, currentNanoTime));
    }

    public void end(Class<?> c) {
        AtomicLong counter2;
        long accumulatedTime;
        long currentNanoTime = System.nanoTime();
        Stack<Clock> stack = this.startTimes.get();
        Clock ending = stack.pop();
        if (ending.clazz != c) {
            throw new AssertionError((Object)("Asked to end timing for " + c + " but top of stack is " + ending.clazz + ", remaining stack is " + stack));
        }
        ending.accumulateTime(currentNanoTime);
        if (!stack.isEmpty()) {
            Clock restarting = stack.peek();
            restarting.restartClock(currentNanoTime);
        }
        if ((accumulatedTime = ending.accumulatedTime) == 0L) {
            return;
        }
        AtomicLong counter = this.profile.get(c);
        if (counter == null && (counter2 = this.profile.putIfAbsent(c, counter = new AtomicLong())) != null) {
            counter = counter2;
        }
        counter.addAndGet(accumulatedTime);
    }

    public void report() {
        if (!REPORT) {
            return;
        }
        try {
            Comparator c = new Comparator<Pair<Class<?>, AtomicLong>>(){

                @Override
                public int compare(Pair<Class<?>, AtomicLong> o1, Pair<Class<?>, AtomicLong> o2) {
                    long v2;
                    long v1 = ((AtomicLong)o1.second).get();
                    if (v1 < (v2 = ((AtomicLong)o2.second).get())) {
                        return -1;
                    }
                    if (v1 > v2) {
                        return 1;
                    }
                    return ((Class)o1.first).getName().compareTo(((Class)o2.first).getName());
                }
            };
            TreeSet treeSet = new TreeSet(c);
            for (Map.Entry<Class<?>, AtomicLong> e : this.profile.entrySet()) {
                treeSet.add(new Pair(e.getKey(), e.getValue()));
            }
            Pair prev = null;
            for (Pair pair : treeSet) {
                System.out.printf("%7d  %s\n", ((AtomicLong)pair.second).get() / 1000000L, ((Class)pair.first).getSimpleName());
                prev = pair;
            }
        }
        catch (RuntimeException e) {
            System.out.println(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<V1, V2> {
        final V1 first;
        final V2 second;

        Pair(V1 first, V2 second) {
            this.first = first;
            this.second = second;
        }

        public String toString() {
            return this.first + ":" + this.second;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Clock {
        final Class<?> clazz;
        long startTimeNanos;
        long accumulatedTime;

        Clock(Class<?> clazz, long currentNanoTime) {
            this.clazz = clazz;
            this.startTimeNanos = currentNanoTime;
        }

        void accumulateTime(long currentNanoTime) {
            this.accumulatedTime += currentNanoTime - this.startTimeNanos;
        }

        void restartClock(long currentNanoTime) {
            this.startTimeNanos = currentNanoTime;
        }
    }
}

