/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.builder.ResourceUtils;
import edu.umd.cs.findbugs.plugin.eclipse.util.MutexSchedulingRule;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsAction
implements IObjectActionDelegate {
    protected ISelection selection;
    protected boolean usedInEditor;

    public final void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public final void selectionChanged(IAction action, ISelection newSelection) {
        if (!this.usedInEditor) {
            this.selection = newSelection;
        }
    }

    public void run(IAction action) {
        if (!this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)this.selection;
            if (this.selection.isEmpty()) {
                return;
            }
            Map<IProject, List<IResource>> projectMap = ResourceUtils.getResourcesPerProject(sSelection);
            Set<IProject> keySet = projectMap.keySet();
            for (IProject project : keySet) {
                this.work(project, projectMap.get(project));
            }
        }
    }

    protected final void work(final IProject project, final List<IResource> resources) {
        Job runFindBugs = new Job("Finding bugs in " + project.getName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    FindBugsWorker worker = new FindBugsWorker(project, monitor);
                    worker.work(resources);
                }
                catch (CoreException e) {
                    FindbugsPlugin.getDefault().logException(e, "Analysis exception");
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        runFindBugs.setUser(true);
        runFindBugs.setPriority(40);
        runFindBugs.setRule((ISchedulingRule)new MutexSchedulingRule(project));
        runFindBugs.schedule();
    }
}

