/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.ResourceUtils;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.util.Util;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.workflow.Update;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsWorker {
    public static boolean DEBUG;
    private IProgressMonitor monitor;
    private UserPreferences userPrefs;
    private IProject project;
    private IJavaProject javaProject;

    public FindBugsWorker(IProject project, IProgressMonitor monitor) throws CoreException {
        this.project = project;
        this.javaProject = JavaCore.create((IProject)project);
        if (this.javaProject == null || !this.javaProject.exists() || !this.javaProject.getProject().isOpen()) {
            throw new CoreException((IStatus)new Status(4, "edu.umd.cs.findbugs.plugin.eclipse", 4, "Java project is not open or does not exist: " + project, null));
        }
        this.monitor = monitor;
        try {
            this.userPrefs = FindbugsPlugin.getUserPreferences(project);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not get selected detectors for project");
            throw e;
        }
    }

    public void work(List<IResource> resources) throws CoreException {
        String[] classPathEntries;
        if (resources == null || resources.isEmpty()) {
            FindbugsPlugin.getDefault().logInfo("No resources to analyse for project " + this.project);
            return;
        }
        if (DEBUG) {
            System.out.println(resources);
        }
        this.clearMarkers(resources);
        Project findBugsProject = new Project();
        findBugsProject.setProjectName(this.javaProject.getElementName());
        Reporter bugReporter = new Reporter(this.javaProject, this.monitor);
        bugReporter.setPriorityThreshold(this.userPrefs.getUserDetectorThreshold());
        FindBugs.setHome((String)FindbugsPlugin.getFindBugsEnginePluginLocation());
        Map<IPath, IPath> outLocations = this.createOutputLocations();
        HashMap<File, String> outputFiles = new HashMap<File, String>();
        this.collectClassFilesPatterns(resources, outLocations, outputFiles);
        this.configureOutputFiles(findBugsProject, outputFiles);
        for (String entry : classPathEntries = this.createAuxClasspath()) {
            findBugsProject.addAuxClasspathEntry(entry);
        }
        FindBugs2 findBugs = new FindBugs2();
        findBugs.setNoClassOk(true);
        findBugs.setBugReporter((BugReporter)bugReporter);
        findBugs.setProject(findBugsProject);
        findBugs.setProgressCallback((FindBugsProgress)bugReporter);
        findBugs.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        findBugs.setUserPreferences(this.userPrefs);
        findBugs.setAnalysisFeatureSettings(this.userPrefs.getAnalysisFeatureSettings());
        this.configureExtendedProps(this.userPrefs.getIncludeFilterFiles(), (IFindBugsEngine)findBugs, true, false);
        this.configureExtendedProps(this.userPrefs.getExcludeFilterFiles(), (IFindBugsEngine)findBugs, false, false);
        this.configureExtendedProps(this.userPrefs.getExcludeBugsFiles(), (IFindBugsEngine)findBugs, false, true);
        this.runFindBugs(findBugs);
        boolean incremental = !(resources.get(0) instanceof IProject);
        this.updateBugCollection(findBugsProject, bugReporter, incremental);
    }

    public void loadXml(String fileName) throws CoreException {
        if (fileName == null) {
            return;
        }
        this.clearMarkers(null);
        Project findBugsProject = new Project();
        Reporter bugReporter = new Reporter(this.javaProject, this.monitor);
        bugReporter.setPriorityThreshold(this.userPrefs.getUserDetectorThreshold());
        this.reportFromXml(fileName, findBugsProject, bugReporter);
        this.updateBugCollection(findBugsProject, bugReporter, false);
    }

    private void clearMarkers(List<IResource> files) throws CoreException {
        if (files == null) {
            this.project.deleteMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
            return;
        }
        for (IResource res : files) {
            if (res == null) continue;
            res.deleteMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
        }
    }

    private void collectClassFilesPatterns(List<IResource> resources, Map<IPath, IPath> outLocations, Map<File, String> outputFiles) {
        for (IResource resource : resources) {
            if (Util.isJavaFile(resource)) {
                this.addClassPatternsFromFile((IFile)resource, outLocations, outputFiles);
                continue;
            }
            if (resource instanceof IFolder) {
                this.addClassPatternsFromFolder((IFolder)resource, outLocations, outputFiles);
                continue;
            }
            if (!(resource instanceof IProject)) continue;
            this.addClassPatternsFromProject(outLocations, outputFiles);
        }
    }

    private void addClassPatternsFromFolder(IFolder folder, Map<IPath, IPath> outLocations, Map<File, String> outputFiles) {
        IPath path = folder.getLocation();
        IPath srcRoot = this.getMatchingSourceRoot(path, outLocations);
        if (srcRoot == null) {
            return;
        }
        IPath outputRoot = outLocations.get(srcRoot);
        int firstSegments = path.matchingFirstSegments(srcRoot);
        IPath out = outputRoot.append(path.removeFirstSegments(firstSegments));
        outputFiles.put(out.toFile(), ".*\\.class");
    }

    private void addClassPatternsFromProject(Map<IPath, IPath> outLocations, Map<File, String> outputFiles) {
        Set<Map.Entry<IPath, IPath>> entrySet = outLocations.entrySet();
        for (Map.Entry<IPath, IPath> entry : entrySet) {
            outputFiles.put(entry.getValue().toFile(), ".*\\.class");
        }
    }

    private void addClassPatternsFromFile(IFile file, Map<IPath, IPath> outLocations, Map<File, String> outputFiles) {
        IPath path = file.getLocation();
        IPath srcRoot = this.getMatchingSourceRoot(path, outLocations);
        IPath outputRoot = outLocations.get(srcRoot);
        int firstSegments = path.matchingFirstSegments(srcRoot);
        IPath out = outputRoot.append(path.removeFirstSegments(firstSegments));
        String fileName = path.removeFileExtension().lastSegment();
        String namePattern = fileName + "\\.class|" + fileName + "\\$.*\\.class";
        namePattern = this.addSecondaryTypesToPattern(file, fileName, namePattern);
        File directory = out.removeLastSegments(1).toFile();
        String filesPattern = outputFiles.get(directory);
        if (filesPattern != null) {
            namePattern = namePattern + "|" + filesPattern;
        }
        outputFiles.put(directory, namePattern);
    }

    private String addSecondaryTypesToPattern(IFile file, String fileName, String classNamePattern) {
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
        if (cu == null) {
            FindbugsPlugin.getDefault().logError("NULL compilation unit for " + file + ", FB analysis might  be incomplete for included types");
            return classNamePattern;
        }
        try {
            IType[] types = cu.getTypes();
            if (types.length > 1) {
                for (IType type : types) {
                    if (fileName.equals(type.getElementName())) continue;
                    classNamePattern = classNamePattern + "|" + type.getElementName() + "\\.class|" + type.getElementName() + "\\$.*\\.class";
                }
            }
        }
        catch (JavaModelException e) {
            FindbugsPlugin.getDefault().logException(e, "Cannot get types from compilation unit: " + cu);
        }
        return classNamePattern;
    }

    private IPath getMatchingSourceRoot(IPath srcPath, Map<IPath, IPath> outLocations) {
        Set<Map.Entry<IPath, IPath>> outEntries = outLocations.entrySet();
        IPath result = null;
        int maxSegments = 0;
        for (Map.Entry<IPath, IPath> entry : outEntries) {
            IPath srcRoot = entry.getKey();
            int firstSegments = srcPath.matchingFirstSegments(srcRoot);
            if (firstSegments <= maxSegments || firstSegments != srcRoot.segmentCount()) continue;
            maxSegments = firstSegments;
            result = srcRoot;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFindBugs(FindBugs2 findBugs) {
        try {
            findBugs.execute();
        }
        catch (InterruptedException e) {
            if (DEBUG) {
                FindbugsPlugin.getDefault().logException(e, "Worker interrupted");
            }
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Error performing FindBugs analysis");
        }
        finally {
            findBugs.dispose();
        }
    }

    private void configureOutputFiles(Project findBugsProject, Map<File, String> outputFiles) {
        for (Map.Entry<File, String> entry : outputFiles.entrySet()) {
            File source = entry.getKey();
            Pattern classNamesPattern = Pattern.compile(entry.getValue());
            ResourceUtils.addFiles(findBugsProject, source, classNamesPattern);
        }
        outputFiles.clear();
    }

    private void updateBugCollection(Project findBugsProject, Reporter bugReporter, boolean incremental) {
        try {
            SortedBugCollection oldBugCollection = FindbugsPlugin.getBugCollection(this.project, this.monitor);
            SortedBugCollection newBugCollection = bugReporter.getBugCollection();
            SortedBugCollection resultCollection = this.mergeBugCollections(oldBugCollection, newBugCollection, incremental);
            resultCollection.setTimestamp(System.currentTimeMillis());
            FindbugsPlugin.storeBugCollection(this.project, resultCollection, findBugsProject, this.monitor);
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Error performing FindBugs results update");
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Error performing FindBugs results update");
        }
    }

    private SortedBugCollection mergeBugCollections(SortedBugCollection firstCollection, SortedBugCollection secondCollection, boolean incremental) {
        Update update = new Update();
        return (SortedBugCollection)update.mergeCollections((BugCollection)firstCollection, (BugCollection)secondCollection, false, incremental);
    }

    private void configureExtendedProps(Collection<String> filterFiles, IFindBugsEngine findBugs, boolean include, boolean bugsFilter) {
        for (String fileName : filterFiles) {
            IFile file = this.project.getFile(fileName);
            if (file.exists()) {
                String filterName = file.getLocation().toOSString();
                try {
                    if (bugsFilter) {
                        findBugs.excludeBaselineBugs(filterName);
                        continue;
                    }
                    findBugs.addFilter(filterName, include);
                }
                catch (RuntimeException e) {
                    FindbugsPlugin.getDefault().logException(e, "Error while loading filter \"" + filterName + "\".");
                }
                catch (DocumentException e) {
                    FindbugsPlugin.getDefault().logException(e, "Error while loading excluded bugs \"" + filterName + "\".");
                }
                catch (IOException e) {
                    FindbugsPlugin.getDefault().logException(e, "Error while reading filter \"" + filterName + "\".");
                }
                continue;
            }
            FindbugsPlugin.getDefault().logWarning("Include filter not found: " + fileName);
        }
    }

    private String[] createAuxClasspath() {
        String[] classPath = new String[]{};
        try {
            classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)this.javaProject);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not compute aux. classpath for project " + this.javaProject);
        }
        return classPath;
    }

    private Map<IPath, IPath> createOutputLocations() throws CoreException {
        HashMap<IPath, IPath> srcToOutputMap = new HashMap<IPath, IPath>();
        IPath defaultOutputLocation = ResourceUtils.relativeToAbsolute(this.javaProject.getOutputLocation());
        IClasspathEntry[] entries = this.javaProject.getResolvedClasspath(true);
        for (int i = 0; i < entries.length; ++i) {
            IClasspathEntry classpathEntry = entries[i];
            if (classpathEntry.getEntryKind() != 3) continue;
            IPath outputLocation = classpathEntry.getOutputLocation();
            outputLocation = outputLocation != null ? ResourceUtils.relativeToAbsolute(outputLocation) : defaultOutputLocation;
            IPath srcLocation = ResourceUtils.relativeToAbsolute(classpathEntry.getPath());
            srcToOutputMap.put(srcLocation, outputLocation);
        }
        return srcToOutputMap;
    }

    private void reportFromXml(String xmlFileName, Project findBugsProject, Reporter bugReporter) {
        if (!"".equals(xmlFileName)) {
            try {
                FileInputStream input = new FileInputStream(xmlFileName);
                bugReporter.reportBugsFromXml(input, findBugsProject);
            }
            catch (FileNotFoundException e) {
                FindbugsPlugin.getDefault().logException(e, "XML file not found: " + xmlFileName);
            }
            catch (DocumentException e) {
                FindbugsPlugin.getDefault().logException(e, "Invalid XML file: " + xmlFileName);
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Error loading FindBugs results xml file: " + xmlFileName);
            }
        }
    }
}

