/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.properties.FindbugsPropertyPage;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.plugin.eclipse.util.FileSelectionDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFilesTab
extends Composite {
    private final FindbugsPropertyPage propertyPage;

    public FilterFilesTab(TabFolder parent, FindbugsPropertyPage page, int style) {
        super((Composite)parent, style);
        this.propertyPage = page;
        this.setLayout((Layout)new GridLayout(2, true));
        TabItem tabDetector = new TabItem(parent, 0);
        tabDetector.setText(this.getMessage("property.filterFilesTab"));
        tabDetector.setControl((Control)this);
        tabDetector.setToolTipText("Configure external bug reporting filters");
        this.createFilterTable(this, FilterKind.INCLUDE);
        this.createFilterTable(this, FilterKind.EXCLUDE);
        this.createFilterTable(this, FilterKind.EXCLUDE_BUGS);
    }

    protected String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }

    private void createFilterTable(Composite parent, final FilterKind kind) {
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label titleLabel = new Label(tableComposite, 0);
        final String title = this.getMessage(kind.propertyName);
        titleLabel.setText(title);
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        final TableViewer viewer = new TableViewer(tableComposite, 2818);
        viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        Collection<String> filterFiles = kind.selectedFiles(this.propertyPage.getCurrentUserPreferences());
        final ArrayList<FilePlaceHolder> filters = new ArrayList<FilePlaceHolder>();
        final IProject project = this.propertyPage.getProject();
        if (filterFiles != null) {
            for (String s : filterFiles) {
                filters.add(new FilePlaceHolder(project.getFile(s)));
            }
        }
        viewer.add(filters.toArray());
        final Button addButton = new Button(tableComposite, 8);
        String addButtonLabel = this.getMessage(kind.propertyName + "addbutton");
        addButton.setText(addButtonLabel);
        addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        final UserPreferences currentUserPreferences = this.propertyPage.getCurrentUserPreferences();
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionDialog dialog = new FileSelectionDialog(addButton.getShell(), title, ".xml");
                dialog.setInput(project);
                dialog.setAllowMultiple(true);
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        for (int i = 0; i < selection.length; ++i) {
                            IFile f;
                            String fn;
                            if (selection[i] instanceof IContainer) {
                                return new Status(4, "org.eclipse.ui", 4, "Folder selected", null);
                            }
                            if (!(selection[i] instanceof IFile)) continue;
                            Collection<String> fFiles = kind.selectedFiles(currentUserPreferences);
                            Collection<String> fOFiles = kind.excludedFiles(currentUserPreferences);
                            if (fOFiles.contains(fn = (f = (IFile)selection[i]).getProjectRelativePath().toString())) {
                                return new Status(4, "org.eclipse.ui", 4, "File " + fn + " already selected in a conflicting list", null);
                            }
                            if (!fFiles.contains(fn)) continue;
                            return new Status(4, "org.eclipse.ui", 4, "File " + fn + " already selected for this filter", null);
                        }
                        return new Status(0, "org.eclipse.ui", 0, "", null);
                    }
                });
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    for (int i = 0; i < result.length; ++i) {
                        FilePlaceHolder holder = new FilePlaceHolder((IFile)result[i]);
                        filters.add(holder);
                        viewer.add((Object)holder);
                    }
                    kind.setFiles(currentUserPreferences, FilterFilesTab.this.filesToStrings(filters));
                }
            }
        });
        final Button removeButton = new Button(tableComposite, 8);
        removeButton.setLayoutData((Object)new GridData(4, 1, false, true));
        String removeButtonLabel = this.getMessage(kind.propertyName + "removebutton");
        removeButton.setText(removeButtonLabel);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object element : (IStructuredSelection)viewer.getSelection()) {
                    FilePlaceHolder holder = (FilePlaceHolder)((Object)element);
                    filters.remove((Object)holder);
                    viewer.remove((Object)holder);
                }
                kind.setFiles(currentUserPreferences, FilterFilesTab.this.filesToStrings(filters));
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    private Set<String> filesToStrings(List<FilePlaceHolder> filters) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (FilePlaceHolder holder : filters) {
            result.add(holder.getFile().getProjectRelativePath().toString());
        }
        return result;
    }

    void restoreDefaultSettings() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FilterKind {
        INCLUDE("property.includefilter"){

            @Override
            Collection<String> selectedFiles(UserPreferences u) {
                return u.getIncludeFilterFiles();
            }

            @Override
            Collection<String> excludedFiles(UserPreferences u) {
                return u.getExcludeFilterFiles();
            }

            @Override
            void setFiles(UserPreferences u, Collection<String> files) {
                u.setIncludeFilterFiles(files);
            }
        }
        ,
        EXCLUDE("property.excludefilter"){

            @Override
            Collection<String> selectedFiles(UserPreferences u) {
                return u.getExcludeFilterFiles();
            }

            @Override
            Collection<String> excludedFiles(UserPreferences u) {
                return u.getIncludeFilterFiles();
            }

            @Override
            void setFiles(UserPreferences u, Collection<String> files) {
                u.setExcludeFilterFiles(files);
            }
        }
        ,
        EXCLUDE_BUGS("property.excludebugs"){

            @Override
            Collection<String> selectedFiles(UserPreferences u) {
                return u.getExcludeBugsFiles();
            }

            @Override
            Collection<String> excludedFiles(UserPreferences u) {
                return Collections.emptyList();
            }

            @Override
            void setFiles(UserPreferences u, Collection<String> files) {
                u.setExcludeBugsFiles(files);
            }
        };

        final String propertyName;

        private FilterKind(String propertyName) {
            this.propertyName = propertyName;
        }

        abstract Collection<String> selectedFiles(UserPreferences var1);

        abstract Collection<String> excludedFiles(UserPreferences var1);

        abstract void setFiles(UserPreferences var1, Collection<String> var2);
    }

    private static final class FilePlaceHolder
    extends WorkbenchAdapter
    implements IAdaptable {
        private final IFile file;

        public FilePlaceHolder(IFile file) {
            this.file = file;
        }

        public String getLabel(Object object) {
            return this.file.getProjectRelativePath().toString();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)this.file.getAdapter(IWorkbenchAdapter.class);
            if (adapter != null) {
                return adapter.getImageDescriptor((Object)this.file);
            }
            return super.getImageDescriptor(object);
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(IWorkbenchAdapter.class)) {
                return this;
            }
            return null;
        }

        public IFile getFile() {
            return this.file;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof FilePlaceHolder) {
                return this.file.equals(((FilePlaceHolder)((Object)obj)).file);
            }
            return false;
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }
}

