/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerReporter
implements IWorkspaceRunnable {
    private BugInstance bug;
    private IResource resource;
    private int startLine;
    private BugCollection collection;
    private static final boolean EXPERIMENTAL_BUGS = false;

    public MarkerReporter(BugInstance bug, IResource resource, int startLine, BugCollection theCollection, IProject project) {
        this.startLine = startLine;
        this.bug = bug;
        this.resource = resource;
        this.collection = theCollection;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        String markerType = this.getMarkerType();
        if (markerType == null) {
            return;
        }
        IMarker marker = this.resource.createMarker(markerType);
        Map<String, Object> attributes = this.createMarkerAttributes(marker);
        this.setAttributes(marker, attributes);
    }

    private String getMarkerType() {
        String markerType;
        switch (this.bug.getPriority()) {
            case 1: {
                markerType = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerHigh";
                break;
            }
            case 2: {
                markerType = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerNormal";
                break;
            }
            case 3: {
                markerType = "edu.umd.cs.findbugs.plugin.eclipse.findbugsMarkerLow";
                break;
            }
            case 4: {
                return null;
            }
            case 5: {
                FindbugsPlugin.getDefault().logError("Bug with ignore priority ");
                return null;
            }
            default: {
                FindbugsPlugin.getDefault().logError("Bug with unknown priority " + this.bug.getPriority());
                return null;
            }
        }
        return markerType;
    }

    private Map<String, Object> createMarkerAttributes(IMarker marker) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(23);
        attributes.put("lineNumber", this.startLine);
        attributes.put("BUGTYPE", this.bug.getType());
        long seqNum = this.bug.getFirstVersion();
        if (seqNum == 0L) {
            attributes.put("FIRST_VERSION", "-1");
        } else {
            AppVersion theVersion = this.collection.getAppVersionFromSequenceNumber(seqNum);
            if (theVersion == null) {
                attributes.put("FIRST_VERSION", "Cannot find AppVersion: seqnum=" + seqNum + "; collection seqnum=" + this.collection.getSequenceNumber());
            } else {
                attributes.put("FIRST_VERSION", Long.toString(theVersion.getTimestamp()));
            }
        }
        try {
            attributes.put("message", this.bug.getMessageWithPriorityTypeAbbreviation());
        }
        catch (RuntimeException e) {
            FindbugsPlugin.getDefault().logException(e, "Error generating msg for " + this.bug.getType());
            attributes.put("message", "??? " + this.bug.getType());
        }
        attributes.put("severity", 1);
        attributes.put("PRIORITY_TYPE", this.bug.getPriorityTypeString());
        switch (this.bug.getPriority()) {
            case 1: {
                attributes.put("priority", 2);
                break;
            }
            case 2: {
                attributes.put("priority", 1);
                break;
            }
            default: {
                attributes.put("priority", 0);
            }
        }
        attributes.put("PATTERN_DESCR_SHORT", this.bug.getBugPattern().getShortDescription());
        String uniqueId = this.bug.getInstanceHash();
        if (uniqueId != null) {
            attributes.put("FINDBUGS_UNIQUE_ID", uniqueId);
        }
        return attributes;
    }

    private void setAttributes(IMarker marker, Map<String, Object> attributes) throws CoreException {
        marker.setAttributes(attributes);
    }
}

