/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.wizards;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.util.Util;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.I18N;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportWizardPage
extends WizardPage {
    private static final int BY_NAME = 0;
    private static final int BY_NOT_FILTERED_COUNT = 1;
    private static final int BY_OVERALL_COUNT = 2;
    private static final String SEPARATOR = ",";
    private Composite comp;
    private int sortBy;
    private Text filteredBugIdsText;

    protected ExportWizardPage(String pageName, String title, String descr, String imagePath) {
        super(pageName, title, AbstractUIPlugin.imageDescriptorFromPlugin((String)FindbugsPlugin.getDefault().getBundle().getSymbolicName(), (String)imagePath));
        this.setDescription(descr);
    }

    public void createControl(Composite parent) {
        this.comp = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.comp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        this.comp.setLayoutData((Object)gd);
        this.setControl((Control)this.comp);
        Label label = new Label(this.comp, 0);
        label.setText("Sort by:");
        final Combo sortByCombo = new Combo(this.comp, 8);
        String[] items = new String[]{"Name", "Not filtered bug count", "Overall bug count"};
        sortByCombo.setItems(items);
        String sortOrder = FindbugsPlugin.getDefault().getPreferenceStore().getString("exportSortOrder");
        if ("byNotFilteredBugsCount".equals(sortOrder)) {
            sortByCombo.select(1);
        } else if ("byOverallBugsCount".equals(sortOrder)) {
            sortByCombo.select(2);
        } else {
            sortByCombo.select(0);
        }
        this.sortBy = sortByCombo.getSelectionIndex();
        sortByCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExportWizardPage.this.sortBy = sortByCombo.getSelectionIndex();
            }
        });
        label = new Label(this.comp, 0);
        label.setText("Filter bug ids:");
        this.filteredBugIdsText = new Text(this.comp, 2052);
        GridData layoutData = new GridData(768);
        this.filteredBugIdsText.setLayoutData((Object)layoutData);
        this.filteredBugIdsText.setText(FindbugsPlugin.getDefault().getPreferenceStore().getString("lastUsedExportFilter"));
        this.filteredBugIdsText.setToolTipText("Bug ids to filter, separated by comma or space");
    }

    public void dispose() {
        this.comp.dispose();
        super.dispose();
    }

    public boolean finish() {
        String sortPref;
        String data = this.collectBugsData();
        this.copyToClipboard(data);
        String filters = this.getLastUsedExportFilters();
        FindbugsPlugin.getDefault().getPreferenceStore().setValue("lastUsedExportFilter", filters);
        switch (this.sortBy) {
            case 1: {
                sortPref = "byNotFilteredBugsCount";
                break;
            }
            case 2: {
                sortPref = "byOverallBugsCount";
                break;
            }
            default: {
                sortPref = "byName";
            }
        }
        FindbugsPlugin.getDefault().getPreferenceStore().setValue("exportSortOrder", sortPref);
        return true;
    }

    private String getLastUsedExportFilters() {
        String text = this.filteredBugIdsText.getText();
        if (text == null || text.trim().length() == 0) {
            return "";
        }
        Object[] split = text.split("[^a-zA-Z]+");
        Arrays.sort(split);
        StringBuilder sb = new StringBuilder();
        for (Object string : split) {
            sb.append((String)string).append(SEPARATOR);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private String collectBugsData() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<Record> lines = new ArrayList<Record>();
        for (IProject project : projects) {
            Record line = this.createProjectLine(project);
            if (line == null) continue;
            lines.add(line);
        }
        Collections.sort(lines);
        StringBuilder sb = new StringBuilder();
        this.createHeader(sb);
        for (Record record : lines) {
            sb.append(record);
        }
        return sb.toString();
    }

    private Record createProjectLine(IProject project) {
        try {
            if (Util.isJavaProject(project)) {
                IMarker[] markerArr = project.findMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
                if (markerArr.length == 0) {
                    return null;
                }
                int overallBugCount = markerArr.length;
                int notFilteredBugCount = 0;
                String usedExportFilters = this.getLastUsedExportFilters();
                for (IMarker marker : markerArr) {
                    if (this.isFiltered(marker, usedExportFilters)) continue;
                    ++notFilteredBugCount;
                }
                return new Record(project.getName(), overallBugCount, notFilteredBugCount);
            }
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Can't export project bugs for: " + project);
        }
        return null;
    }

    private boolean isFiltered(IMarker marker, String usedExportFilters) {
        String type = marker.getAttribute("BUGTYPE", "not found");
        BugPattern result = I18N.instance().lookupBugPattern(type);
        if (result == null) {
            return false;
        }
        String id = result.getAbbrev();
        return usedExportFilters.indexOf(id) >= 0;
    }

    protected int getSortBy() {
        return this.sortBy;
    }

    protected void copyToClipboard(String toolTip) {
        Object[] data = new Object[]{toolTip};
        Transfer[] transfer = new Transfer[]{TextTransfer.getInstance()};
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        clipboard.setContents(data, transfer);
        clipboard.dispose();
    }

    private void createHeader(StringBuilder sb) {
        switch (this.sortBy) {
            case 2: {
                sb.append("Overall bugs number, Project name,Not filtered bugs number\n");
                break;
            }
            case 1: {
                sb.append("Not filtered bugs number,Project name,Overall bugs number\n");
                break;
            }
            default: {
                sb.append("Project name,Not filtered bugs number,Overall bugs number\n");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Record
    implements Comparable<Record> {
        private final String name;
        private final int overallBugs;
        private final int notFilteredBugs;

        Record(String name, int overallBugs, int notFilteredBugs) {
            this.name = name;
            this.overallBugs = overallBugs;
            this.notFilteredBugs = notFilteredBugs;
        }

        @Override
        public int compareTo(Record other) {
            switch (ExportWizardPage.this.sortBy) {
                case 2: {
                    int result = other.overallBugs - this.overallBugs;
                    if (result == 0) {
                        return this.name.compareTo(other.name);
                    }
                    return result;
                }
                case 1: {
                    int result = other.notFilteredBugs - this.notFilteredBugs;
                    if (result == 0) {
                        return this.name.compareTo(other.name);
                    }
                    return result;
                }
            }
            return this.name.compareTo(other.name);
        }

        public String toString() {
            switch (ExportWizardPage.this.sortBy) {
                case 2: {
                    return this.overallBugs + ExportWizardPage.SEPARATOR + this.name + ExportWizardPage.SEPARATOR + this.notFilteredBugs + "\n";
                }
                case 1: {
                    return this.notFilteredBugs + ExportWizardPage.SEPARATOR + this.name + ExportWizardPage.SEPARATOR + this.overallBugs + "\n";
                }
            }
            return this.name + ExportWizardPage.SEPARATOR + this.notFilteredBugs + ExportWizardPage.SEPARATOR + this.overallBugs + "\n";
        }
    }
}

