/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyze {
    private static JavaClass serializable;
    private static JavaClass collection;
    private static JavaClass comparator;
    private static JavaClass map;
    private static JavaClass remote;
    private static ClassNotFoundException storedException;

    private static boolean containsConcreteClasses(Set<JavaClass> s) {
        for (JavaClass c : s) {
            if (c.isInterface() || c.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public static double isDeepSerializable(String refSig) throws ClassNotFoundException {
        if (storedException != null) {
            throw storedException;
        }
        if (Analyze.isPrimitiveComponentClass(refSig)) {
            return 1.0;
        }
        String refName = Analyze.getComponentClass(refSig);
        if (refName.equals("java.lang.Object")) {
            return 0.99;
        }
        JavaClass refJavaClass = Repository.lookupClass(refName);
        return Analyze.isDeepSerializable(refJavaClass);
    }

    public static double isDeepRemote(String refSig) {
        if (remote == null) {
            return 0.1;
        }
        String refName = Analyze.getComponentClass(refSig);
        if (refName.equals("java.lang.Object")) {
            return 0.99;
        }
        try {
            JavaClass refJavaClass = Repository.lookupClass(refName);
            return Analyze.deepInstanceOf(refJavaClass, remote);
        }
        catch (ClassNotFoundException e) {
            return 0.99;
        }
    }

    private static boolean isPrimitiveComponentClass(String refSig) {
        int c;
        for (c = 0; c < refSig.length() && refSig.charAt(c) == '['; ++c) {
        }
        return c >= refSig.length() || refSig.charAt(c) != 'L';
    }

    public static String getComponentClass(String refSig) {
        while (refSig.charAt(0) == '[') {
            refSig = refSig.substring(1);
        }
        if (refSig.charAt(0) == 'L') {
            return refSig.substring(1, refSig.length() - 1).replace('/', '.');
        }
        return refSig;
    }

    public static double isDeepSerializable(JavaClass x) throws ClassNotFoundException {
        if (storedException != null) {
            throw storedException;
        }
        double result = Analyze.deepInstanceOf(x, serializable);
        if (result >= 0.9) {
            return result;
        }
        if ((result = Math.max(result, Analyze.deepInstanceOf(x, collection))) >= 0.9) {
            return result;
        }
        if ((result = Math.max(result, Analyze.deepInstanceOf(x, map))) >= 0.9) {
            return result;
        }
        if ((result = Math.max(result, 0.5 * Analyze.deepInstanceOf(x, comparator))) >= 0.9) {
            return result;
        }
        return result;
    }

    public static double deepInstanceOf(String x, String y) throws ClassNotFoundException {
        return Analyze.deepInstanceOf(AnalysisContext.currentAnalysisContext().lookupClass(x), AnalysisContext.currentAnalysisContext().lookupClass(y));
    }

    public static double deepInstanceOf(JavaClass x, JavaClass y) throws ClassNotFoundException {
        Set<ClassDescriptor> transitiveCommonSubtypes;
        if (x.equals(y)) {
            return 1.0;
        }
        if (y.getClassName().equals("java.lang.Object")) {
            return 1.0;
        }
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        ClassDescriptor xDesc = DescriptorFactory.createClassDescriptor(x);
        ClassDescriptor yDesc = DescriptorFactory.createClassDescriptor(y);
        boolean xIsSubtypeOfY = Repository.instanceOf(x, y);
        if (xIsSubtypeOfY) {
            return 1.0;
        }
        boolean yIsSubtypeOfX = Repository.instanceOf(y, x);
        if (!yIsSubtypeOfX) {
            if (x.isFinal() || y.isFinal()) {
                return 0.0;
            }
            if (!x.isInterface() && !y.isInterface()) {
                return 0.0;
            }
        }
        if ((transitiveCommonSubtypes = subtypes2.getTransitiveCommonSubtypes(xDesc, yDesc)).isEmpty()) {
            for (ClassDescriptor c : subtypes2.getSubtypes(xDesc)) {
                XClass cx;
                try {
                    cx = Global.getAnalysisCache().getClassAnalysis(XClass.class, c);
                }
                catch (CheckedAnalysisException e) {
                    continue;
                }
                if (cx.isAbstract() || cx.isInterface()) continue;
                if (x.isAbstract() || x.isInterface()) {
                    return 0.2;
                }
                return 0.1;
            }
            return 0.3;
        }
        HashSet<ClassDescriptor> xButNotY = new HashSet<ClassDescriptor>(subtypes2.getSubtypes(xDesc));
        xButNotY.removeAll(transitiveCommonSubtypes);
        for (ClassDescriptor c : xButNotY) {
            XClass cx;
            try {
                cx = Global.getAnalysisCache().getClassAnalysis(XClass.class, c);
            }
            catch (CheckedAnalysisException e) {
                continue;
            }
            if (cx.isAbstract() || cx.isInterface()) continue;
            return 0.7;
        }
        return 0.99;
    }

    static {
        block4: {
            try {
                serializable = AnalysisContext.lookupSystemClass("java.io.Serializable");
                collection = AnalysisContext.lookupSystemClass("java.util.Collection");
                map = AnalysisContext.lookupSystemClass("java.util.Map");
                comparator = AnalysisContext.lookupSystemClass("java.util.Comparator");
            }
            catch (ClassNotFoundException e) {
                storedException = e;
            }
            try {
                remote = AnalysisContext.lookupSystemClass("java.rmi.Remote");
            }
            catch (ClassNotFoundException e) {
                if (storedException != null) break block4;
                storedException = e;
            }
        }
    }
}

