/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugProperty;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.IntAnnotation;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.XMLWriteableWithMessages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.bcp.FieldVariable;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.objectweb.asm.tree.ClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugInstance
implements Comparable<BugInstance>,
XMLWriteableWithMessages,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String type;
    private int priority;
    private ArrayList<BugAnnotation> annotationList;
    private int cachedHashCode;
    @CheckForNull
    private BugDesignation userDesignation;
    private BugProperty propertyListHead;
    private BugProperty propertyListTail;
    private String uniqueId;
    private String oldInstanceHash;
    private String instanceHash;
    private int instanceOccurrenceNum;
    private int instanceOccurrenceMax;
    private long firstVersion = 0L;
    private long lastVersion = -1L;
    private boolean introducedByChangeOfExistingClass;
    private boolean removedByChangeOfPersistingClass;
    private static final int INVALID_HASH_CODE = 0;
    private static boolean adjustExperimental = false;
    private static Set<String> bugTypes = Collections.synchronizedSet(new HashSet());
    private static final String ELEMENT_NAME = "BugInstance";
    private static final String USER_ANNOTATION_ELEMENT_NAME = "UserAnnotation";
    private static final boolean DONT_HASH = SystemProperties.getBoolean("findbugs.dontHash");

    public BugInstance(String type, int priority) {
        BugPattern p;
        this.type = type;
        this.priority = priority;
        this.annotationList = new ArrayList(4);
        this.cachedHashCode = 0;
        if (bugTypes.add(type) && (p = I18N.instance().lookupBugPattern(type)) == null) {
            String msg = "Can't find definition of bug type " + type;
            AnalysisContext.logError(msg, new IllegalArgumentException(msg));
        }
        if (adjustExperimental && this.isExperimental()) {
            this.priority = 4;
        }
        this.boundPriority();
    }

    private void boundPriority() {
        this.priority = this.boundedPriority(this.priority);
    }

    public Object clone() {
        try {
            BugInstance dup = (BugInstance)super.clone();
            for (int i = 0; i < dup.annotationList.size(); ++i) {
                dup.annotationList.set(i, (BugAnnotation)dup.annotationList.get(i).clone());
            }
            dup.propertyListTail = null;
            dup.propertyListHead = null;
            Iterator<BugProperty> i = this.propertyIterator();
            while (i.hasNext()) {
                dup.addProperty((BugProperty)i.next().clone());
            }
            return dup;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public BugInstance(Detector detector, String type, int priority) {
        this(type, priority);
        DetectorFactory factory;
        if (detector != null && (factory = DetectorFactoryCollection.instance().getFactoryByClassName(detector.getClass().getName())) != null) {
            this.priority += factory.getPriorityAdjustment();
            this.boundPriority();
        }
    }

    public BugInstance(Detector2 detector, String type, int priority) {
        this(type, priority);
        DetectorFactory factory;
        if (detector != null && (factory = DetectorFactoryCollection.instance().getFactoryByClassName(detector.getDetectorClassName())) != null) {
            this.priority += factory.getPriorityAdjustment();
            this.boundPriority();
        }
    }

    public static void setAdjustExperimental(boolean adjust) {
        adjustExperimental = adjust;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public BugPattern getBugPattern() {
        BugPattern result = I18N.instance().lookupBugPattern(this.getType());
        if (result != null) {
            return result;
        }
        AnalysisContext.logError("Unable to find description of bug pattern " + this.getType());
        result = I18N.instance().lookupBugPattern("UNKNOWN");
        if (result != null) {
            return result;
        }
        return BugPattern.REALLY_UNKNOWN;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPriorityTypeString() {
        String priorityString = this.getPriorityString();
        BugPattern bugPattern = this.getBugPattern();
        String categoryString = bugPattern == null ? "Unknown category for " + this.getType() : I18N.instance().getBugCategoryDescription(bugPattern.getCategory());
        return priorityString + " Priority " + categoryString;
    }

    public String getPriorityTypeAbbreviation() {
        String priorityString = this.getPriorityAbbreviation();
        return priorityString + " " + this.getCategoryAbbrev();
    }

    public String getCategoryAbbrev() {
        BugPattern bugPattern = this.getBugPattern();
        if (bugPattern == null) {
            return "?";
        }
        return bugPattern.getCategoryAbbrev();
    }

    public String getPriorityString() {
        int value = this.getPriority();
        String priorityString = value == 1 ? L10N.getLocalString("sort.priority_high", "High") : (value == 2 ? L10N.getLocalString("sort.priority_normal", "Medium") : (value == 3 ? L10N.getLocalString("sort.priority_low", "Low") : (value == 4 ? L10N.getLocalString("sort.priority_experimental", "Experimental") : L10N.getLocalString("sort.priority_ignore", "Ignore"))));
        return priorityString;
    }

    public String getPriorityAbbreviation() {
        return this.getPriorityString().substring(0, 1);
    }

    public void setPriority(int p) {
        this.priority = this.boundedPriority(p);
    }

    private int boundedPriority(int p) {
        return Math.max(1, Math.min(5, p));
    }

    public void raisePriority() {
        this.priority = this.boundedPriority(this.priority - 1);
    }

    public void lowerPriority() {
        this.priority = this.boundedPriority(this.priority + 1);
    }

    public void lowerPriorityALot() {
        this.priority = this.boundedPriority(this.priority + 2);
    }

    public boolean isExperimental() {
        BugPattern pattern = this.getBugPattern();
        return pattern != null && pattern.isExperimental();
    }

    public ClassAnnotation getPrimaryClass() {
        return this.findAnnotationOfType(ClassAnnotation.class);
    }

    public MethodAnnotation getPrimaryMethod() {
        return this.findAnnotationOfType(MethodAnnotation.class);
    }

    public FieldAnnotation getPrimaryField() {
        return this.findAnnotationOfType(FieldAnnotation.class);
    }

    public BugInstance lowerPriorityIfDeprecated() {
        FieldAnnotation f;
        MethodAnnotation m = this.getPrimaryMethod();
        if (m != null && XFactory.createXMethod(m).isDeprecated()) {
            this.lowerPriority();
        }
        if ((f = this.getPrimaryField()) != null && XFactory.createXField(f).isDeprecated()) {
            this.lowerPriority();
        }
        return this;
    }

    private <T extends BugAnnotation> T findAnnotationOfType(Class<T> cls) {
        Iterator<BugAnnotation> i = this.annotationIterator();
        while (i.hasNext()) {
            BugAnnotation annotation = i.next();
            if (!cls.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    public LocalVariableAnnotation getPrimaryLocalVariableAnnotation() {
        for (BugAnnotation annotation : this.annotationList) {
            if (!(annotation instanceof LocalVariableAnnotation)) continue;
            return (LocalVariableAnnotation)annotation;
        }
        return null;
    }

    public SourceLineAnnotation getPrimarySourceLineAnnotation() {
        for (BugAnnotation annotation : this.annotationList) {
            if (!(annotation instanceof SourceLineAnnotation) || !annotation.getDescription().equals("SOURCE_LINE_DEFAULT")) continue;
            return (SourceLineAnnotation)annotation;
        }
        for (BugAnnotation annotation : this.annotationList) {
            if (!(annotation instanceof SourceLineAnnotation)) continue;
            return (SourceLineAnnotation)annotation;
        }
        SourceLineAnnotation srcLine = this.inspectPackageMemberSourceLines(this.getPrimaryMethod());
        if (srcLine != null) {
            return srcLine;
        }
        srcLine = this.inspectPackageMemberSourceLines(this.getPrimaryField());
        if (srcLine != null) {
            return srcLine;
        }
        srcLine = this.inspectPackageMemberSourceLines(this.getPrimaryClass());
        if (srcLine != null) {
            return srcLine;
        }
        throw new IllegalStateException("BugInstance must contain at least one class, method, or field annotation");
    }

    public String getInstanceKey() {
        StringBuffer buf = new StringBuffer(this.type);
        for (BugAnnotation annotation : this.annotationList) {
            if (annotation instanceof SourceLineAnnotation || annotation instanceof MethodAnnotation && !annotation.isSignificant()) continue;
            buf.append(":");
            buf.append(annotation.format("hash", null));
        }
        return buf.toString();
    }

    private SourceLineAnnotation inspectPackageMemberSourceLines(PackageMemberAnnotation packageMember) {
        return packageMember != null ? packageMember.getSourceLines() : null;
    }

    public Iterator<BugAnnotation> annotationIterator() {
        return this.annotationList.iterator();
    }

    public String getAbbrev() {
        BugPattern pattern = this.getBugPattern();
        return pattern != null ? pattern.getAbbrev() : "<unknown bug pattern>";
    }

    public void setUserDesignation(BugDesignation bd) {
        this.userDesignation = bd;
    }

    @Nullable
    public BugDesignation getUserDesignation() {
        return this.userDesignation;
    }

    @NonNull
    public BugDesignation getNonnullUserDesignation() {
        if (this.userDesignation == null) {
            this.userDesignation = new BugDesignation();
        }
        return this.userDesignation;
    }

    @NonNull
    public String getUserDesignationKey() {
        BugDesignation userDesignation = this.userDesignation;
        if (userDesignation == null) {
            return "UNCLASSIFIED";
        }
        return userDesignation.getDesignationKey();
    }

    public void setAnnotationText(String annotationText) {
        this.getNonnullUserDesignation().setAnnotationText(annotationText);
    }

    @NonNull
    public String getAnnotationText() {
        BugDesignation userDesignation = this.userDesignation;
        if (userDesignation == null) {
            return "";
        }
        String s = userDesignation.getAnnotationText();
        if (s == null) {
            return "";
        }
        return s;
    }

    public boolean annotationTextContainsWord(String word) {
        return this.getTextAnnotationWords().contains(word);
    }

    public Set<String> getTextAnnotationWords() {
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(this.getAnnotationText(), " \t\r\n\f.,:;-");
        while (tok.hasMoreTokens()) {
            result.add(tok.nextToken());
        }
        return result;
    }

    @Deprecated
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Deprecated
    void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getProperty(String name) {
        BugProperty prop = this.lookupProperty(name);
        return prop != null ? prop.getValue() : null;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        return value != null ? value : defaultValue;
    }

    public Iterator<BugProperty> propertyIterator() {
        return new BugPropertyIterator();
    }

    public BugInstance setProperty(String name, String value) {
        BugProperty prop = this.lookupProperty(name);
        if (prop != null) {
            prop.setValue(value);
        } else {
            prop = new BugProperty(name, value);
            this.addProperty(prop);
        }
        return this;
    }

    public BugProperty lookupProperty(String name) {
        BugProperty prop;
        for (prop = this.propertyListHead; prop != null && !prop.getName().equals(name); prop = prop.getNext()) {
        }
        return prop;
    }

    public boolean deleteProperty(String name) {
        BugProperty prop;
        BugProperty prev = null;
        for (prop = this.propertyListHead; prop != null && !prop.getName().equals(name); prop = prop.getNext()) {
            prev = prop;
        }
        if (prop != null) {
            if (prev != null) {
                prev.setNext(prop.getNext());
            } else {
                this.propertyListHead = prop.getNext();
            }
            if (prop.getNext() == null) {
                this.propertyListTail = prev;
            }
            return true;
        }
        return false;
    }

    private void addProperty(BugProperty prop) {
        if (this.propertyListTail != null) {
            this.propertyListTail.setNext(prop);
            this.propertyListTail = prop;
        } else {
            this.propertyListHead = this.propertyListTail = prop;
        }
        prop.setNext(null);
    }

    public BugInstance addAnnotations(Collection<? extends BugAnnotation> annotationCollection) {
        for (BugAnnotation bugAnnotation : annotationCollection) {
            this.add(bugAnnotation);
        }
        return this;
    }

    public BugInstance addClassAndMethod(MethodDescriptor methodDescriptor) {
        this.addClass(methodDescriptor.getSlashedClassName());
        this.add(MethodAnnotation.fromMethodDescriptor(methodDescriptor));
        return this;
    }

    public BugInstance addClassAndMethod(PreorderVisitor visitor) {
        this.addClass(visitor);
        this.addMethod(visitor);
        return this;
    }

    public BugInstance addClassAndMethod(MethodAnnotation methodAnnotation) {
        this.addClass(methodAnnotation.getClassName());
        this.addMethod(methodAnnotation);
        return this;
    }

    public BugInstance addClassAndMethod(MethodGen methodGen, String sourceFile) {
        this.addClass(methodGen.getClassName());
        this.addMethod(methodGen, sourceFile);
        return this;
    }

    public BugInstance addClassAndMethod(JavaClass javaClass, Method method) {
        this.addClass(javaClass.getClassName());
        this.addMethod(javaClass, method);
        return this;
    }

    @Deprecated
    public BugInstance addClass(String className, String sourceFileName) {
        ClassAnnotation classAnnotation = new ClassAnnotation(className);
        this.add(classAnnotation);
        return this;
    }

    public BugInstance addClass(String className) {
        className = ClassName.toDottedClassName(className);
        ClassAnnotation classAnnotation = new ClassAnnotation(className);
        this.add(classAnnotation);
        return this;
    }

    public BugInstance addClass(ClassNode classNode) {
        ClassAnnotation classAnnotation = new ClassAnnotation(classNode.name);
        this.add(classAnnotation);
        return this;
    }

    public BugInstance addClass(ClassDescriptor classDescriptor) {
        this.add(ClassAnnotation.fromClassDescriptor(classDescriptor));
        return this;
    }

    public BugInstance addClass(JavaClass jclass) {
        this.addClass(jclass.getClassName());
        return this;
    }

    public BugInstance addClass(PreorderVisitor visitor) {
        String className = visitor.getDottedClassName();
        this.addClass(className);
        return this;
    }

    public BugInstance addSuperclass(PreorderVisitor visitor) {
        String className = visitor.getSuperclassName();
        this.addClass(className);
        return this;
    }

    public BugInstance addType(String typeDescriptor) {
        TypeAnnotation typeAnnotation = new TypeAnnotation(typeDescriptor);
        this.add(typeAnnotation);
        return this;
    }

    public BugInstance addFoundAndExpectedType(String foundType, String expectedType) {
        this.add(new TypeAnnotation(foundType)).describe("TYPE_FOUND");
        this.add(new TypeAnnotation(expectedType)).describe("TYPE_EXPECTED");
        return this;
    }

    public BugInstance addTypeOfNamedClass(String typeName) {
        TypeAnnotation typeAnnotation = new TypeAnnotation("L" + typeName.replace('.', '/') + ";");
        this.add(typeAnnotation);
        return this;
    }

    public BugInstance addField(String className, String fieldName, String fieldSig, boolean isStatic) {
        this.addField(new FieldAnnotation(className, fieldName, fieldSig, isStatic));
        return this;
    }

    public BugInstance addField(String className, String fieldName, String fieldSig, int accessFlags) {
        this.addField(new FieldAnnotation(className, fieldName, fieldSig, accessFlags));
        return this;
    }

    public BugInstance addField(PreorderVisitor visitor) {
        FieldAnnotation fieldAnnotation = FieldAnnotation.fromVisitedField(visitor);
        return this.addField(fieldAnnotation);
    }

    public BugInstance addField(FieldAnnotation fieldAnnotation) {
        this.add(fieldAnnotation);
        return this;
    }

    public BugInstance addField(FieldVariable field) {
        return this.addField(field.getClassName(), field.getFieldName(), field.getFieldSig(), field.isStatic());
    }

    public BugInstance addOptionalField(@CheckForNull XField xfield) {
        if (xfield == null) {
            return this;
        }
        return this.addField(xfield.getClassName(), xfield.getName(), xfield.getSignature(), xfield.isStatic());
    }

    public BugInstance addField(XField xfield) {
        return this.addField(xfield.getClassName(), xfield.getName(), xfield.getSignature(), xfield.isStatic());
    }

    public BugInstance addField(FieldDescriptor fieldDescriptor) {
        FieldAnnotation fieldAnnotation = FieldAnnotation.fromFieldDescriptor(fieldDescriptor);
        this.add(fieldAnnotation);
        return this;
    }

    public BugInstance addReferencedField(DismantleBytecode visitor) {
        FieldAnnotation f = FieldAnnotation.fromReferencedField(visitor);
        this.addField(f);
        return this;
    }

    public BugInstance addReferencedField(FieldAnnotation fa) {
        this.addField(fa);
        return this;
    }

    public BugInstance addVisitedField(PreorderVisitor visitor) {
        FieldAnnotation f = FieldAnnotation.fromVisitedField(visitor);
        this.addField(f);
        return this;
    }

    public BugInstance addOptionalLocalVariable(DismantleBytecode dbc, OpcodeStack.Item item) {
        int register = item.getRegisterNumber();
        if (register >= 0) {
            this.add(LocalVariableAnnotation.getLocalVariableAnnotation(dbc.getMethod(), register, dbc.getPC() - 1, dbc.getPC()));
        }
        return this;
    }

    public BugInstance addMethod(String className, String methodName, String methodSig, boolean isStatic) {
        this.addMethod(MethodAnnotation.fromForeignMethod(className, methodName, methodSig, isStatic));
        return this;
    }

    public BugInstance addMethod(String className, String methodName, String methodSig, int accessFlags) {
        this.addMethod(MethodAnnotation.fromForeignMethod(className, methodName, methodSig, accessFlags));
        return this;
    }

    public BugInstance addMethod(MethodGen methodGen, String sourceFile) {
        String className = methodGen.getClassName();
        MethodAnnotation methodAnnotation = new MethodAnnotation(className, methodGen.getName(), methodGen.getSignature(), methodGen.isStatic());
        this.addMethod(methodAnnotation);
        this.addSourceLinesForMethod(methodAnnotation, SourceLineAnnotation.fromVisitedMethod(methodGen, sourceFile));
        return this;
    }

    public BugInstance addMethod(JavaClass javaClass, Method method) {
        MethodAnnotation methodAnnotation = new MethodAnnotation(javaClass.getClassName(), method.getName(), method.getSignature(), method.isStatic());
        SourceLineAnnotation methodSourceLines = SourceLineAnnotation.forEntireMethod(javaClass, method);
        methodAnnotation.setSourceLines(methodSourceLines);
        this.addMethod(methodAnnotation);
        return this;
    }

    public BugInstance addMethod(JavaClassAndMethod classAndMethod) {
        return this.addMethod(classAndMethod.getJavaClass(), classAndMethod.getMethod());
    }

    public BugInstance addMethod(PreorderVisitor visitor) {
        MethodAnnotation methodAnnotation = MethodAnnotation.fromVisitedMethod(visitor);
        this.addMethod(methodAnnotation);
        this.addSourceLinesForMethod(methodAnnotation, SourceLineAnnotation.fromVisitedMethod(visitor));
        return this;
    }

    public BugInstance addCalledMethod(DismantleBytecode visitor) {
        return this.addMethod(MethodAnnotation.fromCalledMethod(visitor)).describe("METHOD_CALLED");
    }

    public BugInstance addCalledMethod(String className, String methodName, String methodSig, boolean isStatic) {
        return this.addMethod(MethodAnnotation.fromCalledMethod(className, methodName, methodSig, isStatic)).describe("METHOD_CALLED");
    }

    public BugInstance addCalledMethod(MethodGen methodGen, InvokeInstruction inv) {
        ConstantPoolGen cpg = methodGen.getConstantPool();
        String className = inv.getClassName(cpg);
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        this.addMethod(className, methodName, methodSig, inv.getOpcode() == 184);
        this.describe("METHOD_CALLED");
        return this;
    }

    public BugInstance addMethod(XMethod xmethod) {
        this.addMethod(MethodAnnotation.fromXMethod(xmethod));
        return this;
    }

    public BugInstance addMethod(MethodAnnotation methodAnnotation) {
        this.add(methodAnnotation);
        return this;
    }

    public BugInstance addInt(int value) {
        this.add(new IntAnnotation(value));
        return this;
    }

    public BugInstance addString(String value) {
        this.add(new StringAnnotation(value));
        return this;
    }

    public BugInstance addSourceLine(SourceLineAnnotation sourceLine) {
        this.add(sourceLine);
        return this;
    }

    public BugInstance addSourceLine(BytecodeScanningDetector visitor, int pc) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(visitor.getClassContext(), visitor, pc);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    public BugInstance addSourceLine(ClassContext classContext, PreorderVisitor visitor, int pc) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, visitor, pc);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    public BugInstance addSourceLine(ClassContext classContext, MethodGen methodGen, String sourceFile, @NonNull InstructionHandle handle) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    public BugInstance addSourceLine(ClassContext classContext, MethodGen methodGen, String sourceFile, InstructionHandle start, InstructionHandle end) {
        SourceLineAnnotation sourceLineAnnotation;
        if (start.getPosition() > end.getPosition()) {
            InstructionHandle tmp = start;
            start = end;
            end = tmp;
        }
        if ((sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstructionRange(classContext, methodGen, sourceFile, start, end)) != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    public BugInstance addSourceLine(ClassContext classContext, Method method, Location location) {
        return this.addSourceLine(classContext, method, location.getHandle());
    }

    public BugInstance addSourceLine(MethodDescriptor methodDescriptor, Location location) {
        try {
            IAnalysisCache analysisCache = Global.getAnalysisCache();
            ClassContext classContext = analysisCache.getClassAnalysis(ClassContext.class, methodDescriptor.getClassDescriptor());
            Method method = analysisCache.getMethodAnalysis(Method.class, methodDescriptor);
            return this.addSourceLine(classContext, method, location);
        }
        catch (CheckedAnalysisException e) {
            return this.addSourceLine(SourceLineAnnotation.createReallyUnknown(methodDescriptor.getClassDescriptor().toDottedClassName()));
        }
    }

    public BugInstance addSourceLine(ClassContext classContext, Method method, InstructionHandle handle) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, method, handle.getPosition());
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    public BugInstance addSourceLineRange(BytecodeScanningDetector visitor, int startPC, int endPC) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstructionRange(visitor.getClassContext(), visitor, startPC, endPC);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    public BugInstance addSourceLineRange(ClassContext classContext, PreorderVisitor visitor, int startPC, int endPC) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstructionRange(classContext, visitor, startPC, endPC);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    public BugInstance addSourceLine(BytecodeScanningDetector visitor) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(visitor);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    public BugInstance addUnknownSourceLine(String className, String sourceFile) {
        SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.createUnknown(className, sourceFile);
        if (sourceLineAnnotation != null) {
            this.add(sourceLineAnnotation);
        }
        return this;
    }

    public String getMessageWithoutPrefix() {
        BugPattern bugPattern = this.getBugPattern();
        String pattern = this.getLongDescription();
        String shortPattern = bugPattern.getShortDescription();
        try {
            FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
            return format.format(this.annotationList.toArray(new BugAnnotation[this.annotationList.size()]), this.getPrimaryClass());
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error generating bug msg ", e);
            return shortPattern + " [Error generating customized description]";
        }
    }

    String getLongDescription() {
        return this.getBugPattern().getLongDescription().replaceAll("BUG_PATTERN", this.type);
    }

    public String getAbridgedMessage() {
        String shortPattern;
        String pattern;
        BugPattern bugPattern = this.getBugPattern();
        if (bugPattern == null) {
            shortPattern = pattern = "Error2: missing bug pattern for key " + this.type;
        } else {
            pattern = this.getLongDescription().replaceAll(" in \\{1\\}", "");
            shortPattern = bugPattern.getShortDescription();
        }
        try {
            FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
            return format.format(this.annotationList.toArray(new BugAnnotation[this.annotationList.size()]), this.getPrimaryClass());
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error generating bug msg ", e);
            return shortPattern + " [Error3 generating customized description]";
        }
    }

    public String getMessage() {
        BugPattern bugPattern = this.getBugPattern();
        String pattern = bugPattern.getAbbrev() + ": " + this.getLongDescription();
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        try {
            return format.format(this.annotationList.toArray(new BugAnnotation[this.annotationList.size()]), this.getPrimaryClass());
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error generating bug msg ", e);
            return bugPattern.getShortDescription() + " [Error generating customized description]";
        }
    }

    public String getMessageWithPriorityType() {
        return "(" + this.getPriorityTypeString() + ") " + this.getMessage();
    }

    public String getMessageWithPriorityTypeAbbreviation() {
        return this.getPriorityTypeAbbreviation() + " " + this.getMessage();
    }

    public BugInstance describe(String description) {
        this.annotationList.get(this.annotationList.size() - 1).setDescription(description);
        return this;
    }

    public String toString() {
        return I18N.instance().getShortMessage(this.type);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false, false);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        SourceLineAnnotation synth;
        Map primaryAnnotations;
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("type", this.type).addAttribute("priority", String.valueOf(this.priority));
        BugPattern pattern = this.getBugPattern();
        if (pattern != null) {
            attributeList.addAttribute("abbrev", pattern.getAbbrev());
            attributeList.addAttribute("category", pattern.getCategory());
        }
        if (addMessages) {
            if (this.getUniqueId() != null) {
                attributeList.addAttribute("uid", this.getUniqueId());
            }
            attributeList.addAttribute("instanceHash", this.getInstanceHash());
            attributeList.addAttribute("instanceOccurrenceNum", Integer.toString(this.getInstanceOccurrenceNum()));
            attributeList.addAttribute("instanceOccurrenceMax", Integer.toString(this.getInstanceOccurrenceMax()));
        }
        if (this.firstVersion > 0L) {
            attributeList.addAttribute("first", Long.toString(this.firstVersion));
        }
        if (this.lastVersion >= 0L) {
            attributeList.addAttribute("last", Long.toString(this.lastVersion));
        }
        if (this.introducedByChangeOfExistingClass) {
            attributeList.addAttribute("introducedByChange", "true");
        }
        if (this.removedByChangeOfPersistingClass) {
            attributeList.addAttribute("removedByChange", "true");
        }
        xmlOutput.openTag(ELEMENT_NAME, attributeList);
        if (this.userDesignation != null) {
            this.userDesignation.writeXML(xmlOutput);
        }
        if (addMessages) {
            BugPattern bugPattern = this.getBugPattern();
            xmlOutput.openTag("ShortMessage");
            xmlOutput.writeText(bugPattern != null ? bugPattern.getShortDescription() : this.toString());
            xmlOutput.closeTag("ShortMessage");
            xmlOutput.openTag("LongMessage");
            if (FindBugsDisplayFeatures.isAbridgedMessages()) {
                xmlOutput.writeText(this.getAbridgedMessage());
            } else {
                xmlOutput.writeText(this.getMessageWithoutPrefix());
            }
            xmlOutput.closeTag("LongMessage");
        }
        if (addMessages) {
            primaryAnnotations = new IdentityHashMap();
            primaryAnnotations.put(this.getPrimarySourceLineAnnotation(), null);
            primaryAnnotations.put(this.getPrimaryClass(), null);
            primaryAnnotations.put(this.getPrimaryField(), null);
            primaryAnnotations.put(this.getPrimaryMethod(), null);
        } else {
            primaryAnnotations = Collections.emptyMap();
        }
        boolean foundSourceAnnotation = false;
        for (BugAnnotation annotation : this.annotationList) {
            if (annotation instanceof SourceLineAnnotation) {
                foundSourceAnnotation = true;
            }
            annotation.writeXML(xmlOutput, addMessages, primaryAnnotations.containsKey(annotation));
        }
        if (!foundSourceAnnotation && addMessages && (synth = this.getPrimarySourceLineAnnotation()) != null) {
            synth.setSynthetic(true);
            synth.writeXML(xmlOutput, addMessages, false);
        }
        if (this.propertyListHead != null) {
            for (BugProperty prop = this.propertyListHead; prop != null; prop = prop.getNext()) {
                prop.writeXML(xmlOutput);
            }
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }

    public BugInstance addOptionalAnnotation(@CheckForNull BugAnnotation annotation) {
        if (annotation == null) {
            return this;
        }
        return this.add(annotation);
    }

    public BugInstance add(BugAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalStateException("Missing BugAnnotation!");
        }
        this.annotationList.add(annotation);
        this.cachedHashCode = 0;
        return this;
    }

    private void addSourceLinesForMethod(MethodAnnotation methodAnnotation, SourceLineAnnotation sourceLineAnnotation) {
        if (sourceLineAnnotation != null) {
            methodAnnotation.setSourceLines(sourceLineAnnotation);
        }
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int hashcode = this.type.hashCode() + this.priority;
            Iterator<BugAnnotation> i = this.annotationIterator();
            while (i.hasNext()) {
                hashcode += i.next().hashCode();
            }
            if (hashcode == 0) {
                hashcode = 1;
            }
            this.cachedHashCode = hashcode;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BugInstance)) {
            return false;
        }
        BugInstance other = (BugInstance)o;
        if (!this.type.equals(other.type) || this.priority != other.priority) {
            return false;
        }
        if (this.annotationList.size() != other.annotationList.size()) {
            return false;
        }
        int numAnnotations = this.annotationList.size();
        for (int i = 0; i < numAnnotations; ++i) {
            BugAnnotation rhs;
            BugAnnotation lhs = this.annotationList.get(i);
            if (lhs.equals(rhs = other.annotationList.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(BugInstance other) {
        int cmp = this.type.compareTo(other.type);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.priority - other.priority;
        if (cmp != 0) {
            return cmp;
        }
        int pfxLen = Math.min(this.annotationList.size(), other.annotationList.size());
        for (int i = 0; i < pfxLen; ++i) {
            BugAnnotation rhs;
            BugAnnotation lhs = this.annotationList.get(i);
            cmp = lhs.compareTo(rhs = other.annotationList.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return this.annotationList.size() - other.annotationList.size();
    }

    public void setFirstVersion(long firstVersion) {
        this.firstVersion = firstVersion;
        if (this.lastVersion >= 0L && firstVersion > this.lastVersion) {
            throw new IllegalArgumentException(firstVersion + ".." + this.lastVersion);
        }
    }

    public long getFirstVersion() {
        return this.firstVersion;
    }

    public void setLastVersion(long lastVersion) {
        if (lastVersion >= 0L && this.firstVersion > lastVersion) {
            throw new IllegalArgumentException(this.firstVersion + ".." + lastVersion);
        }
        this.lastVersion = lastVersion;
    }

    public long getLastVersion() {
        return this.lastVersion;
    }

    public void setIntroducedByChangeOfExistingClass(boolean introducedByChangeOfExistingClass) {
        this.introducedByChangeOfExistingClass = introducedByChangeOfExistingClass;
    }

    public boolean isIntroducedByChangeOfExistingClass() {
        return this.introducedByChangeOfExistingClass;
    }

    public void setRemovedByChangeOfPersistingClass(boolean removedByChangeOfPersistingClass) {
        this.removedByChangeOfPersistingClass = removedByChangeOfPersistingClass;
    }

    public boolean isRemovedByChangeOfPersistingClass() {
        return this.removedByChangeOfPersistingClass;
    }

    public void setInstanceHash(String instanceHash) {
        this.instanceHash = instanceHash;
    }

    public void setOldInstanceHash(String oldInstanceHash) {
        this.oldInstanceHash = oldInstanceHash;
    }

    public String getInstanceHash() {
        if (this.instanceHash != null) {
            return this.instanceHash;
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.instanceHash = this.getInstanceKey();
        if (digest != null && !DONT_HASH) {
            String tmp;
            byte[] data = digest.digest(this.instanceHash.getBytes());
            this.instanceHash = tmp = new BigInteger(1, data).toString(16);
        }
        return this.instanceHash;
    }

    public boolean isInstanceHashConsistent() {
        return this.oldInstanceHash == null || this.instanceHash.equals(this.oldInstanceHash);
    }

    public void setInstanceOccurrenceNum(int instanceOccurrenceNum) {
        this.instanceOccurrenceNum = instanceOccurrenceNum;
    }

    public int getInstanceOccurrenceNum() {
        return this.instanceOccurrenceNum;
    }

    public void setInstanceOccurrenceMax(int instanceOccurrenceMax) {
        this.instanceOccurrenceMax = instanceOccurrenceMax;
    }

    public int getInstanceOccurrenceMax() {
        return this.instanceOccurrenceMax;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BugPropertyIterator
    implements Iterator<BugProperty> {
        private BugProperty prev;
        private BugProperty cur;
        private boolean removed;

        private BugPropertyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.findNext() != null;
        }

        @Override
        public BugProperty next() {
            BugProperty next = this.findNext();
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.cur;
            this.cur = next;
            this.removed = false;
            return this.cur;
        }

        @Override
        public void remove() {
            if (this.cur == null || this.removed) {
                throw new IllegalStateException();
            }
            if (this.prev == null) {
                BugInstance.this.propertyListHead = this.cur.getNext();
            } else {
                this.prev.setNext(this.cur.getNext());
            }
            if (this.cur == BugInstance.this.propertyListTail) {
                BugInstance.this.propertyListTail = this.prev;
            }
            this.removed = true;
        }

        private BugProperty findNext() {
            return this.cur == null ? BugInstance.this.propertyListHead : this.cur.getNext();
        }
    }
}

