/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import java.util.HashSet;
import java.util.Set;

public class ErrorCountingBugReporter
extends DelegatingBugReporter {
    private int bugCount = 0;
    private int missingClassCount = 0;
    private int errorCount = 0;
    private Set<String> missingClassSet = new HashSet<String>();

    public ErrorCountingBugReporter(BugReporter realBugReporter) {
        super(realBugReporter);
        realBugReporter.addObserver(new BugReporterObserver(){

            public void reportBug(BugInstance bugInstance) {
                ++ErrorCountingBugReporter.this.bugCount;
            }
        });
    }

    public int getBugCount() {
        return this.bugCount;
    }

    public int getMissingClassCount() {
        return this.missingClassCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void logError(String message) {
        ++this.errorCount;
        super.logError(message);
    }

    public void reportMissingClass(ClassNotFoundException ex) {
        String missing = AbstractBugReporter.getMissingClassName(ex);
        if (missing == null || missing.startsWith("[")) {
            return;
        }
        if (this.missingClassSet.add(missing)) {
            ++this.missingClassCount;
        }
        super.reportMissingClass(ex);
    }
}

