/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.CheckBcel;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryChooser;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ErrorCountingBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IClassScreener;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.NoClassesFoundToAnalyzeException;
import edu.umd.cs.findbugs.NoOpFindBugsProgress;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TextUICommandLine;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.ba.AnalysisCacheToAnalysisContextAdapter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IAnalysisEngineRegistrar;
import edu.umd.cs.findbugs.classfile.IClassFactory;
import edu.umd.cs.findbugs.classfile.IClassObserver;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IClassPathBuilder;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.engine.asm.EngineRegistrar;
import edu.umd.cs.findbugs.classfile.impl.ClassFactory;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.plan.AnalysisPass;
import edu.umd.cs.findbugs.plan.ExecutionPlan;
import edu.umd.cs.findbugs.plan.OrderingConstraintException;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.TopologicalSort;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.ClassFormatException;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugs2
implements IFindBugsEngine {
    private static final boolean LIST_ORDER = SystemProperties.getBoolean("findbugs.listOrder");
    private static final boolean VERBOSE = SystemProperties.getBoolean("findbugs.verbose");
    public static final boolean DEBUG = VERBOSE || SystemProperties.getBoolean("findbugs.debug");
    private static final boolean SCREEN_FIRST_PASS_CLASSES = SystemProperties.getBoolean("findbugs.screenFirstPass");
    private List<IClassObserver> classObserverList = new LinkedList<IClassObserver>();
    private ErrorCountingBugReporter bugReporter;
    private Project project;
    private IClassFactory classFactory;
    private IClassPath classPath;
    private IAnalysisCache analysisCache;
    private List<ClassDescriptor> appClassList;
    private Collection<ClassDescriptor> referencedClassSet;
    private DetectorFactoryCollection detectorFactoryCollection;
    private ExecutionPlan executionPlan;
    private UserPreferences userPreferences;
    private String currentClassName;
    private String releaseName;
    private String projectName;
    private String sourceInfoFileName;
    private AnalysisFeatureSetting[] analysisFeatureSettingList = FindBugs.DEFAULT_EFFORT;
    private boolean relaxedReportingMode;
    private boolean abridgedMessages;
    private String trainingInputDir;
    private String trainingOutputDir;
    private FindBugsProgress progress = new NoOpFindBugsProgress();
    private IClassScreener classScreener = new IClassScreener(){

        public boolean matches(String fileName) {
            return true;
        }

        public boolean vacuous() {
            return true;
        }
    };
    private boolean scanNestedArchives = false;
    private boolean noClassOk;
    private static final boolean USE_REFERENCES = SystemProperties.getBoolean("tsort.references");

    @Override
    public void setDetectorFactoryCollection(DetectorFactoryCollection detectorFactoryCollection) {
        this.detectorFactoryCollection = detectorFactoryCollection;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        Profiler profiler = Profiler.getInstance();
        try {
            this.classFactory = ClassFactory.instance();
            this.createClassPath();
            this.createAnalysisCache();
            this.progress.reportNumberOfArchives(this.project.getFileCount() + this.project.getNumAuxClasspathEntries());
            profiler.start(this.getClass());
            this.buildClassPath();
            this.buildReferencedClassSet();
            FindBugs2.createAnalysisContext(this.project, this.appClassList, this.sourceInfoFileName);
            FindBugs.configureBugCollection(this);
            FindBugsAnalysisFeatures.setRelaxedMode(this.relaxedReportingMode);
            FindBugsDisplayFeatures.setAbridgedMessages(this.abridgedMessages);
            FindBugs.configureTrainingDatabases(this);
            this.configureAnalysisFeatures();
            this.createExecutionPlan();
            if (!this.classScreener.vacuous()) {
                BugReporter origBugReporter = this.bugReporter.getDelegate();
                DelegatingBugReporter filterBugReporter = new DelegatingBugReporter(origBugReporter){

                    public void reportBug(BugInstance bugInstance) {
                        String className = bugInstance.getPrimaryClass().getClassName();
                        String resourceName = className.replace('.', '/') + ".class";
                        if (FindBugs2.this.classScreener.matches(resourceName)) {
                            this.getDelegate().reportBug(bugInstance);
                        }
                    }
                };
                this.bugReporter.setDelegate(filterBugReporter);
            }
            if (this.appClassList.size() == 0) {
                if (this.noClassOk) {
                    System.err.println("No classfiles specified; output will have no warnings");
                } else {
                    throw new NoClassesFoundToAnalyzeException(this.classPath);
                }
            }
            this.analyzeApplication();
        }
        catch (CheckedAnalysisException e) {
            IOException ioe = new IOException("IOException while scanning codebases");
            ioe.initCause(e);
            throw ioe;
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of memory");
            System.err.println("Total memory: " + Runtime.getRuntime().maxMemory() / 1000000L + "M");
            System.err.println(" free memory: " + Runtime.getRuntime().freeMemory() / 1000000L + "M");
            for (String s : this.project.getFileList()) {
                System.err.println("Analyzed: " + s);
            }
            for (String s : this.project.getAuxClasspathEntryList()) {
                System.err.println("     Aux: " + s);
            }
            throw e;
        }
        finally {
            AnalysisContext.removeCurrentAnalysisContext();
            Global.removeAnalysisCacheForCurrentThread();
            DescriptorFactory.clearInstance();
            ObjectTypeFactory.clearInstance();
            TypeQualifierApplications.clearInstance();
            TypeQualifierAnnotation.clearInstance();
            TypeQualifierValue.clearInstance();
            if (this.classPath != null) {
                this.classPath.close();
            }
            profiler.end(this.getClass());
            profiler.report();
        }
    }

    public void dispose() {
        if (this.executionPlan != null) {
            this.executionPlan.dispose();
        }
        if (this.appClassList != null) {
            this.appClassList.clear();
        }
        if (this.classObserverList != null) {
            this.classObserverList.clear();
        }
        if (this.referencedClassSet != null) {
            this.referencedClassSet.clear();
        }
        this.analysisCache = null;
        this.analysisFeatureSettingList = null;
        this.bugReporter = null;
        this.classFactory = null;
        this.classPath = null;
        this.classScreener = null;
        this.detectorFactoryCollection = null;
        this.executionPlan = null;
        this.progress = null;
        this.project = null;
        this.userPreferences = null;
    }

    @Override
    public BugReporter getBugReporter() {
        return this.bugReporter;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void addClassObserver(IClassObserver classObserver) {
        this.classObserverList.add(classObserver);
    }

    @Override
    public void addFilter(String filterFileName, boolean include) throws IOException, FilterException {
        FindBugs.configureFilter(this.bugReporter, filterFileName, include);
    }

    @Override
    public void excludeBaselineBugs(String baselineBugs) throws IOException, DocumentException {
        FindBugs.configureBaselineFilter(this.bugReporter, baselineBugs);
    }

    @Override
    public void enableTrainingInput(String trainingInputDir) {
        this.trainingInputDir = trainingInputDir;
    }

    @Override
    public void enableTrainingOutput(String trainingOutputDir) {
        this.trainingOutputDir = trainingOutputDir;
    }

    @Override
    public int getBugCount() {
        return this.bugReporter.getBugCount();
    }

    @Override
    public String getCurrentClass() {
        return this.currentClassName;
    }

    @Override
    public int getErrorCount() {
        return this.bugReporter.getErrorCount();
    }

    @Override
    public int getMissingClassCount() {
        return this.bugReporter.getMissingClassCount();
    }

    @Override
    public String getReleaseName() {
        return this.releaseName;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public void setProjectName(String name) {
        this.projectName = name;
    }

    @Override
    public void setAnalysisFeatureSettings(AnalysisFeatureSetting[] settingList) {
        this.analysisFeatureSettingList = settingList;
    }

    @Override
    public void setBugReporter(BugReporter bugReporter) {
        this.bugReporter = new ErrorCountingBugReporter(bugReporter);
        this.addClassObserver(bugReporter);
    }

    @Override
    public void setClassScreener(IClassScreener classScreener) {
        this.classScreener = classScreener;
    }

    @Override
    public void setProgressCallback(FindBugsProgress progressCallback) {
        this.progress = progressCallback;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public void setRelaxedReportingMode(boolean relaxedReportingMode) {
        this.relaxedReportingMode = relaxedReportingMode;
    }

    @Override
    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    @Override
    public void setSourceInfoFile(String sourceInfoFile) {
        this.sourceInfoFileName = sourceInfoFile;
    }

    @Override
    public void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    @Override
    public boolean emitTrainingOutput() {
        return this.trainingOutputDir != null;
    }

    @Override
    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    private void createClassPath() {
        this.classPath = this.classFactory.createClassPath();
    }

    @Override
    public String getTrainingInputDir() {
        return this.trainingInputDir;
    }

    @Override
    public String getTrainingOutputDir() {
        return this.trainingOutputDir;
    }

    @Override
    public boolean useTrainingInput() {
        return this.trainingInputDir != null;
    }

    @Override
    public void setScanNestedArchives(boolean scanNestedArchives) {
        this.scanNestedArchives = scanNestedArchives;
    }

    @Override
    public void setNoClassOk(boolean noClassOk) {
        this.noClassOk = noClassOk;
    }

    private void createAnalysisCache() throws IOException {
        this.analysisCache = ClassFactory.instance().createAnalysisCache(this.classPath, this.bugReporter);
        FindBugs2.registerBuiltInAnalysisEngines(this.analysisCache);
        FindBugs2.registerPluginAnalysisEngines(this.detectorFactoryCollection, this.analysisCache);
        this.analysisCache.eagerlyPutDatabase(DetectorFactoryCollection.class, this.detectorFactoryCollection);
        Global.setAnalysisCacheForCurrentThread(this.analysisCache);
    }

    public static void registerBuiltInAnalysisEngines(IAnalysisCache analysisCache) {
        new edu.umd.cs.findbugs.classfile.engine.EngineRegistrar().registerAnalysisEngines(analysisCache);
        new EngineRegistrar().registerAnalysisEngines(analysisCache);
        new edu.umd.cs.findbugs.classfile.engine.bcel.EngineRegistrar().registerAnalysisEngines(analysisCache);
    }

    public static void registerPluginAnalysisEngines(DetectorFactoryCollection detectorFactoryCollection, IAnalysisCache analysisCache) throws IOException {
        Iterator<Plugin> i = detectorFactoryCollection.pluginIterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            Class<? extends IAnalysisEngineRegistrar> engineRegistrarClass = plugin.getEngineRegistrarClass();
            if (engineRegistrarClass == null) continue;
            try {
                IAnalysisEngineRegistrar engineRegistrar = engineRegistrarClass.newInstance();
                engineRegistrar.registerAnalysisEngines(analysisCache);
            }
            catch (InstantiationException e) {
                IOException ioe = new IOException("Could not create analysis engine registrar for plugin " + plugin.getPluginId());
                ioe.initCause(e);
                throw ioe;
            }
            catch (IllegalAccessException e) {
                IOException ioe = new IOException("Could not create analysis engine registrar for plugin " + plugin.getPluginId());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private void buildClassPath() throws InterruptedException, IOException, CheckedAnalysisException {
        IClassPathBuilder builder = this.classFactory.createClassPathBuilder(this.bugReporter);
        for (String path : this.project.getFileArray()) {
            builder.addCodeBase(this.classFactory.createFilesystemCodeBaseLocator(path), true);
        }
        for (String path : this.project.getAuxClasspathEntryList()) {
            builder.addCodeBase(this.classFactory.createFilesystemCodeBaseLocator(path), false);
        }
        builder.scanNestedArchives(this.scanNestedArchives);
        builder.build(this.classPath, this.progress);
        this.appClassList = builder.getAppClassList();
        if (DEBUG) {
            System.out.println(this.appClassList.size() + " classes scanned");
        }
        Iterator<? extends ICodeBase> i = this.classPath.appCodeBaseIterator();
        while (i.hasNext()) {
            String pathName;
            ICodeBase appCodeBase = i.next();
            if (appCodeBase.containsSourceFiles() && (pathName = appCodeBase.getPathName()) != null) {
                this.project.addSourceDir(pathName);
            }
            this.project.addTimestamp(appCodeBase.getLastModifiedTime());
        }
    }

    private void buildReferencedClassSet() throws CheckedAnalysisException, InterruptedException {
        if (DEBUG) {
            System.out.println("Adding referenced classes");
        }
        HashSet<String> referencedPackageSet = new HashSet<String>();
        LinkedList<ClassDescriptor> workList = new LinkedList<ClassDescriptor>();
        workList.addAll(this.appClassList);
        HashSet<ClassDescriptor> seen = new HashSet<ClassDescriptor>();
        HashSet<ClassDescriptor> appClassSet = new HashSet<ClassDescriptor>(this.appClassList);
        HashSet<ClassDescriptor> badAppClassSet = new HashSet<ClassDescriptor>();
        HashSet<ClassDescriptor> knownDescriptors = new HashSet<ClassDescriptor>(DescriptorFactory.instance().getAllClassDescriptors());
        int count = 0;
        while (!workList.isEmpty()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ClassDescriptor classDesc = (ClassDescriptor)workList.removeFirst();
            if (seen.contains(classDesc)) continue;
            seen.add(classDesc);
            if (!knownDescriptors.contains(classDesc) && DEBUG && ++count % 5000 == 0) {
                System.out.println("Adding referenced class " + classDesc);
            }
            referencedPackageSet.add(classDesc.getPackageName());
            try {
                XClass classNameAndInfo = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDesc);
                if (classNameAndInfo.getSuperclassDescriptor() != null) {
                    workList.addLast(classNameAndInfo.getSuperclassDescriptor());
                }
                for (ClassDescriptor ifaceDesc : classNameAndInfo.getInterfaceDescriptorList()) {
                    workList.addLast(ifaceDesc);
                }
            }
            catch (RuntimeException e) {
                this.bugReporter.logError("Error scanning " + classDesc + " for referenced classes", e);
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
            catch (MissingClassException e) {
                this.bugReporter.reportMissingClass(e.getClassDescriptor());
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError("Error scanning " + classDesc + " for referenced classes", e);
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
        }
        this.appClassList.removeAll(badAppClassSet);
        DescriptorFactory.instance().purge(badAppClassSet);
        for (ClassDescriptor d : DescriptorFactory.instance().getAllClassDescriptors()) {
            referencedPackageSet.add(d.getPackageName());
        }
        if (DEBUG) {
            referencedPackageSet.remove("");
            System.out.println("Added " + count + " referenced classes");
            System.out.println("Total of " + referencedPackageSet.size() + " packages");
        }
        if (Boolean.getBoolean("fb.addPackageInfo")) {
            for (String pkg : referencedPackageSet) {
                ClassDescriptor pkgInfoDesc = DescriptorFactory.instance().getClassDescriptorForDottedClassName(pkg + ".package-info");
                if (DEBUG) {
                    System.out.println("Checking package " + pkg + " for package-info...");
                }
                try {
                    this.analysisCache.getClassAnalysis(ClassData.class, pkgInfoDesc);
                    this.analysisCache.getClassAnalysis(XClass.class, pkgInfoDesc);
                    if (!DEBUG) continue;
                    System.out.println("   Adding " + pkgInfoDesc + " to referenced classes");
                }
                catch (CheckedAnalysisException e) {}
            }
        }
        this.referencedClassSet = new ArrayList<ClassDescriptor>(DescriptorFactory.instance().getAllClassDescriptors());
    }

    public List<ClassDescriptor> sortByCallGraph(Collection<ClassDescriptor> classList, TopologicalSort.OutEdges<ClassDescriptor> outEdges) {
        List<ClassDescriptor> evaluationOrder = TopologicalSort.sortByCallGraph(classList, outEdges);
        TopologicalSort.countBadEdges(evaluationOrder, outEdges);
        return evaluationOrder;
    }

    public static void clearAnalysisContext() {
        AnalysisContext.removeCurrentAnalysisContext();
    }

    public static void createAnalysisContext(Project project, List<ClassDescriptor> appClassList, String sourceInfoFileName) throws CheckedAnalysisException, IOException {
        AnalysisCacheToAnalysisContextAdapter analysisContext = new AnalysisCacheToAnalysisContextAdapter();
        AnalysisContext.setCurrentAnalysisContext(analysisContext);
        analysisContext.clearRepository();
        analysisContext.setAppClassList(appClassList);
        if (sourceInfoFileName != null) {
            SourceInfoMap sourceInfoMap = analysisContext.getSourceInfoMap();
            sourceInfoMap.read(new FileInputStream(sourceInfoFileName));
        }
        analysisContext.setSourcePath(project.getSourceDirList());
    }

    private void configureAnalysisFeatures() {
        for (AnalysisFeatureSetting setting : this.analysisFeatureSettingList) {
            setting.configure(AnalysisContext.currentAnalysisContext());
        }
    }

    private void createExecutionPlan() throws OrderingConstraintException {
        this.executionPlan = new ExecutionPlan();
        DetectorFactoryChooser detectorFactoryChooser = new DetectorFactoryChooser(){
            HashSet<DetectorFactory> forcedEnabled = new HashSet();

            public boolean choose(DetectorFactory factory) {
                return FindBugs.isDetectorEnabled(FindBugs2.this, factory) || this.forcedEnabled.contains(factory);
            }

            public void enable(DetectorFactory factory) {
                this.forcedEnabled.add(factory);
                factory.setEnabledButNonReporting(true);
            }
        };
        this.executionPlan.setDetectorFactoryChooser(detectorFactoryChooser);
        Iterator<Plugin> i = this.detectorFactoryCollection.pluginIterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            if (DEBUG) {
                System.out.println("Adding plugin " + plugin.getPluginId() + " to execution plan");
            }
            this.executionPlan.addPlugin(plugin);
        }
        this.executionPlan.build();
        if (DEBUG) {
            System.out.println(this.executionPlan.getNumPasses() + " passes in execution plan");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeApplication() throws InterruptedException {
        int passCount = 0;
        Profiler profiler = Profiler.getInstance();
        profiler.start(this.getClass());
        AnalysisContext.currentXFactory().canonicalizeAll();
        try {
            boolean multiplePasses;
            boolean bl = multiplePasses = this.executionPlan.getNumPasses() > 1;
            if (this.executionPlan.getNumPasses() == 0) {
                throw new AssertionError((Object)"no analysis passes");
            }
            int[] classesPerPass = new int[this.executionPlan.getNumPasses()];
            classesPerPass[0] = this.referencedClassSet.size();
            for (int i = 0; i < classesPerPass.length; ++i) {
                classesPerPass[i] = i == 0 ? this.referencedClassSet.size() : this.appClassList.size();
            }
            this.progress.predictPassCount(classesPerPass);
            XFactory factory = AnalysisContext.currentXFactory();
            for (ClassDescriptor desc : this.referencedClassSet) {
                try {
                    XClass info = Global.getAnalysisCache().getClassAnalysis(XClass.class, desc);
                    factory.intern(info);
                }
                catch (CheckedAnalysisException e) {
                    AnalysisContext.logError("Couldn't get class info for " + desc, e);
                }
            }
            Iterator<AnalysisPass> i = this.executionPlan.passIterator();
            while (i.hasNext()) {
                AnalysisPass pass = i.next();
                boolean isNonReportingFirstPass = multiplePasses && passCount == 0;
                Detector2[] detectorList = pass.instantiateDetector2sInPass(this.bugReporter);
                Collection<ClassDescriptor> classCollection = isNonReportingFirstPass ? this.referencedClassSet : this.appClassList;
                AnalysisContext.currentXFactory().canonicalizeAll();
                if (DEBUG || LIST_ORDER) {
                    System.out.println("Pass " + passCount + ": " + classCollection.size() + " classes");
                    XFactory.profile();
                }
                if (!isNonReportingFirstPass) {
                    TopologicalSort.OutEdges<ClassDescriptor> outEdges = new TopologicalSort.OutEdges<ClassDescriptor>(){

                        @Override
                        public Collection<ClassDescriptor> getOutEdges(ClassDescriptor e) {
                            try {
                                XClass classNameAndInfo = Global.getAnalysisCache().getClassAnalysis(XClass.class, e);
                                if (classNameAndInfo instanceof ClassNameAndSuperclassInfo) {
                                    return ((ClassNameAndSuperclassInfo)((Object)classNameAndInfo)).getCalledClassDescriptorList();
                                }
                                assert (false);
                                return TigerSubstitutes.emptyList();
                            }
                            catch (CheckedAnalysisException e2) {
                                AnalysisContext.logError("error while analyzing " + e.getClassName(), e2);
                                return TigerSubstitutes.emptyList();
                            }
                        }
                    };
                    List<ClassDescriptor> result = this.sortByCallGraph(classCollection, outEdges);
                    classCollection = result;
                }
                if (LIST_ORDER) {
                    System.out.println("Analysis order:");
                    for (ClassDescriptor c : classCollection) {
                        System.out.println("  " + c);
                    }
                }
                this.progress.startAnalysis(classCollection.size());
                int count = 0;
                Global.getAnalysisCache().purgeAllMethodAnalysis();
                for (ClassDescriptor classDescriptor : classCollection) {
                    if (DEBUG) {
                        System.out.println(count + "/" + classCollection.size() + ": Class " + classDescriptor);
                        ++count;
                    }
                    if (!(!SCREEN_FIRST_PASS_CLASSES && isNonReportingFirstPass || this.classScreener.matches(classDescriptor.toResourceName()))) {
                        if (!DEBUG) continue;
                        System.out.println("*** Excluded by class screener");
                        continue;
                    }
                    boolean isHuge = AnalysisContext.currentAnalysisContext().isTooBig(classDescriptor);
                    if (isHuge && AnalysisContext.currentAnalysisContext().isApplicationClass(classDescriptor)) {
                        this.bugReporter.reportBug(new BugInstance("SKIPPED_CLASS_TOO_BIG", 2).addClass(classDescriptor));
                    }
                    this.currentClassName = ClassName.toDottedClassName(classDescriptor.getClassName());
                    this.notifyClassObservers(classDescriptor);
                    for (Detector2 detector : detectorList) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        if (isHuge && !NonReportingDetector.class.isAssignableFrom(detector.getClass())) continue;
                        try {
                            profiler.start(detector.getClass());
                            detector.visitClass(classDescriptor);
                        }
                        catch (ClassFormatException e) {
                            this.logRecoverableException(classDescriptor, detector, e);
                        }
                        catch (MissingClassException e) {
                            Global.getAnalysisCache().getErrorLogger().reportMissingClass(e.getClassDescriptor());
                        }
                        catch (CheckedAnalysisException e) {
                            this.logRecoverableException(classDescriptor, detector, e);
                        }
                        catch (AnalysisException e) {
                            this.logRecoverableException(classDescriptor, detector, e);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.logRecoverableException(classDescriptor, detector, e);
                        }
                        catch (ClassCastException e) {
                            this.logRecoverableException(classDescriptor, detector, e);
                        }
                        catch (RuntimeException e) {
                            this.logRecoverableException(classDescriptor, detector, e);
                        }
                        finally {
                            profiler.end(detector.getClass());
                        }
                    }
                    this.progress.finishClass();
                }
                for (Detector2 detector : detectorList) {
                    detector.finishPass();
                }
                AnalysisContext.currentAnalysisContext().updateDatabases(passCount);
                this.progress.finishPerClassAnalysis();
                ++passCount;
            }
            this.bugReporter.finish();
            this.bugReporter.reportQueuedErrors();
        }
        finally {
            profiler.end(this.getClass());
        }
    }

    private void notifyClassObservers(ClassDescriptor classDescriptor) {
        for (IClassObserver observer : this.classObserverList) {
            observer.observeClass(classDescriptor);
        }
    }

    private void logRecoverableException(ClassDescriptor classDescriptor, Detector2 detector, Throwable e) {
        this.bugReporter.logError("Exception analyzing " + classDescriptor.toDottedClassName() + " using detector " + detector.getDetectorClassName(), e);
    }

    public static void main(String[] args) throws Exception {
        if (!CheckBcel.check()) {
            System.exit(1);
        }
        FindBugs2 findBugs = new FindBugs2();
        TextUICommandLine commandLine = new TextUICommandLine();
        FindBugs.processCommandLine(commandLine, args, findBugs);
        FindBugs.runMain(findBugs, commandLine);
    }

    @Override
    public void setAbridgedMessages(boolean xmlWithAbridgedMessages) {
        this.abridgedMessages = xmlWithAbridgedMessages;
    }
}

