/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.JUnitDetectorAdapter;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PrintingBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.RunnableWithExceptions;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;

public abstract class FindBugsTestCase
extends TestCase {
    public static final byte[] EMPTY_CLASS_DATA = new byte[]{-54, -2, -70, -66, 0, 0, 0, 50, 0, 13, 10, 0, 3, 0, 10, 7, 0, 11, 7, 0, 12, 1, 0, 6, 60, 105, 110, 105, 116, 62, 1, 0, 3, 40, 41, 86, 1, 0, 4, 67, 111, 100, 101, 1, 0, 15, 76, 105, 110, 101, 78, 117, 109, 98, 101, 114, 84, 97, 98, 108, 101, 1, 0, 10, 83, 111, 117, 114, 99, 101, 70, 105, 108, 101, 1, 0, 10, 69, 109, 112, 116, 121, 46, 106, 97, 118, 97, 12, 0, 4, 0, 5, 1, 0, 5, 69, 109, 112, 116, 121, 1, 0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 0, 33, 0, 2, 0, 3, 0, 0, 0, 0, 0, 1, 0, 1, 0, 4, 0, 5, 0, 1, 0, 6, 0, 0, 0, 29, 0, 1, 0, 1, 0, 0, 0, 5, 42, -73, 0, 1, -79, 0, 0, 0, 1, 0, 7, 0, 0, 0, 6, 0, 1, 0, 0, 0, 1, 0, 1, 0, 8, 0, 0, 0, 2, 0, 9};

    protected void executeFindBugsTest(RunnableWithExceptions runnable) throws Exception {
        TestRunnerThread thread = new TestRunnerThread(runnable);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
        if (thread.getDetectorAdapter() == null) {
            throw new IllegalStateException("Test code did not complete");
        }
        thread.getDetectorAdapter().finishTest();
    }

    private static final class TestRunnerThread
    extends Thread {
        private RunnableWithExceptions runnable;
        private JUnitDetectorAdapter detectorAdapter;

        private TestRunnerThread(RunnableWithExceptions runnable) {
            this.runnable = runnable;
        }

        public JUnitDetectorAdapter getDetectorAdapter() {
            return this.detectorAdapter;
        }

        public void run() {
            try {
                this.runTest(this.runnable);
            }
            catch (Exception e) {
                System.err.println("Exception running test:");
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTest(RunnableWithExceptions runnable) throws IOException, InterruptedException {
            File tmpdir = File.createTempFile("fbtest", null);
            if (!tmpdir.delete() || !tmpdir.mkdir()) {
                throw new IOException("Could not create temp dir");
            }
            File tmpfile = null;
            try {
                tmpfile = this.createEmptyClassFile(tmpdir);
                FindBugs2 engine = new FindBugs2();
                engine.setBugReporter(new PrintingBugReporter());
                Project project = new Project();
                project.addFile(tmpdir.getAbsolutePath());
                engine.setProject(project);
                DetectorFactoryCollection dfc = new DetectorFactoryCollection();
                DetectorFactoryCollection.resetInstance(dfc);
                Plugin fakePlugin = new Plugin("edu.umd.cs.findbugs.fakeplugin", null);
                fakePlugin.setEnabled(true);
                dfc.setPlugins(new Plugin[]{fakePlugin});
                DetectorFactory detectorFactory = new DetectorFactory(fakePlugin, JUnitDetectorAdapter.class, true, "fast", "", "");
                fakePlugin.addDetectorFactory(detectorFactory);
                dfc.registerDetector(detectorFactory);
                if (!dfc.factoryIterator().hasNext() || !fakePlugin.detectorFactoryIterator().hasNext()) {
                    throw new IllegalStateException();
                }
                engine.setDetectorFactoryCollection(dfc);
                engine.setUserPreferences(UserPreferences.createDefaultUserPreferences());
                JUnitDetectorAdapter.setRunnable(runnable);
                engine.execute();
                this.detectorAdapter = JUnitDetectorAdapter.instance();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                if (tmpfile != null) {
                    this.deleteAndLog(tmpfile);
                }
                this.deleteAndLog(tmpdir);
            }
        }

        void deleteAndLog(File f) {
            if (!f.delete()) {
                System.err.println("Could not delete " + f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createEmptyClassFile(File tmpdir) throws IOException {
            File outFile = new File(tmpdir, "Empty.class");
            FileOutputStream out = new FileOutputStream(outFile);
            try {
                ((OutputStream)out).write(EMPTY_CLASS_DATA);
            }
            finally {
                ((OutputStream)out).close();
            }
            return outFile;
        }
    }
}

