/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.CheckBcel;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.gui.FindBugsFrame;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;

public class LaunchAppropriateUI {
    public static void main(String[] args) throws Exception {
        int launchProperty = LaunchAppropriateUI.getLaunchProperty();
        if (!CheckBcel.check()) {
            System.exit(1);
        }
        if (GraphicsEnvironment.isHeadless() || launchProperty == 0) {
            FindBugs2.main(args);
        } else {
            String version = System.getProperty("java.version");
            Class launchClass = null;
            if ("1.5".compareTo(version) <= 0) {
                try {
                    launchClass = Class.forName("edu.umd.cs.findbugs.gui2.Driver", false, LaunchAppropriateUI.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (launchClass == null || launchProperty == 1) {
                launchClass = FindBugsFrame.class;
            }
            Method mainMethod = launchClass.getMethod("main", args.getClass());
            mainMethod.invoke(null, new Object[]{args});
        }
    }

    public static int getLaunchProperty() {
        String s = System.getProperty("findbugs.launchUI", "2");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return 2;
        }
    }
}

