/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationUtil;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsMessageFormat;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.InstructionHandle;

public class LocalVariableAnnotation
implements BugAnnotation {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ROLE = "LOCAL_VARIABLE_DEFAULT";
    private final String value;
    final int register;
    final int pc;
    private String description;
    private static final String ELEMENT_NAME = "LocalVariable";

    public LocalVariableAnnotation(String name, int register, int pc) {
        this.value = name;
        this.register = register;
        this.pc = pc;
        this.description = DEFAULT_ROLE;
        this.setDescription(name.equals("?") ? "LOCAL_VARIABLE_UNKNOWN" : "LOCAL_VARIABLE_NAMED");
    }

    public static LocalVariableAnnotation getLocalVariableAnnotation(Method method, Location location, IndexedInstruction ins) {
        int local = ins.getIndex();
        InstructionHandle handle = location.getHandle();
        int position1 = handle.getNext().getPosition();
        int position2 = handle.getPosition();
        return LocalVariableAnnotation.getLocalVariableAnnotation(method, local, position1, position2);
    }

    public static LocalVariableAnnotation getLocalVariableAnnotation(Method method, int local, int position1, int position2) {
        LocalVariableTable localVariableTable = method.getLocalVariableTable();
        String localName = "?";
        if (localVariableTable != null) {
            LocalVariable lv1 = localVariableTable.getLocalVariable(local, position1);
            if (lv1 == null) {
                lv1 = localVariableTable.getLocalVariable(local, position2);
                position1 = position2;
            }
            if (lv1 != null) {
                localName = lv1.getName();
            }
        }
        return new LocalVariableAnnotation(localName, local, position1);
    }

    public static LocalVariableAnnotation getParameterLocalVariableAnnotation(Method method, int local) {
        LocalVariableAnnotation lva = LocalVariableAnnotation.getLocalVariableAnnotation(method, local, 0, 0);
        return lva;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitLocalVariableAnnotation(this);
    }

    public String format(String key, ClassAnnotation primaryClass) {
        if (key.equals("hash")) {
            if (this.register < 0) {
                return "??";
            }
            return this.value;
        }
        if (this.register < 0) {
            return "?";
        }
        if (key.equals("register")) {
            return String.valueOf(this.register);
        }
        if (key.equals("pc")) {
            return String.valueOf(this.pc);
        }
        if (key.equals("name") || key.equals("givenClass")) {
            return this.value;
        }
        if (!this.value.equals("?")) {
            return this.value;
        }
        return "$L" + this.register;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariableAnnotation)) {
            return false;
        }
        return this.value.equals(((LocalVariableAnnotation)o).value);
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof LocalVariableAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return this.value.compareTo(((LocalVariableAnnotation)o).value);
    }

    public String toString() {
        String pattern = I18N.instance().getAnnotationDescription(this.description);
        FindBugsMessageFormat format = new FindBugsMessageFormat(pattern);
        return format.format(new BugAnnotation[]{this}, null);
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, false, false);
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("name", this.value).addAttribute("register", String.valueOf(this.register)).addAttribute("pc", String.valueOf(this.pc));
        String role = this.getDescription();
        if (!role.equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        BugAnnotationUtil.writeXML(xmlOutput, ELEMENT_NAME, this, attributeList, addMessages);
    }

    public String getName() {
        return this.value;
    }

    public int getPC() {
        return this.pc;
    }

    public int getRegister() {
        return this.register;
    }

    public boolean isSignificant() {
        return !this.value.equals("?");
    }
}

