/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageStats
implements XMLWriteable {
    public static final String ELEMENT_NAME = "PackageStats";
    public static final int ALL_ERRORS = 0;
    private final String packageName;
    private int[] nBugs = new int[]{0, 0, 0, 0, 0};
    private int size;
    private SortedMap<String, ClassStats> packageMembers = new TreeMap<String, ClassStats>();

    public PackageStats(String packageName) {
        this.packageName = packageName;
    }

    public Collection<ClassStats> getClassStats() {
        return this.packageMembers.values();
    }

    public int getTotalBugs() {
        return this.nBugs[0];
    }

    public int size() {
        return this.size;
    }

    public int getBugsAtPriority(int p) {
        return this.nBugs[p];
    }

    private ClassStats getClassStats(String name, String sourceFile) {
        ClassStats result = (ClassStats)this.packageMembers.get(name);
        if (result == null) {
            result = new ClassStats(name, sourceFile);
            this.packageMembers.put(name, result);
        }
        return result;
    }

    public ClassStats getClassStatsOrNull(String name) {
        ClassStats result = (ClassStats)this.packageMembers.get(name);
        return result;
    }

    public void addError(BugInstance bug) {
        if (bug.getPriority() >= this.nBugs.length) {
            return;
        }
        int n = bug.getPriority();
        this.nBugs[n] = this.nBugs[n] + 1;
        this.nBugs[0] = this.nBugs[0] + 1;
        ClassAnnotation primaryClass = bug.getPrimaryClass();
        this.getClassStats(primaryClass.getClassName(), primaryClass.getSourceFileName()).addError(bug);
    }

    @Deprecated
    public void addClass(String name, boolean isInterface, int size) {
        this.addClass(name, null, isInterface, size);
    }

    public void addClass(String name, String sourceFile, boolean isInterface, int size) {
        ClassStats classStats = this.getClassStats(name, sourceFile);
        classStats.setInterface(isInterface);
        classStats.setSize(size);
        this.size += size;
    }

    public void addClass(ClassStats classStats) {
        this.packageMembers.put(classStats.getName(), classStats);
        this.size += classStats.size();
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        xmlOutput.startTag(ELEMENT_NAME);
        xmlOutput.addAttribute("package", this.packageName);
        xmlOutput.addAttribute("total_bugs", String.valueOf(this.nBugs[0]));
        xmlOutput.addAttribute("total_types", String.valueOf(this.packageMembers.size()));
        xmlOutput.addAttribute("total_size", String.valueOf(this.size));
        PackageStats.writeBugPriorities(xmlOutput, this.nBugs);
        xmlOutput.stopTag(false);
        for (ClassStats classStats : this.packageMembers.values()) {
            classStats.writeXML(xmlOutput);
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }

    public static void writeBugPriorities(XMLOutput xmlOutput, int[] bugs) throws IOException {
        int i = bugs.length;
        while (--i > 0) {
            if (bugs[i] <= 0) continue;
            xmlOutput.addAttribute("priority_" + i, String.valueOf(bugs[i]));
        }
    }

    public void recomputeFromClassStats() {
        for (int i = 0; i < this.nBugs.length; ++i) {
            this.nBugs[i] = 0;
        }
        this.size = 0;
        for (ClassStats classStats : this.packageMembers.values()) {
            for (int i = 0; i < this.nBugs.length; ++i) {
                int n = i;
                this.nBugs[n] = this.nBugs[n] + classStats.getBugsAtPriority(i);
            }
            this.size += classStats.size;
        }
    }

    public void clearBugCounts() {
        for (int i = 0; i < this.nBugs.length; ++i) {
            this.nBugs[i] = 0;
        }
        for (ClassStats classStats : this.packageMembers.values()) {
            classStats.clearBugCounts();
        }
    }

    public static class ClassStats
    implements XMLWriteable,
    Cloneable {
        private final String name;
        private final String sourceFile;
        private boolean isInterface;
        private final int[] nBugs = new int[]{0, 0, 0, 0, 0};
        private int size;

        public ClassStats(String name, String sourceFile) {
            this.name = name;
            this.sourceFile = sourceFile;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void setInterface(boolean isInterface) {
            this.isInterface = isInterface;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void addError(BugInstance bug) {
            int n = bug.getPriority();
            this.nBugs[n] = this.nBugs[n] + 1;
            this.nBugs[0] = this.nBugs[0] + 1;
        }

        public int getTotalBugs() {
            return this.nBugs[0];
        }

        public int getBugsAtPriority(int p) {
            return this.nBugs[p];
        }

        public int size() {
            return this.size;
        }

        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getSourceFile() {
            return this.sourceFile;
        }

        public void writeXML(XMLOutput xmlOutput) throws IOException {
            xmlOutput.startTag("ClassStats");
            xmlOutput.addAttribute("class", this.name);
            if (this.sourceFile != null) {
                xmlOutput.addAttribute("sourceFile", this.sourceFile);
            }
            xmlOutput.addAttribute("interface", String.valueOf(this.isInterface));
            xmlOutput.addAttribute("size", String.valueOf(this.size));
            xmlOutput.addAttribute("bugs", String.valueOf(this.nBugs[0]));
            PackageStats.writeBugPriorities(xmlOutput, this.nBugs);
            xmlOutput.stopTag(true);
        }

        public void clearBugCounts() {
            for (int i = 0; i < this.nBugs.length; ++i) {
                this.nBugs[i] = 0;
            }
        }
    }
}

