/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisLocal;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnnotationRetentionDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnAnnotationDatabase;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.INullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.InnerClassAccessMap;
import edu.umd.cs.findbugs.ba.JCIPAnnotationDatabase;
import edu.umd.cs.findbugs.ba.LegacyAnalysisContext;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.ch.Subtypes;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import edu.umd.cs.findbugs.ba.jsr305.DirectlyRelevantTypeQualifiersDatabase;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.ReturnValueNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.detect.UnreadFields;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class AnalysisContext {
    public static final boolean DEBUG = SystemProperties.getBoolean("findbugs.analysiscontext.debug");
    public static final boolean IGNORE_BUILTIN_MODELS = SystemProperties.getBoolean("findbugs.ignoreBuiltinModels");
    public static final String DEFAULT_NONNULL_PARAM_DATABASE_FILENAME = "nonnullParam.db";
    public static final String DEFAULT_CHECK_FOR_NULL_PARAM_DATABASE_FILENAME = "checkForNullParam.db";
    public static final String DEFAULT_NULL_RETURN_VALUE_ANNOTATION_DATABASE = "nullReturn.db";
    public static final String UNCONDITIONAL_DEREF_DB_FILENAME = "unconditionalDeref.db";
    public static final String NONNULL_RETURN_DB_FILENAME = "nonnullReturn.db";
    public static final String UNCONDITIONAL_DEREF_DB_RESOURCE = "jdkBaseUnconditionalDeref.db";
    public static final String NONNULL_RETURN_DB_RESOURCE = "jdkBaseNonnullReturn.db";
    public static final String DEFAULT_NULL_RETURN_VALUE_DB_FILENAME = "mayReturnNull.db";
    private static InheritableThreadLocal<AnalysisContext> currentAnalysisContext = new InheritableThreadLocal<AnalysisContext>(){

        @Override
        public AnalysisContext initialValue() {
            return null;
        }
    };
    private static AnalysisLocal<XFactory> currentXFactory = new AnalysisLocal<XFactory>(){

        @Override
        public XFactory initialValue() {
            throw new IllegalStateException("currentXFactory should be set by AnalysisContext.setCurrentAnalysisContext");
        }
    };
    private static final org.apache.bcel.util.Repository originalRepository = Repository.getRepository();
    private static final int DEFAULT_CACHE_SIZE = 3;
    private BitSet boolPropertySet = new BitSet();
    private String databaseInputDir;
    private String databaseOutputDir;
    FieldSummary fieldSummary;
    UnreadFields unreadFields;
    DirectlyRelevantTypeQualifiersDatabase directlyRelevantTypeQualifiersDatabase;
    boolean missingClassWarningsSuppressed = false;

    public abstract INullnessAnnotationDatabase getNullnessAnnotationDatabase();

    public abstract CheckReturnAnnotationDatabase getCheckReturnAnnotationDatabase();

    public abstract AnnotationRetentionDatabase getAnnotationRetentionDatabase();

    public abstract JCIPAnnotationDatabase getJCIPAnnotationDatabase();

    protected AnalysisContext() {
    }

    private void clear() {
        this.boolPropertySet = null;
        this.databaseInputDir = null;
        this.databaseOutputDir = null;
    }

    public static AnalysisContext create(RepositoryLookupFailureCallback lookupFailureCallback) {
        LegacyAnalysisContext analysisContext = new LegacyAnalysisContext(lookupFailureCallback);
        AnalysisContext.setCurrentAnalysisContext(analysisContext);
        return analysisContext;
    }

    public abstract void initDatabases();

    public abstract void updateDatabases(int var1);

    public static AnalysisContext currentAnalysisContext() {
        return (AnalysisContext)currentAnalysisContext.get();
    }

    public static XFactory currentXFactory() {
        return currentXFactory.get();
    }

    public FieldSummary getFieldSummary() {
        if (this.fieldSummary == null) {
            throw new IllegalStateException("FieldSummary detector not set");
        }
        return this.fieldSummary;
    }

    public void setFieldSummary(@NonNull FieldSummary fieldSummary) {
        if (this.fieldSummary != null) {
            throw new IllegalStateException("FieldSummary detector already set");
        }
        this.fieldSummary = fieldSummary;
    }

    public UnreadFields getUnreadFields() {
        if (this.unreadFields == null) {
            throw new IllegalStateException("UnreadFields detector not set");
        }
        return this.unreadFields;
    }

    public void setUnreadFields(@NonNull UnreadFields unreadFields) {
        if (this.unreadFields != null) {
            throw new IllegalStateException("UnreadFields detector already set");
        }
        this.unreadFields = unreadFields;
    }

    public DirectlyRelevantTypeQualifiersDatabase getDirectlyRelevantTypeQualifiersDatabase() {
        if (this.directlyRelevantTypeQualifiersDatabase == null) {
            throw new IllegalStateException("DirectlyRelevantTypeQualifiersDatabase  not set");
        }
        return this.directlyRelevantTypeQualifiersDatabase;
    }

    public void setDirectlyRelevantTypeQualifiersDatabase(@NonNull DirectlyRelevantTypeQualifiersDatabase directlyRelevantTypeQualifiersDatabase) {
        if (this.directlyRelevantTypeQualifiersDatabase != null) {
            throw new IllegalStateException("DirectlyRelevantTypeQualifiersDatabase  already set");
        }
        this.directlyRelevantTypeQualifiersDatabase = directlyRelevantTypeQualifiersDatabase;
    }

    public static void reportMissingClass(ClassNotFoundException e) {
        if (e == null) {
            throw new NullPointerException("argument is null");
        }
        String missing = AbstractBugReporter.getMissingClassName(e);
        if (missing.length() == 0) {
            return;
        }
        if (missing.charAt(0) == '[') {
            return;
        }
        if (missing.endsWith("package-info")) {
            return;
        }
        AnalysisContext currentAnalysisContext2 = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext2 == null) {
            return;
        }
        if (currentAnalysisContext2.missingClassWarningsSuppressed) {
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = currentAnalysisContext2.getLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.reportMissingClass(e);
        }
    }

    public static void logError(String msg, Exception e) {
        if (e instanceof MissingClassException) {
            AnalysisContext.reportMissingClass(((MissingClassException)e).getClassNotFoundException());
            return;
        }
        if (e instanceof edu.umd.cs.findbugs.classfile.MissingClassException) {
            AnalysisContext.reportMissingClass(((edu.umd.cs.findbugs.classfile.MissingClassException)e).toClassNotFoundException());
            return;
        }
        AnalysisContext currentAnalysisContext2 = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext2 == null) {
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = currentAnalysisContext2.getLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.logError(msg, e);
        }
    }

    public static void logError(String msg) {
        AnalysisContext currentAnalysisContext2 = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext2 == null) {
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = currentAnalysisContext2.getLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.logError(msg);
        }
    }

    public boolean setMissingClassWarningsSuppressed(boolean value) {
        boolean oldValue = this.missingClassWarningsSuppressed;
        this.missingClassWarningsSuppressed = value;
        return oldValue;
    }

    public abstract RepositoryLookupFailureCallback getLookupFailureCallback();

    public final void setSourcePath(List<String> sourcePath) {
        this.getSourceFinder().setSourceBaseList(sourcePath);
    }

    public abstract SourceFinder getSourceFinder();

    @Deprecated
    public abstract Subtypes getSubtypes();

    public abstract void clearRepository();

    public abstract void clearClassContextCache();

    public abstract void addClasspathEntry(String var1) throws IOException;

    public abstract void addApplicationClassToRepository(JavaClass var1);

    public boolean isApplicationClass(JavaClass cls) {
        return this.getSubtypes().isApplicationClass(cls);
    }

    public boolean isApplicationClass(@DottedClassName String className) {
        try {
            JavaClass javaClass = this.lookupClass(className);
            return this.isApplicationClass(javaClass);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    public boolean isApplicationClass(ClassDescriptor desc) {
        return this.getSubtypes2().isApplicationClass(desc);
    }

    public boolean isTooBig(ClassDescriptor desc) {
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        try {
            ClassContext classContext = analysisCache.getClassAnalysis(ClassContext.class, desc);
            ClassData classData = analysisCache.getClassAnalysis(ClassData.class, desc);
            JavaClass javaClass = classContext.getJavaClass();
            if (classData.getData().length > 1000000 && javaClass.getMethods().length > 1000) {
                return true;
            }
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Could not get class context", e);
        }
        return false;
    }

    public abstract JavaClass lookupClass(@DottedClassName @NonNull String var1) throws ClassNotFoundException;

    public JavaClass lookupClass(@NonNull ClassDescriptor classDescriptor) throws ClassNotFoundException {
        return this.lookupClass(classDescriptor.toDottedClassName());
    }

    public static JavaClass lookupSystemClass(@NonNull String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (originalRepository == null) {
            throw new IllegalStateException("originalRepository is null");
        }
        JavaClass clazz = originalRepository.findClass(className);
        return clazz == null ? originalRepository.loadClass(className) : clazz;
    }

    public final String lookupSourceFile(@DottedClassName @NonNull String dottedClassName) {
        if (dottedClassName == null) {
            throw new IllegalArgumentException("className is null");
        }
        try {
            XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, DescriptorFactory.createClassDescriptorFromDottedClassName(dottedClassName));
            String name = xClass.getSource();
            if (name == null) {
                return "<Unknown>";
            }
            return name;
        }
        catch (CheckedAnalysisException e) {
            return "<Unknown>";
        }
    }

    public abstract ClassContext getClassContext(JavaClass var1);

    public abstract String getClassContextStats();

    public final void loadInterproceduralDatabases() {
        this.loadPropertyDatabase(this.getFieldStoreTypeDatabase(), "fieldStoreTypes.db", "field store type database");
        this.loadPropertyDatabase(this.getUnconditionalDerefParamDatabase(), UNCONDITIONAL_DEREF_DB_FILENAME, "unconditional param deref database");
        this.loadPropertyDatabase(this.getReturnValueNullnessPropertyDatabase(), NONNULL_RETURN_DB_FILENAME, "nonnull return db database");
    }

    public final void loadDefaultInterproceduralDatabases() {
        if (IGNORE_BUILTIN_MODELS) {
            return;
        }
        this.loadPropertyDatabaseFromResource(this.getUnconditionalDerefParamDatabase(), UNCONDITIONAL_DEREF_DB_RESOURCE, "unconditional param deref database");
        this.loadPropertyDatabaseFromResource(this.getReturnValueNullnessPropertyDatabase(), NONNULL_RETURN_DB_RESOURCE, "nonnull return db database");
    }

    public final void setBoolProperty(int prop, boolean value) {
        this.boolPropertySet.set(prop, value);
    }

    public final boolean getBoolProperty(int prop) {
        return this.boolPropertySet.get(prop);
    }

    public abstract SourceInfoMap getSourceInfoMap();

    public final void setDatabaseInputDir(String databaseInputDir) {
        if (DEBUG) {
            System.out.println("Setting database input directory: " + databaseInputDir);
        }
        this.databaseInputDir = databaseInputDir;
    }

    public final String getDatabaseInputDir() {
        return this.databaseInputDir;
    }

    public final void setDatabaseOutputDir(String databaseOutputDir) {
        if (DEBUG) {
            System.out.println("Setting database output directory: " + databaseOutputDir);
        }
        this.databaseOutputDir = databaseOutputDir;
    }

    public final String getDatabaseOutputDir() {
        return this.databaseOutputDir;
    }

    public abstract FieldStoreTypeDatabase getFieldStoreTypeDatabase();

    public abstract ParameterNullnessPropertyDatabase getUnconditionalDerefParamDatabase();

    public abstract ReturnValueNullnessPropertyDatabase getReturnValueNullnessPropertyDatabase();

    public <DatabaseType extends PropertyDatabase<KeyType, Property>, KeyType extends FieldOrMethodDescriptor, Property> DatabaseType loadPropertyDatabase(DatabaseType database, String fileName, String description) {
        try {
            File dbFile = new File(this.getDatabaseInputDir(), fileName);
            if (DEBUG) {
                System.out.println("Loading " + description + " from " + dbFile.getPath() + "...");
            }
            database.readFromFile(dbFile.getPath());
            return database;
        }
        catch (IOException e) {
            this.getLookupFailureCallback().logError("Error loading " + description, e);
        }
        catch (PropertyDatabaseFormatException e) {
            this.getLookupFailureCallback().logError("Invalid " + description, e);
        }
        return null;
    }

    public <DatabaseType extends PropertyDatabase<KeyType, Property>, KeyType extends FieldOrMethodDescriptor, Property> DatabaseType loadPropertyDatabaseFromResource(DatabaseType database, String resourceName, String description) {
        try {
            if (DEBUG) {
                System.out.println("Loading default " + description + " from " + resourceName + " @ " + PropertyDatabase.class.getResource(resourceName) + " ... ");
            }
            InputStream in = PropertyDatabase.class.getResourceAsStream(resourceName);
            database.read(in);
            in.close();
            return database;
        }
        catch (IOException e) {
            this.getLookupFailureCallback().logError("Error loading " + description, e);
        }
        catch (PropertyDatabaseFormatException e) {
            this.getLookupFailureCallback().logError("Invalid " + description, e);
        }
        return null;
    }

    public <DatabaseType extends PropertyDatabase<KeyType, Property>, KeyType extends FieldOrMethodDescriptor, Property> void storePropertyDatabase(DatabaseType database, String fileName, String description) {
        try {
            File dbFile = new File(this.getDatabaseOutputDir(), fileName);
            if (DEBUG) {
                System.out.println("Writing " + description + " to " + dbFile.getPath() + "...");
            }
            database.writeToFile(dbFile.getPath());
        }
        catch (IOException e) {
            this.getLookupFailureCallback().logError("Error writing " + description, e);
        }
    }

    public abstract InnerClassAccessMap getInnerClassAccessMap();

    public static void setCurrentAnalysisContext(AnalysisContext analysisContext) {
        currentAnalysisContext.set(analysisContext);
        currentXFactory.set(new XFactory());
    }

    public static void removeCurrentAnalysisContext() {
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        if (context != null) {
            context.clear();
        }
        currentAnalysisContext.remove();
    }

    public abstract Subtypes2 getSubtypes2();

    public Collection<XClass> getXClassCollection() {
        return this.getSubtypes2().getXClassCollection();
    }
}

