/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSummary {
    private Set<XField> writtenOutsideOfConstructor = new HashSet<XField>();
    private Map<XField, OpcodeStack.Item> summary = new HashMap<XField, OpcodeStack.Item>();
    private Map<XMethod, Set<XField>> fieldsWritten = new HashMap<XMethod, Set<XField>>();
    private boolean complete = false;

    public OpcodeStack.Item getSummary(XField field) {
        OpcodeStack.Item result = this.summary.get(field);
        if (result == null) {
            return new OpcodeStack.Item();
        }
        return result;
    }

    public void setFieldsWritten(XMethod method, Collection<XField> fields) {
        if (fields.isEmpty()) {
            return;
        }
        if (fields.size() == 1) {
            this.fieldsWritten.put(method, Collections.singleton(fields.iterator().next()));
            return;
        }
        this.fieldsWritten.put(method, new HashSet<XField>(fields));
    }

    public Set<XField> getFieldsWritten(XMethod method) {
        Set<XField> result = this.fieldsWritten.get(method);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public boolean isWrittenOutsideOfConstructor(XField field) {
        if (field.isFinal()) {
            return false;
        }
        boolean result = this.writtenOutsideOfConstructor.contains(field);
        return result;
    }

    public boolean addWrittenOutsideOfConstructor(XField field) {
        return this.writtenOutsideOfConstructor.add(field);
    }

    public void mergeSummary(XField fieldOperand, OpcodeStack.Item mergeValue) {
        OpcodeStack.Item oldSummary = this.summary.get(fieldOperand);
        if (oldSummary != null) {
            OpcodeStack.Item newValue = OpcodeStack.Item.merge(mergeValue, oldSummary);
            this.summary.put(fieldOperand, newValue);
        } else {
            this.summary.put(fieldOperand, mergeValue);
        }
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

