/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethodChooser;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hierarchy2 {
    public static final ClassDescriptor ObjectDescriptor = DescriptorFactory.createClassDescriptor("java/lang/Object");

    public static XMethod findExactMethod(InvokeInstruction inv, ConstantPoolGen cpg, JavaClassAndMethodChooser chooser) throws ClassNotFoundException {
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String methodSig = inv.getSignature(cpg);
        XMethod result = Hierarchy2.findMethod(DescriptorFactory.createClassDescriptorFromDottedClassName(className), methodName, methodSig, inv instanceof INVOKESTATIC);
        return Hierarchy2.thisOrNothing(result, chooser);
    }

    @CheckForNull
    private static XMethod thisOrNothing(@CheckForNull XMethod m, JavaClassAndMethodChooser chooser) {
        if (m == null) {
            return null;
        }
        if (chooser.choose(m)) {
            return m;
        }
        return null;
    }

    @CheckForNull
    public static XMethod findInvocationLeastUpperBound(InvokeInstruction inv, ConstantPoolGen cpg, JavaClassAndMethodChooser methodChooser) throws ClassNotFoundException {
        short opcode;
        if (Hierarchy.DEBUG_METHOD_LOOKUP) {
            System.out.println("Find prototype method for " + SignatureConverter.convertMethodSignature(inv, cpg));
        }
        if ((opcode = inv.getOpcode()) == 184 ? methodChooser == Hierarchy.INSTANCE_METHOD : methodChooser == Hierarchy.STATIC_METHOD) {
            return null;
        }
        if (opcode == 183) {
            return Hierarchy2.findExactMethod(inv, cpg, methodChooser);
        }
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String methodSig = inv.getSignature(cpg);
        if (Hierarchy.DEBUG_METHOD_LOOKUP) {
            System.out.println("[Class name is " + className + "]");
            System.out.println("[Method name is " + methodName + "]");
            System.out.println("[Method signature is " + methodSig + "]");
        }
        if (className.startsWith("[")) {
            className = "java.lang.Object";
        }
        try {
            return Hierarchy2.thisOrNothing(Hierarchy2.findInvocationLeastUpperBound(Hierarchy2.getXClassFromDottedClassName(className), methodName, methodSig, opcode == 184, opcode == 185), methodChooser);
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    @CheckForNull
    public static XMethod findInvocationLeastUpperBound(ClassDescriptor classDesc, String methodName, String methodSig, boolean invokeStatic, boolean invokeInterface) {
        try {
            return Hierarchy2.findInvocationLeastUpperBound(Hierarchy2.getXClass(classDesc), methodName, methodSig, invokeStatic, invokeInterface);
        }
        catch (Exception e) {
            return null;
        }
    }

    @CheckForNull
    public static XMethod findInvocationLeastUpperBound(XClass jClass, String methodName, String methodSig, boolean invokeStatic, boolean invokeInterface) throws ClassNotFoundException {
        XMethod result = Hierarchy2.findMethod(jClass.getClassDescriptor(), methodName, methodSig, invokeStatic);
        if (result != null) {
            return result;
        }
        if (invokeInterface) {
            for (ClassDescriptor i : jClass.getInterfaceDescriptorList()) {
                result = Hierarchy2.findInvocationLeastUpperBound(i, methodName, methodSig, invokeStatic, invokeInterface);
                if (result == null) continue;
                return null;
            }
        } else {
            ClassDescriptor sClass = jClass.getSuperclassDescriptor();
            if (sClass != null) {
                return Hierarchy2.findInvocationLeastUpperBound(sClass, methodName, methodSig, invokeStatic, invokeInterface);
            }
        }
        return null;
    }

    @CheckForNull
    public static XMethod findMethod(ClassDescriptor classDescriptor, String methodName, String methodSig, boolean isStatic) {
        try {
            return Hierarchy2.getXClass(classDescriptor).findMethod(methodName, methodSig, isStatic);
        }
        catch (CheckedAnalysisException e) {
            return null;
        }
    }

    static XClass getXClass(@SlashedClassName String c) throws CheckedAnalysisException {
        return Hierarchy2.getXClass(DescriptorFactory.createClassDescriptor(c));
    }

    static XClass getXClassFromDottedClassName(@DottedClassName String c) throws CheckedAnalysisException {
        return Hierarchy2.getXClass(DescriptorFactory.createClassDescriptorFromDottedClassName(c));
    }

    static XClass getXClass(ClassDescriptor c) throws CheckedAnalysisException {
        return Global.getAnalysisCache().getClassAnalysis(XClass.class, c);
    }

    @NonNull
    public static Set<XMethod> resolveMethodCallTargets(InvokeInstruction invokeInstruction, TypeFrame typeFrame, ConstantPoolGen cpg) throws DataflowAnalysisException, ClassNotFoundException {
        boolean receiverTypeIsExact;
        Type receiverType;
        short opcode = invokeInstruction.getOpcode();
        if (opcode == 184) {
            return Util.emptyOrNonnullSingleton(Hierarchy2.findInvocationLeastUpperBound(invokeInstruction, cpg, Hierarchy.STATIC_METHOD));
        }
        if (!typeFrame.isValid()) {
            return Collections.emptySet();
        }
        if (opcode == 183) {
            receiverType = ObjectTypeFactory.getInstance(invokeInstruction.getClassName(cpg));
            receiverTypeIsExact = false;
        } else {
            int instanceStackLocation = typeFrame.getInstanceStackLocation(invokeInstruction, cpg);
            receiverType = (Type)typeFrame.getStackValue(instanceStackLocation);
            if (!(receiverType instanceof ReferenceType)) {
                return Collections.emptySet();
            }
            receiverTypeIsExact = typeFrame.isExact(instanceStackLocation);
        }
        if (Hierarchy.DEBUG_METHOD_LOOKUP) {
            System.out.println("[receiver type is " + receiverType + ", " + (receiverTypeIsExact ? "exact]" : " not exact]"));
        }
        return Hierarchy2.resolveMethodCallTargets(receiverType, invokeInstruction, cpg, receiverTypeIsExact);
    }

    public static Set<XMethod> resolveMethodCallTargets(ReferenceType receiverType, InvokeInstruction invokeInstruction, ConstantPoolGen cpg) throws ClassNotFoundException {
        return Hierarchy2.resolveMethodCallTargets(receiverType, invokeInstruction, cpg, false);
    }

    public static Set<XMethod> resolveMethodCallTargets(ReferenceType receiverType, InvokeInstruction invokeInstruction, ConstantPoolGen cpg, boolean receiverTypeIsExact) throws ClassNotFoundException {
        boolean virtualCall;
        XClass xClass;
        HashSet<XMethod> result = new HashSet<XMethod>();
        if (invokeInstruction.getOpcode() == 184) {
            throw new IllegalArgumentException();
        }
        String methodName = invokeInstruction.getName(cpg);
        String methodSig = invokeInstruction.getSignature(cpg);
        if (receiverType instanceof ArrayType) {
            try {
                return Util.emptyOrNonnullSingleton(Hierarchy2.getXClass(ObjectDescriptor).findMethod(methodName, methodSig, false));
            }
            catch (CheckedAnalysisException e) {
                return Collections.emptySet();
            }
        }
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        String receiverClassName = ((ObjectType)receiverType).getClassName();
        ClassDescriptor receiverDesc = DescriptorFactory.createClassDescriptorFromDottedClassName(receiverClassName);
        try {
            xClass = Hierarchy2.getXClass(receiverDesc);
        }
        catch (CheckedAnalysisException e) {
            return Collections.emptySet();
        }
        XMethod upperBound = Hierarchy2.findMethod(receiverDesc, methodName, methodSig, false);
        if (upperBound == null) {
            upperBound = Hierarchy2.findInvocationLeastUpperBound(xClass, methodName, methodSig, false, false);
        }
        if (upperBound != null) {
            if (Hierarchy.DEBUG_METHOD_LOOKUP) {
                System.out.println("Adding upper bound: " + upperBound);
            }
            result.add(upperBound);
        }
        boolean bl = virtualCall = !(invokeInstruction.getOpcode() != 182 && invokeInstruction.getOpcode() != 185 || upperBound != null && upperBound.isFinal() || receiverTypeIsExact);
        if (virtualCall && !receiverClassName.equals("java.lang.Object")) {
            Set<ClassDescriptor> subTypeSet = analysisContext.getSubtypes2().getSubtypes(receiverDesc);
            for (ClassDescriptor subtype : subTypeSet) {
                XMethod concreteSubtypeMethod = Hierarchy2.findMethod(subtype, methodName, methodSig, false);
                if (concreteSubtypeMethod == null || (concreteSubtypeMethod.getAccessFlags() & 0x400) != 0) continue;
                result.add(concreteSubtypeMethod);
            }
        }
        return result;
    }

    @CheckForNull
    public static ObjectType[] findDeclaredExceptions(InvokeInstruction inv, ConstantPoolGen cpg) throws ClassNotFoundException {
        XMethod method = Hierarchy2.findInvocationLeastUpperBound(inv, cpg, inv instanceof INVOKESTATIC ? Hierarchy.STATIC_METHOD : Hierarchy.INSTANCE_METHOD);
        if (method == null) {
            return null;
        }
        String[] exceptions = method.getThrownExceptions();
        if (exceptions == null) {
            return new ObjectType[0];
        }
        ObjectType[] result = new ObjectType[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            result[i] = ObjectTypeFactory.getInstance(ClassName.toDottedClassName(exceptions[i]));
        }
        return result;
    }
}

