/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import java.util.Set;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncompatibleTypes {
    final int priority;
    final String msg;
    public static final IncompatibleTypes SEEMS_OK = new IncompatibleTypes("Seems OK", 5);
    public static final IncompatibleTypes ARRAY_AND_NON_ARRAY = new IncompatibleTypes("Array and non array", 1);
    public static final IncompatibleTypes ARRAY_AND_OBJECT = new IncompatibleTypes("Array and Object", 3);
    public static final IncompatibleTypes INCOMPATIBLE_CLASSES = new IncompatibleTypes("Incompatible classes", 1);
    public static final IncompatibleTypes UNRELATED_CLASS_AND_INTERFACE = new IncompatibleTypes("Unrelated class and interface", 2);
    public static final IncompatibleTypes UNRELATED_FINAL_CLASS_AND_INTERFACE = new IncompatibleTypes("Unrelated final class and interface", 1);
    public static final IncompatibleTypes UNRELATED_INTERFACES = new IncompatibleTypes("Unrelated interfaces", 2);

    private IncompatibleTypes(String msg, int priority) {
        this.msg = msg;
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getMsg() {
        return this.msg;
    }

    public String toString() {
        return this.msg;
    }

    @NonNull
    public static IncompatibleTypes getPriorityForAssumingCompatible(Type lhsType, Type rhsType) {
        return IncompatibleTypes.getPriorityForAssumingCompatible(lhsType, rhsType, false);
    }

    @NonNull
    public static IncompatibleTypes getPriorityForAssumingCompatible(Type lhsType, Type rhsType, boolean pointerEquality) {
        if (!(lhsType instanceof ReferenceType)) {
            return SEEMS_OK;
        }
        if (!(rhsType instanceof ReferenceType)) {
            return SEEMS_OK;
        }
        while (lhsType instanceof ArrayType && rhsType instanceof ArrayType) {
            lhsType = ((ArrayType)lhsType).getElementType();
            rhsType = ((ArrayType)rhsType).getElementType();
        }
        if (lhsType instanceof ArrayType) {
            if (rhsType.equals(ObjectType.OBJECT)) {
                return ARRAY_AND_OBJECT;
            }
            return ARRAY_AND_NON_ARRAY;
        }
        if (rhsType instanceof ArrayType) {
            if (lhsType.equals(ObjectType.OBJECT)) {
                return ARRAY_AND_OBJECT;
            }
            return ARRAY_AND_NON_ARRAY;
        }
        if (lhsType.equals(rhsType)) {
            return SEEMS_OK;
        }
        if (!(lhsType instanceof ObjectType) || !(rhsType instanceof ObjectType)) {
            return SEEMS_OK;
        }
        return IncompatibleTypes.getPriorityForAssumingCompatible((ObjectType)lhsType, (ObjectType)rhsType, pointerEquality);
    }

    @NonNull
    static XMethod getInvokedMethod(XClass xClass, String name, String sig, boolean isStatic) throws CheckedAnalysisException {
        IAnalysisCache cache = Global.getAnalysisCache();
        XMethod result;
        while ((result = xClass.findMethod(name, sig, isStatic)) == null) {
            if (isStatic) {
                throw new CheckedAnalysisException();
            }
            ClassDescriptor superclassDescriptor = xClass.getSuperclassDescriptor();
            if (superclassDescriptor == null) {
                throw new CheckedAnalysisException();
            }
            xClass = cache.getClassAnalysis(XClass.class, superclassDescriptor);
        }
        return result;
    }

    @NonNull
    public static IncompatibleTypes getPriorityForAssumingCompatible(ObjectType lhsType, ObjectType rhsType, boolean pointerEquality) {
        if (lhsType.equals(rhsType)) {
            return SEEMS_OK;
        }
        try {
            ClassDescriptor lhsDescriptor = DescriptorFactory.createClassDescriptorFromDottedClassName(lhsType.getClassName());
            ClassDescriptor rhsDescriptor = DescriptorFactory.createClassDescriptorFromDottedClassName(rhsType.getClassName());
            IAnalysisCache cache = Global.getAnalysisCache();
            XClass lhs = cache.getClassAnalysis(XClass.class, lhsDescriptor);
            XClass rhs = cache.getClassAnalysis(XClass.class, rhsDescriptor);
            if (!Hierarchy.isSubtype(lhsType, rhsType) && !Hierarchy.isSubtype(rhsType, lhsType)) {
                AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
                XMethod lhsEquals = IncompatibleTypes.getInvokedMethod(lhs, "equals", "(Ljava/lang/Object;)Z", false);
                XMethod rhsEquals = IncompatibleTypes.getInvokedMethod(rhs, "equals", "(Ljava/lang/Object;)Z", false);
                String lhsClassName = lhsEquals.getClassName();
                if (lhsEquals.equals(rhsEquals)) {
                    if (lhsClassName.equals("java.lang.Enum")) {
                        return INCOMPATIBLE_CLASSES;
                    }
                    if (!pointerEquality && !lhsClassName.equals("java.lang.Object")) {
                        return SEEMS_OK;
                    }
                }
                if (!lhs.isInterface() && !rhs.isInterface()) {
                    return INCOMPATIBLE_CLASSES;
                }
                Set<ClassDescriptor> commonSubtypes = analysisContext.getSubtypes2().getTransitiveCommonSubtypes(lhsDescriptor, rhsDescriptor);
                if (!IncompatibleTypes.containsAtLeastOneInstantiableClass(commonSubtypes)) {
                    if (lhs.isInterface() && rhs.isInterface()) {
                        return UNRELATED_INTERFACES;
                    }
                    if (lhs.isFinal() || rhs.isFinal()) {
                        return UNRELATED_FINAL_CLASS_AND_INTERFACE;
                    }
                    return UNRELATED_CLASS_AND_INTERFACE;
                }
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        catch (MissingClassException e) {
            AnalysisContext.reportMissingClass(e.getClassNotFoundException());
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error checking for incompatible types", e);
        }
        return SEEMS_OK;
    }

    private static boolean containsAtLeastOneInstantiableClass(Set<ClassDescriptor> commonSubtypes) throws CheckedAnalysisException {
        IAnalysisCache cache = Global.getAnalysisCache();
        for (ClassDescriptor classDescriptor : commonSubtypes) {
            XClass xclass = cache.getClassAnalysis(XClass.class, classDescriptor);
            if (xclass.isInterface() || xclass.isAbstract()) continue;
            return true;
        }
        return false;
    }
}

