/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.FindBugs;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.ObjectType;

public class ObjectTypeFactory {
    private static ThreadLocal<Map<String, ObjectType>> instance = new ThreadLocal<Map<String, ObjectType>>(){

        @Override
        protected Map<String, ObjectType> initialValue() {
            return new HashMap<String, ObjectType>();
        }
    };

    public static void clearInstance() {
        instance.remove();
    }

    public static ObjectType getInstance(String s) {
        Map<String, ObjectType> map;
        ObjectType result;
        if (FindBugs.DEBUG && s.startsWith("[")) {
            throw new IllegalArgumentException("Cannot create an ObjectType to represent an array type: " + s);
        }
        if (s.indexOf("/") >= 0) {
            s = s.replace('/', '.');
        }
        if ((result = (map = instance.get()).get(s)) != null) {
            return result;
        }
        result = new ObjectType(s);
        map.put(s, result);
        return result;
    }
}

