/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AbstractDominatorsAnalysis;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.EdgeChooser;
import edu.umd.cs.findbugs.ba.ReverseDFSOrder;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import java.util.BitSet;
import org.apache.bcel.classfile.Method;

public class PostDominatorsAnalysis
extends AbstractDominatorsAnalysis {
    private final ReverseDepthFirstSearch rdfs;
    private final DepthFirstSearch dfs;

    protected PostDominatorsAnalysis(CFG cfg, ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs, EdgeChooser edgeChooser) {
        super(cfg, edgeChooser);
        this.rdfs = rdfs;
        this.dfs = dfs;
    }

    protected PostDominatorsAnalysis(CFG cfg, ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs, boolean ignoreExceptionEdges) {
        super(cfg, ignoreExceptionEdges);
        this.rdfs = rdfs;
        this.dfs = dfs;
    }

    public boolean isForwards() {
        return false;
    }

    public BlockOrder getBlockOrder(CFG cfg) {
        return new ReverseDFSOrder(cfg, this.rdfs, this.dfs);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: " + PostDominatorsAnalysis.class.getName() + " <classfile>");
            System.exit(1);
        }
        DataflowTestDriver<BitSet, PostDominatorsAnalysis> driver = new DataflowTestDriver<BitSet, PostDominatorsAnalysis>(){

            @Override
            public Dataflow<BitSet, PostDominatorsAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                CFG cfg = classContext.getCFG(method);
                ReverseDepthFirstSearch rdfs = classContext.getReverseDepthFirstSearch(method);
                PostDominatorsAnalysis analysis = new PostDominatorsAnalysis(cfg, rdfs, classContext.getDepthFirstSearch(method), SystemProperties.getBoolean("dominators.ignoreexceptionedges"));
                Dataflow<BitSet, PostDominatorsAnalysis> dataflow = new Dataflow<BitSet, PostDominatorsAnalysis>(cfg, analysis);
                dataflow.execute();
                return dataflow;
            }
        };
        driver.execute(args[0]);
    }
}

