/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DebugRepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysis;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import java.io.IOException;
import java.util.Iterator;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceValueAnalysisTestDriver<Resource, ResourceTrackerType extends ResourceTracker<Resource>> {
    public abstract ResourceTrackerType createResourceTracker(ClassContext var1, Method var2) throws CFGBuilderException, DataflowAnalysisException;

    public void execute(String classFile, String methodName, int offset) throws IOException, CFGBuilderException, DataflowAnalysisException {
        Method[] methodList;
        DebugRepositoryLookupFailureCallback lookupFailureCallback = new DebugRepositoryLookupFailureCallback();
        AnalysisContext analysisContext = AnalysisContext.create(lookupFailureCallback);
        JavaClass jclass = new ClassParser(classFile).parse();
        ClassContext classContext = analysisContext.getClassContext(jclass);
        for (Method method : methodList = jclass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            CFG cfg = classContext.getCFG(method);
            BasicBlock creationBlock = null;
            InstructionHandle creationInstruction = null;
            Iterator<BasicBlock> ii = cfg.blockIterator();
            block1: while (ii.hasNext()) {
                BasicBlock basicBlock = ii.next();
                BasicBlock.InstructionIterator j = basicBlock.instructionIterator();
                while (j.hasNext()) {
                    InstructionHandle handle = (InstructionHandle)j.next();
                    if (handle.getPosition() != offset) continue;
                    creationBlock = basicBlock;
                    creationInstruction = handle;
                    break block1;
                }
            }
            if (creationInstruction == null || creationBlock == null) {
                throw new IllegalArgumentException("No bytecode with offset " + offset);
            }
            ResourceTrackerType resourceTracker = this.createResourceTracker(classContext, method);
            Object resource = resourceTracker.isResourceCreation(creationBlock, creationInstruction, classContext.getConstantPoolGen());
            if (resource == null) {
                throw new IllegalArgumentException("offset " + offset + " is not a resource creation");
            }
            DataflowTestDriver driver = new DataflowTestDriver<ResourceValueFrame, ResourceValueAnalysis<Resource>>((ResourceTracker)resourceTracker, resource){
                final /* synthetic */ ResourceTracker val$resourceTracker;
                final /* synthetic */ Object val$resource;
                {
                    this.val$resourceTracker = resourceTracker;
                    this.val$resource = object;
                }

                @Override
                @CheckForNull
                public Dataflow<ResourceValueFrame, ResourceValueAnalysis<Resource>> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                    MethodGen methodGen = classContext.getMethodGen(method);
                    if (methodGen == null) {
                        return null;
                    }
                    CFG cfg = classContext.getCFG(method);
                    DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
                    ResourceValueAnalysis<Object> analysis = new ResourceValueAnalysis<Object>(methodGen, cfg, dfs, this.val$resourceTracker, this.val$resource);
                    Dataflow dataflow = new Dataflow(cfg, analysis);
                    dataflow.execute();
                    return dataflow;
                }
            };
            driver.execute(classContext, method);
            break;
        }
    }
}

