/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class SourceInfoMap {
    private static final boolean DEBUG = SystemProperties.getBoolean("sourceinfo.debug");
    private Map<FieldDescriptor, SourceLineRange> fieldLineMap = new HashMap<FieldDescriptor, SourceLineRange>();
    private Map<MethodDescriptor, SourceLineRange> methodLineMap = new HashMap<MethodDescriptor, SourceLineRange>();
    private Map<String, SourceLineRange> classLineMap = new HashMap<String, SourceLineRange>();
    private static final Pattern DIGITS = Pattern.compile("^[0-9]+$");

    public boolean fallBackToClassfile() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.fieldLineMap.isEmpty() && this.methodLineMap.isEmpty() && this.classLineMap.isEmpty();
    }

    public void addFieldLine(String className, String fieldName, SourceLineRange range) {
        this.fieldLineMap.put(new FieldDescriptor(className, fieldName), range);
    }

    public void addMethodLine(String className, String methodName, String methodSignature, SourceLineRange range) {
        this.methodLineMap.put(new MethodDescriptor(className, methodName, methodSignature), range);
    }

    public void addClassLine(String className, SourceLineRange range) {
        this.classLineMap.put(className, range);
    }

    @CheckForNull
    public SourceLineRange getFieldLine(String className, String fieldName) {
        return this.fieldLineMap.get(new FieldDescriptor(className, fieldName));
    }

    @CheckForNull
    public SourceLineRange getMethodLine(String className, String methodName, String methodSignature) {
        return this.methodLineMap.get(new MethodDescriptor(className, methodName, methodSignature));
    }

    @CheckForNull
    public SourceLineRange getClassLine(String className) {
        return this.classLineMap.get(className);
    }

    public void read(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(Util.getReader(inputStream));
        int lineNumber = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (++lineNumber == 1) {
                    String version;
                    if (DEBUG) {
                        System.out.println("First line: " + line);
                    }
                    if ((version = SourceInfoMap.parseVersionNumber(line)) != null) {
                        if (version.equals("1.0")) continue;
                        throw new IOException("Unsupported sourceInfo version " + version);
                    }
                }
                StringTokenizer tokenizer = new StringTokenizer(line, ",");
                String className = tokenizer.nextToken();
                String next = tokenizer.nextToken();
                if (DIGITS.matcher(next).matches()) {
                    SourceLineRange range = SourceInfoMap.createRange(next, tokenizer.nextToken());
                    this.classLineMap.put(className, range);
                    if (!DEBUG) continue;
                    System.out.println("class:" + className + "," + range);
                    continue;
                }
                int lparen = next.indexOf(40);
                if (lparen >= 0) {
                    String methodName = next.substring(0, lparen);
                    String methodSignature = next.substring(lparen);
                    if (methodName.equals("init^")) {
                        methodName = "<init>";
                    } else if (methodName.equals("clinit^")) {
                        methodName = "<clinit>";
                    }
                    SourceLineRange range = SourceInfoMap.createRange(tokenizer.nextToken(), tokenizer.nextToken());
                    this.methodLineMap.put(new MethodDescriptor(className, methodName, methodSignature), range);
                    if (!DEBUG) continue;
                    System.out.println("method:" + methodName + methodSignature + "," + range);
                    continue;
                }
                String fieldName = next;
                SourceLineRange range = SourceInfoMap.createRange(tokenizer.nextToken(), tokenizer.nextToken());
                this.fieldLineMap.put(new FieldDescriptor(className, fieldName), range);
                if (!DEBUG) continue;
                System.out.println("field:" + className + "," + fieldName + "," + range);
            }
        }
        catch (NoSuchElementException e) {
            IOException ioe = new IOException("Invalid syntax in source info file at line " + lineNumber);
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    private static String parseVersionNumber(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " \t");
        if (!(SourceInfoMap.expect(tokenizer, "sourceInfo") && SourceInfoMap.expect(tokenizer, "version") && tokenizer.hasMoreTokens())) {
            return null;
        }
        return tokenizer.nextToken();
    }

    private static boolean expect(StringTokenizer tokenizer, String token) {
        if (!tokenizer.hasMoreTokens()) {
            return false;
        }
        String s = tokenizer.nextToken();
        if (DEBUG) {
            System.out.println("token=" + s);
        }
        return s.equals(token);
    }

    private static SourceLineRange createRange(String start, String end) {
        return new SourceLineRange(Integer.valueOf(start), Integer.valueOf(end));
    }

    public static class SourceLineRange {
        private final Integer start;
        private final Integer end;

        public SourceLineRange(@NonNull Integer line) {
            this.start = this.end = line;
        }

        public SourceLineRange(@NonNull Integer start, @NonNull Integer end) {
            this.start = start;
            this.end = end;
        }

        @NonNull
        public Integer getStart() {
            return this.start;
        }

        @NonNull
        public Integer getEnd() {
            return this.end;
        }

        public String toString() {
            return this.start + (this.start.equals(this.end) ? "" : "-" + this.end);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodDescriptor
    implements Comparable<MethodDescriptor> {
        private String className;
        private String methodName;
        private String methodSignature;

        public MethodDescriptor(String className, String methodName, String methodSignature) {
            this.className = className;
            this.methodName = methodName;
            this.methodSignature = methodSignature;
        }

        public String toString() {
            return this.className + "." + this.methodName + ":" + this.methodSignature;
        }

        @Override
        public int compareTo(MethodDescriptor o) {
            int cmp = this.className.compareTo(o.className);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.methodName.compareTo(o.methodName);
            if (cmp != 0) {
                return cmp;
            }
            return this.methodSignature.compareTo(o.methodSignature);
        }

        public int hashCode() {
            return 1277 * this.className.hashCode() + 37 * this.methodName.hashCode() + this.methodSignature.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MethodDescriptor other = (MethodDescriptor)obj;
            return this.className.equals(other.className) && this.methodName.equals(other.methodName) && this.methodSignature.equals(other.methodSignature);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldDescriptor
    implements Comparable<FieldDescriptor> {
        String className;
        String fieldName;

        public FieldDescriptor(String className, String fieldName) {
            this.className = className;
            this.fieldName = fieldName;
        }

        public String toString() {
            return this.className + "." + this.fieldName;
        }

        @Override
        public int compareTo(FieldDescriptor o) {
            int cmp = this.className.compareTo(o.className);
            if (cmp != 0) {
                return cmp;
            }
            return this.fieldName.compareTo(o.fieldName);
        }

        public int hashCode() {
            return 1277 * this.className.hashCode() + this.fieldName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FieldDescriptor other = (FieldDescriptor)obj;
            return this.className.equals(other.className) && this.fieldName.equals(other.fieldName);
        }
    }
}

