/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AbstractClassMember;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.FindBugsDefaultAnnotations;
import edu.umd.cs.findbugs.ba.jsr305.ParameterAnnotationAccumulator;
import edu.umd.cs.findbugs.ba.jsr305.ReturnTypeAnnotationAccumulator;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierResolver;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.EnumValue;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.meta.When;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeQualifierApplications {
    static final boolean DEBUG = SystemProperties.getBoolean("ctq.applications.debug");
    private static ThreadLocal<Data> instance = new ThreadLocal<Data>(){

        @Override
        protected Data initialValue() {
            return new Data();
        }
    };

    public static void clearInstance() {
        instance.remove();
    }

    private static Map<TypeQualifierValue, DualKeyHashMap<XMethod, Integer, TypeQualifierAnnotation>> getEffectiveParameterAnnotations() {
        return instance.get().effectiveParameterAnnotations;
    }

    private static Map<TypeQualifierValue, Map<AnnotatedObject, TypeQualifierAnnotation>> getEffectiveObjectAnnotations() {
        return instance.get().effectiveObjectAnnotations;
    }

    private static DualKeyHashMap<XMethod, Integer, Collection<AnnotationValue>> getDirectParameterAnnotations() {
        return instance.get().directParameterAnnotations;
    }

    private static Map<AnnotatedObject, Collection<AnnotationValue>> getDirectObjectAnnotations() {
        return instance.get().directObjectAnnotations;
    }

    private static Collection<AnnotationValue> getDirectAnnotation(AnnotatedObject m) {
        Collection<AnnotationValue> result = TypeQualifierApplications.getDirectObjectAnnotations().get(m);
        if (result != null) {
            return result;
        }
        if (m.getAnnotationDescriptors().isEmpty()) {
            return Collections.emptyList();
        }
        result = TypeQualifierResolver.resolveTypeQualifiers(m.getAnnotations());
        if (result.size() == 0) {
            result = Collections.emptyList();
        }
        TypeQualifierApplications.getDirectObjectAnnotations().put(m, result);
        return result;
    }

    private static Collection<AnnotationValue> getDirectAnnotation(XMethod m, int parameter) {
        Collection<AnnotationValue> result = TypeQualifierApplications.getDirectParameterAnnotations().get(m, parameter);
        if (result != null) {
            return result;
        }
        if (m.getParameterAnnotationDescriptors(parameter).isEmpty()) {
            return Collections.emptyList();
        }
        result = TypeQualifierResolver.resolveTypeQualifiers(m.getParameterAnnotations(parameter));
        if (result.size() == 0) {
            result = Collections.emptyList();
        }
        TypeQualifierApplications.getDirectParameterAnnotations().put(m, parameter, result);
        return result;
    }

    private static void getDirectApplications(Set<TypeQualifierAnnotation> result, XMethod o, int parameter) {
        Collection<AnnotationValue> values = TypeQualifierApplications.getDirectAnnotation(o, parameter);
        ElementType e = ElementType.PARAMETER;
        for (AnnotationValue v : values) {
            Object a = v.getValue("applyTo");
            if (a instanceof Object[]) {
                for (Object o2 : (Object[])a) {
                    if (!(o2 instanceof EnumValue)) continue;
                    EnumValue ev = (EnumValue)o2;
                    if (!ev.desc.getClassName().equals("java/lang/annotation/ElementType") || !e.toString().equals(ev.value)) continue;
                    TypeQualifierApplications.constructTypeQualifierAnnotation(result, v);
                }
                continue;
            }
            TypeQualifierApplications.constructTypeQualifierAnnotation(result, v);
        }
    }

    private static void getDirectApplications(Set<TypeQualifierAnnotation> result, AnnotatedObject o, ElementType e) {
        Collection<AnnotationValue> values = TypeQualifierApplications.getDirectAnnotation(o);
        for (AnnotationValue v : values) {
            Object a = v.getValue("applyTo");
            if (a instanceof Object[]) {
                for (Object o2 : (Object[])a) {
                    if (!(o2 instanceof EnumValue)) continue;
                    EnumValue ev = (EnumValue)o2;
                    if (!ev.desc.getClassName().equals("java/lang/annotation/ElementType") || !e.toString().equals(ev.value)) continue;
                    TypeQualifierApplications.constructTypeQualifierAnnotation(result, v);
                }
                continue;
            }
            if (!o.getElementType().equals((Object)e)) continue;
            TypeQualifierApplications.constructTypeQualifierAnnotation(result, v);
        }
    }

    public static TypeQualifierAnnotation constructTypeQualifierAnnotation(AnnotationValue v) {
        assert (v != null);
        EnumValue whenValue = (EnumValue)v.getValue("when");
        When when = whenValue == null ? When.ALWAYS : When.valueOf((String)whenValue.value);
        ClassDescriptor annotationClass = v.getAnnotationClass();
        TypeQualifierValue tqv = TypeQualifierValue.getValue(annotationClass, v.getValue("value"));
        TypeQualifierAnnotation tqa = TypeQualifierAnnotation.getValue(tqv, when);
        return tqa;
    }

    public static void constructTypeQualifierAnnotation(Set<TypeQualifierAnnotation> set, AnnotationValue v) {
        assert (set != null);
        TypeQualifierAnnotation tqa = TypeQualifierApplications.constructTypeQualifierAnnotation(v);
        set.add(tqa);
    }

    private static void getApplicableScopedApplications(Set<TypeQualifierAnnotation> result, AnnotatedObject o, ElementType e) {
        AnnotatedObject outer = o.getContainingScope();
        if (outer != null) {
            TypeQualifierApplications.getApplicableScopedApplications(result, outer, e);
        }
        TypeQualifierApplications.getDirectApplications(result, o, e);
    }

    private static Collection<TypeQualifierAnnotation> getApplicableScopedApplications(AnnotatedObject o, ElementType e) {
        HashSet<TypeQualifierAnnotation> result = new HashSet<TypeQualifierAnnotation>();
        TypeQualifierApplications.getApplicableScopedApplications(result, o, e);
        return result;
    }

    private static Collection<TypeQualifierAnnotation> getApplicableScopedApplications(XMethod o, int parameter) {
        HashSet<TypeQualifierAnnotation> result = new HashSet<TypeQualifierAnnotation>();
        ElementType e = ElementType.PARAMETER;
        TypeQualifierApplications.getApplicableScopedApplications(result, o, e);
        TypeQualifierApplications.getDirectApplications(result, o, parameter);
        return result;
    }

    public static Collection<TypeQualifierAnnotation> getApplicableApplications(AnnotatedObject o) {
        return TypeQualifierApplications.getApplicableScopedApplications(o, o.getElementType());
    }

    public static Collection<TypeQualifierAnnotation> getApplicableApplications(XMethod o, int parameter) {
        return TypeQualifierApplications.getApplicableScopedApplications(o, parameter);
    }

    @CheckForNull
    private static TypeQualifierAnnotation findMatchingTypeQualifierAnnotation(Collection<TypeQualifierAnnotation> typeQualifierAnnotations, TypeQualifierValue typeQualifierValue) {
        for (TypeQualifierAnnotation typeQualifierAnnotation : typeQualifierAnnotations) {
            if (!typeQualifierAnnotation.typeQualifier.equals(typeQualifierValue)) continue;
            return typeQualifierAnnotation;
        }
        return null;
    }

    @CheckForNull
    private static TypeQualifierAnnotation getFindBugsDefaultAnnotation(AnnotatedObject o, TypeQualifierValue typeQualifierValue, ElementType elementType) {
        Collection<AnnotationValue> values = TypeQualifierResolver.resolveTypeQualifierDefaults(o.getAnnotations(), elementType);
        TypeQualifierAnnotation tqa = TypeQualifierApplications.extractAnnotation(values, typeQualifierValue);
        if (tqa != null) {
            return tqa;
        }
        TypeQualifierAnnotation result = TypeQualifierApplications.checkFindBugsDefaultAnnotation(FindBugsDefaultAnnotations.DEFAULT_ANNOTATION, o, typeQualifierValue);
        if (result != null) {
            return result;
        }
        switch (elementType) {
            case FIELD: {
                result = TypeQualifierApplications.checkFindBugsDefaultAnnotation(FindBugsDefaultAnnotations.DEFAULT_ANNOTATION_FOR_FIELDS, o, typeQualifierValue);
                break;
            }
            case METHOD: {
                result = TypeQualifierApplications.checkFindBugsDefaultAnnotation(FindBugsDefaultAnnotations.DEFAULT_ANNOTATION_FOR_METHODS, o, typeQualifierValue);
                break;
            }
            case PARAMETER: {
                result = TypeQualifierApplications.checkFindBugsDefaultAnnotation(FindBugsDefaultAnnotations.DEFAULT_ANNOTATION_FOR_PARAMETERS, o, typeQualifierValue);
                break;
            }
        }
        return result;
    }

    @CheckForNull
    private static TypeQualifierAnnotation checkFindBugsDefaultAnnotation(ClassDescriptor defaultAnnotation, AnnotatedObject o, TypeQualifierValue typeQualifierValue) {
        AnnotationValue annotationValue;
        if (DEBUG) {
            System.out.println("Checking for " + defaultAnnotation + " containing " + typeQualifierValue + " on " + o);
        }
        if ((annotationValue = o.getAnnotation(defaultAnnotation)) == null) {
            if (DEBUG) {
                System.out.println("   ===> no " + defaultAnnotation);
            }
            return null;
        }
        Object value = annotationValue.getValue("value");
        if (value == null) {
            if (DEBUG) {
                System.out.println("   ===> value is null");
            }
            return null;
        }
        Object[] types = value instanceof Object[] ? (Object[])value : new Object[]{value};
        for (Object obj : types) {
            ClassDescriptor typeDesc;
            AnnotationValue annotation;
            Collection<AnnotationValue> resolvedTypeQualifiers;
            TypeQualifierAnnotation tqa;
            if (!(obj instanceof Type)) {
                if (!DEBUG) continue;
                System.out.println("Found a non-Type value in value array of " + defaultAnnotation.toString() + " annotation");
                continue;
            }
            Type type = (Type)obj;
            if (DEBUG) {
                System.out.println("  ===> checking " + type.getDescriptor());
            }
            if (type.getDescriptor().startsWith("[") || (tqa = TypeQualifierApplications.extractAnnotation(resolvedTypeQualifiers = TypeQualifierResolver.resolveTypeQualifiers(annotation = new AnnotationValue(typeDesc = DescriptorFactory.instance().getClassDescriptor(type.getInternalName()))), typeQualifierValue)) == null) continue;
            return tqa;
        }
        return null;
    }

    private static TypeQualifierAnnotation extractAnnotation(Collection<AnnotationValue> resolvedTypeQualifiers, TypeQualifierValue typeQualifierValue) {
        for (AnnotationValue typeQualifier : resolvedTypeQualifiers) {
            TypeQualifierAnnotation tqa = TypeQualifierApplications.constructTypeQualifierAnnotation(typeQualifier);
            if (!tqa.typeQualifier.equals(typeQualifierValue)) continue;
            if (DEBUG) {
                System.out.println("  ===> Found match " + tqa);
            }
            return tqa;
        }
        return null;
    }

    public static TypeQualifierAnnotation getEffectiveTypeQualifierAnnotation(AnnotatedObject o, TypeQualifierValue typeQualifierValue) {
        TypeQualifierAnnotation result;
        Map<AnnotatedObject, TypeQualifierAnnotation> map;
        if (DEBUG) {
            System.out.println("Looking up application of " + typeQualifierValue + " on " + o);
        }
        if ((map = TypeQualifierApplications.getEffectiveObjectAnnotations().get(typeQualifierValue)) == null) {
            map = new HashMap<AnnotatedObject, TypeQualifierAnnotation>();
            TypeQualifierApplications.getEffectiveObjectAnnotations().put(typeQualifierValue, map);
        }
        if (map.containsKey(o)) {
            result = map.get(o);
        } else {
            TypeQualifierAnnotation tqa = TypeQualifierApplications.getDirectTypeQualifierAnnotation(o, typeQualifierValue);
            if (tqa == null && o instanceof XMethod && !((XMethod)o).isStatic()) {
                tqa = TypeQualifierApplications.getInheritedTypeQualifierAnnotation((XMethod)o, typeQualifierValue);
            }
            if (tqa == null) {
                tqa = TypeQualifierApplications.getDefaultTypeQualifierAnnotation(o, typeQualifierValue);
            }
            result = tqa;
            map.put(o, result);
        }
        if (DEBUG) {
            System.out.println("  => Answer: " + result);
        }
        return result;
    }

    private static TypeQualifierAnnotation getDirectTypeQualifierAnnotation(AnnotatedObject o, TypeQualifierValue typeQualifierValue) {
        HashSet<TypeQualifierAnnotation> applications = new HashSet<TypeQualifierAnnotation>();
        TypeQualifierApplications.getDirectApplications(applications, o, o.getElementType());
        TypeQualifierAnnotation result = TypeQualifierApplications.findMatchingTypeQualifierAnnotation(applications, typeQualifierValue);
        return result;
    }

    private static TypeQualifierAnnotation getInheritedTypeQualifierAnnotation(XMethod o, TypeQualifierValue typeQualifierValue) {
        assert (!o.isStatic());
        ReturnTypeAnnotationAccumulator accumulator = new ReturnTypeAnnotationAccumulator(typeQualifierValue, o);
        try {
            AnalysisContext.currentAnalysisContext().getSubtypes2().traverseSupertypes(o.getClassDescriptor(), accumulator);
            return accumulator.getResult().getEffectiveTypeQualifierAnnotation();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e);
            return null;
        }
    }

    private static TypeQualifierAnnotation getDefaultTypeQualifierAnnotation(AnnotatedObject o, TypeQualifierValue typeQualifierValue) {
        if (o instanceof AbstractClassMember && (((AbstractClassMember)((Object)o)).getAccessFlags() & 0x1000) != 0) {
            return null;
        }
        TypeQualifierAnnotation result = null;
        ElementType elementType = o.getElementType();
        while (o.getContainingScope() != null) {
            o = o.getContainingScope();
            HashSet<TypeQualifierAnnotation> applications = new HashSet<TypeQualifierAnnotation>();
            TypeQualifierApplications.getDirectApplications(applications, o, elementType);
            result = TypeQualifierApplications.findMatchingTypeQualifierAnnotation(applications, typeQualifierValue);
            if (result == null && (result = TypeQualifierApplications.getFindBugsDefaultAnnotation(o, typeQualifierValue, elementType)) == null) continue;
            break;
        }
        return result;
    }

    @CheckForNull
    public static TypeQualifierAnnotation getEffectiveTypeQualifierAnnotation(XMethod xmethod, int parameter, TypeQualifierValue typeQualifierValue) {
        TypeQualifierAnnotation result;
        DualKeyHashMap<XMethod, Integer, TypeQualifierAnnotation> map;
        if (DEBUG) {
            System.out.println("Looking up application of " + typeQualifierValue + " on " + xmethod + " parameter " + parameter);
        }
        if ((map = TypeQualifierApplications.getEffectiveParameterAnnotations().get(typeQualifierValue)) == null) {
            map = new DualKeyHashMap();
            TypeQualifierApplications.getEffectiveParameterAnnotations().put(typeQualifierValue, map);
        }
        if (map.containsKey(xmethod, parameter)) {
            result = map.get(xmethod, parameter);
        } else {
            TypeQualifierAnnotation tqa = TypeQualifierApplications.getDirectTypeQualifierAnnotation(xmethod, parameter, typeQualifierValue);
            if (tqa == null && !xmethod.isStatic()) {
                tqa = TypeQualifierApplications.getInheritedTypeQualifierAnnotation(xmethod, parameter, typeQualifierValue);
            }
            if (tqa == null) {
                tqa = TypeQualifierApplications.getDefaultTypeQualifierAnnotation(xmethod, parameter, typeQualifierValue);
            }
            result = tqa;
            map.put(xmethod, parameter, result);
        }
        if (DEBUG) {
            System.out.println("  => Answer: " + result);
        }
        return result;
    }

    @CheckForNull
    private static TypeQualifierAnnotation getDirectTypeQualifierAnnotation(XMethod xmethod, int parameter, TypeQualifierValue typeQualifierValue) {
        HashSet<TypeQualifierAnnotation> applications = new HashSet<TypeQualifierAnnotation>();
        TypeQualifierApplications.getDirectApplications(applications, xmethod, parameter);
        return TypeQualifierApplications.findMatchingTypeQualifierAnnotation(applications, typeQualifierValue);
    }

    @CheckForNull
    private static TypeQualifierAnnotation getInheritedTypeQualifierAnnotation(XMethod xmethod, int parameter, TypeQualifierValue typeQualifierValue) {
        assert (!xmethod.isStatic());
        ParameterAnnotationAccumulator accumulator = new ParameterAnnotationAccumulator(typeQualifierValue, xmethod, parameter);
        try {
            AnalysisContext.currentAnalysisContext().getSubtypes2().traverseSupertypes(xmethod.getClassDescriptor(), accumulator);
            return accumulator.getResult().getEffectiveTypeQualifierAnnotation();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e);
            return null;
        }
    }

    @CheckForNull
    private static TypeQualifierAnnotation getDefaultTypeQualifierAnnotation(XMethod xmethod, int parameter, TypeQualifierValue typeQualifierValue) {
        if ((xmethod.getAccessFlags() & 0x1000) != 0) {
            return null;
        }
        AnnotatedObject o = xmethod;
        while (o.getContainingScope() != null) {
            o = o.getContainingScope();
            HashSet<TypeQualifierAnnotation> applications = new HashSet<TypeQualifierAnnotation>();
            TypeQualifierApplications.getDirectApplications(applications, o, ElementType.PARAMETER);
            TypeQualifierAnnotation tqa = TypeQualifierApplications.findMatchingTypeQualifierAnnotation(applications, typeQualifierValue);
            if (tqa != null) {
                return tqa;
            }
            tqa = TypeQualifierApplications.getFindBugsDefaultAnnotation(o, typeQualifierValue, ElementType.PARAMETER);
            if (tqa == null) continue;
            return tqa;
        }
        return null;
    }

    static class Data {
        private Map<AnnotatedObject, Collection<AnnotationValue>> directObjectAnnotations = new HashMap<AnnotatedObject, Collection<AnnotationValue>>();
        private DualKeyHashMap<XMethod, Integer, Collection<AnnotationValue>> directParameterAnnotations = new DualKeyHashMap();
        private Map<TypeQualifierValue, Map<AnnotatedObject, TypeQualifierAnnotation>> effectiveObjectAnnotations = new HashMap<TypeQualifierValue, Map<AnnotatedObject, TypeQualifierAnnotation>>();
        private Map<TypeQualifierValue, DualKeyHashMap<XMethod, Integer, TypeQualifierAnnotation>> effectiveParameterAnnotations = new HashMap<TypeQualifierValue, DualKeyHashMap<XMethod, Integer, TypeQualifierAnnotation>>();

        Data() {
        }
    }
}

