/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.bcel;

import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

public abstract class CFGDetector
implements Detector2 {
    public void finishPass() {
    }

    public String getDetectorClassName() {
        return this.getClass().getName();
    }

    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        JavaClass jclass = analysisCache.getClassAnalysis(JavaClass.class, classDescriptor);
        for (Method method : jclass.getMethods()) {
            MethodDescriptor methodDescriptor;
            MethodGen methodGen;
            if (method.getCode() == null || (methodGen = analysisCache.getMethodAnalysis(MethodGen.class, methodDescriptor = BCELUtil.getMethodDescriptor(jclass, method))) == null) continue;
            CFG cfg = analysisCache.getMethodAnalysis(CFG.class, methodDescriptor);
            this.visitMethodCFG(methodDescriptor, cfg);
        }
    }

    protected abstract void visitMethodCFG(MethodDescriptor var1, CFG var2) throws CheckedAnalysisException;
}

