/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.ClassNameMismatchException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParser;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameAndSuperclassInfoAnalysisEngine
implements IClassAnalysisEngine<ClassNameAndSuperclassInfo> {
    @Override
    public ClassNameAndSuperclassInfo analyze(IAnalysisCache analysisCache, ClassDescriptor descriptor) throws CheckedAnalysisException {
        ClassData classData = analysisCache.getClassAnalysis(ClassData.class, descriptor);
        DataInputStream classDataIn = new DataInputStream(new ByteArrayInputStream(classData.getData()));
        ClassParser parser = new ClassParser(classDataIn, descriptor, classData.getCodeBaseEntry());
        ClassNameAndSuperclassInfo.Builder classInfoBuilder = new ClassNameAndSuperclassInfo.Builder();
        parser.parse(classInfoBuilder);
        ClassNameAndSuperclassInfo classInfo = classInfoBuilder.build();
        if (!classInfo.getClassDescriptor().equals(descriptor)) {
            throw new ClassNameMismatchException(descriptor, classInfo.getClassDescriptor(), classData.getCodeBaseEntry());
        }
        return classInfo;
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerClassAnalysisEngine(ClassNameAndSuperclassInfo.class, this);
    }

    @Override
    public boolean canRecompute() {
        return false;
    }
}

