/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ml;

import edu.umd.cs.findbugs.config.CommandLine;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertToARFF {
    private static final int UNCLASSIFIED = 0;
    private static final int BUG = 1;
    private static final int NOT_BUG = 2;
    private static final int HARMLESS = 4;
    private static final int HARMLESS_BUG = 5;
    private static final String RANDOM_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String DEFAULT_NODE_SELECTION_XPATH = "/BugCollection/BugInstance";
    private List<Attribute> attributeList = new LinkedList<Attribute>();
    private String nodeSelectionXpath = "/BugCollection/BugInstance";
    private boolean dropUnclassifiedWarnings = false;
    private String appName;

    public static String collectionToRange(Collection<String> collection) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (String aCollection : collection) {
            if (buf.length() > 1) {
                buf.append(',');
            }
            buf.append(aCollection);
        }
        buf.append("}");
        return buf.toString();
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setNodeSelectionXpath(String nodeSelectionXpath) {
        this.nodeSelectionXpath = nodeSelectionXpath;
    }

    public int getNumAttributes() {
        return this.attributeList.size();
    }

    public void dropUnclassifiedWarnings() {
        this.dropUnclassifiedWarnings = true;
    }

    public void addAttribute(Attribute attribute) {
        this.attributeList.add(attribute);
    }

    public void addNominalAttribute(String name, String xpath) {
        this.addAttribute(new NominalAttribute(name, xpath));
    }

    public void addBooleanAttribute(String name, String xpath) {
        this.addAttribute(new BooleanAttribute(name, xpath));
    }

    public void addClassificationAttribute() {
        this.addAttribute(new ClassificationAttribute());
    }

    public void addNumericAttribute(String name, String xpath) {
        this.addAttribute(new NumericAttribute(name, xpath));
    }

    public void addPriorityAttribute() {
        this.addAttribute(new PriorityAttribute());
    }

    public void addIdAttribute() {
        this.addAttribute(new IdAttribute());
    }

    public void addAppNameAttribute() {
        this.addAttribute(new AppNameAttribute());
    }

    public void convert(String relationName, Document document, String appName, Writer out) throws IOException, MissingNodeException {
        this.scan(document, appName);
        this.generateHeader(relationName, out);
        this.generateInstances(document, appName, out);
    }

    public void scan(Document document, final String appName) throws MissingNodeException, IOException {
        List<Element> bugInstanceList = this.getBugInstanceList(document);
        for (final Element element : bugInstanceList) {
            this.scanAttributeList(new AttributeCallback(){

                public void apply(Attribute attribute) throws MissingNodeException {
                    attribute.scan(element, appName);
                }
            });
        }
    }

    public void generateHeader(String relationName, final Writer out) throws MissingNodeException, IOException {
        out.write("@relation ");
        out.write(relationName);
        out.write("\n\n");
        this.scanAttributeList(new AttributeCallback(){

            public void apply(Attribute attribute) throws IOException {
                out.write("@attribute ");
                out.write(attribute.getName());
                out.write(" ");
                out.write(attribute.getRange());
                out.write("\n");
            }
        });
        out.write("\n");
        out.write("@data\n");
    }

    public void generateInstances(Document document, final String appName, final Writer out) throws MissingNodeException, IOException {
        List<Element> bugInstanceList = this.getBugInstanceList(document);
        for (final Element element : bugInstanceList) {
            this.scanAttributeList(new AttributeCallback(){
                boolean first = true;

                public void apply(Attribute attribute) throws IOException {
                    String value;
                    if (!this.first) {
                        out.write(",");
                    }
                    this.first = false;
                    try {
                        value = attribute.getInstanceValue(element, appName);
                    }
                    catch (MissingNodeException e) {
                        value = "?";
                    }
                    out.write(value);
                }
            });
            out.write("\n");
        }
    }

    public void scanAttributeList(AttributeCallback callback) throws MissingNodeException, IOException {
        for (Attribute attribute : this.attributeList) {
            callback.apply(attribute);
        }
    }

    private static int getBugClassification(String annotationText) {
        StringTokenizer tok = new StringTokenizer(annotationText, " \t\r\n\f.,:;-");
        int state = 0;
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.equals("BUG")) {
                state |= 1;
                continue;
            }
            if (s.equals("NOT_BUG")) {
                state |= 2;
                continue;
            }
            if (!s.equals("HARMLESS")) continue;
            state |= 4;
        }
        if ((state & 2) != 0) {
            return 2;
        }
        if ((state & 1) != 0) {
            return (state & 4) != 0 ? 5 : 1;
        }
        return 0;
    }

    private List<Element> getBugInstanceList(Document document) {
        List bugInstanceList = document.selectNodes(this.nodeSelectionXpath);
        if (this.dropUnclassifiedWarnings) {
            Iterator i = bugInstanceList.iterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                String annotationText = element.valueOf("./UserAnnotation[text()]");
                int classification = ConvertToARFF.getBugClassification(annotationText);
                if (classification != 0) continue;
                i.remove();
            }
        }
        return bugInstanceList;
    }

    public String toAppName(String fileName) {
        if (this.appName != null) {
            return this.appName;
        }
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0) {
            fileName = fileName.substring(0, lastDot);
        }
        return fileName;
    }

    public static void main(String[] argv) throws Exception {
        C2ACommandLine commandLine = new C2ACommandLine();
        int argCount = commandLine.parse(argv = CommandLine.expandOptionFiles(argv, true, true));
        if (argCount > argv.length - 3) {
            commandLine.printUsage(System.err);
            System.exit(1);
        }
        String relationName = argv[argCount++];
        String outputFileName = argv[argCount++];
        ConvertToARFF converter = commandLine.getConverter();
        if (converter.getNumAttributes() == 0) {
            throw new IllegalArgumentException("No attributes specified!");
        }
        OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(outputFileName)));
        ArrayList<DataFile> dataFileList = new ArrayList<DataFile>();
        while (argCount < argv.length) {
            String fileName = argv[argCount++];
            SAXReader reader = new SAXReader();
            Document document = reader.read(fileName);
            DataFile dataFile = new DataFile(document, converter.toAppName(fileName));
            dataFileList.add(dataFile);
            converter.scan(dataFile.getDocument(), dataFile.getAppName());
        }
        converter.generateHeader(relationName, out);
        for (DataFile dataFile : dataFileList) {
            converter.generateInstances(dataFile.getDocument(), dataFile.getAppName(), out);
        }
        ((Writer)out).close();
    }

    private static class C2ACommandLine
    extends CommandLine {
        private ConvertToARFF converter = new ConvertToARFF();

        public C2ACommandLine() {
            this.addOption("-select", "xpath expression", "select BugInstance elements");
            this.addSwitch("-train", "drop unclassified warnings");
            this.addSwitch("-id", "add unique id attribute (as nominal)");
            this.addSwitch("-ids", "add unique id attribute (as string)");
            this.addSwitch("-idr", "add random unique id attribtue (as nominal)");
            this.addSwitch("-app", "add application name attribute");
            this.addOption("-nominal", "attrName,xpath", "add a nominal attribute");
            this.addOption("-boolean", "attrName,xpath", "add a boolean attribute");
            this.addOption("-numeric", "attrName,xpath", "add a numeric attribute");
            this.addSwitch("-classification", "add bug classification attribute");
            this.addSwitch("-binclass", "add binary (bug/not_bug) classification attribute");
            this.addSwitch("-priority", "add priority attribute");
            this.addOption("-appname", "app name", "set application name of all tuples");
        }

        public ConvertToARFF getConverter() {
            return this.converter;
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (option.equals("-train")) {
                this.converter.dropUnclassifiedWarnings();
            } else if (option.equals("-id")) {
                this.converter.addIdAttribute();
            } else if (option.equals("-ids")) {
                this.converter.addAttribute(new IdStringAttribute());
            } else if (option.equals("-idr")) {
                this.converter.addAttribute(new RandomIdAttribute());
            } else if (option.equals("-app")) {
                this.converter.addAppNameAttribute();
            } else if (option.equals("-classification")) {
                this.converter.addClassificationAttribute();
            } else if (option.equals("-binclass")) {
                this.converter.addAttribute(new BinaryClassificationAttribute());
            } else if (option.equals("-priority")) {
                this.converter.addPriorityAttribute();
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-select")) {
                this.converter.setNodeSelectionXpath(argument);
            } else if (option.equals("-nominal")) {
                this.addXPathAttribute(option, argument, new XPathAttributeCreator(){

                    public Attribute create(String name, String xpath) {
                        return new NominalAttribute(name, xpath);
                    }
                });
            } else if (option.equals("-boolean")) {
                this.addXPathAttribute(option, argument, new XPathAttributeCreator(){

                    public Attribute create(String name, String xpath) {
                        return new BooleanAttribute(name, xpath);
                    }
                });
            } else if (option.equals("-numeric")) {
                this.addXPathAttribute(option, argument, new XPathAttributeCreator(){

                    public Attribute create(String name, String xpath) {
                        return new NumericAttribute(name, xpath);
                    }
                });
            } else if (option.equals("-appname")) {
                this.converter.setAppName(argument);
            }
        }

        protected void addXPathAttribute(String option, String argument, XPathAttributeCreator creator) {
            int comma = argument.indexOf(44);
            if (comma < 0) {
                throw new IllegalArgumentException("Missing comma separating attribute name and xpath in " + option + " option: " + argument);
            }
            String attrName = argument.substring(0, comma);
            String xpath = argument.substring(comma + 1);
            this.converter.addAttribute(creator.create(attrName, xpath));
        }

        public void printUsage(PrintStream out) {
            out.println("Usage: " + ConvertToARFF.class.getName() + " [options] <relation name> <output file> <findbugs results> [<findbugs results>...]");
            super.printUsage(out);
        }

        private static interface XPathAttributeCreator {
            public Attribute create(String var1, String var2);
        }
    }

    public static interface AttributeCallback {
        public void apply(Attribute var1) throws MissingNodeException, IOException;
    }

    public static class AppNameAttribute
    implements Attribute {
        private Set<String> appNameSet = new TreeSet<String>();

        public String getName() {
            return "appname";
        }

        public void scan(Element element, String appName) throws MissingNodeException {
            this.appNameSet.add(appName);
        }

        public String getRange() {
            return ConvertToARFF.collectionToRange(this.appNameSet);
        }

        public String getInstanceValue(Element element, String appName) throws MissingNodeException {
            return "\"" + appName + "\"";
        }
    }

    public static class RandomIdAttribute
    implements Attribute {
        private Random rng = new Random();
        private IdentityHashMap<Element, String> idMap = new IdentityHashMap();

        public String getName() {
            return "idr";
        }

        public void scan(Element element, String appName) throws MissingNodeException {
            this.idMap.put(element, this.generateId());
        }

        private String generateId() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < 20; ++i) {
                char c = ConvertToARFF.RANDOM_CHARS.charAt(this.rng.nextInt(ConvertToARFF.RANDOM_CHARS.length()));
                buf.append(c);
            }
            return buf.toString();
        }

        public String getRange() {
            TreeSet<String> range = new TreeSet<String>();
            range.addAll(this.idMap.values());
            if (range.size() != this.idMap.size()) {
                throw new IllegalStateException("id collision!");
            }
            return ConvertToARFF.collectionToRange(range);
        }

        public String getInstanceValue(Element element, String appName) throws MissingNodeException {
            String id = this.idMap.get(element);
            if (id == null) {
                throw new IllegalStateException("Element not scanned?");
            }
            return "\"" + id + "\"";
        }
    }

    public static class IdStringAttribute
    implements Attribute {
        int count = 0;

        public String getName() {
            return "ids";
        }

        public void scan(Element element, String appName) throws MissingNodeException {
        }

        public String getRange() {
            return "string";
        }

        public String getInstanceValue(Element element, String appName) throws MissingNodeException {
            org.dom4j.Attribute uidAttr = element.attribute("uid");
            String value = uidAttr == null ? String.valueOf(this.count++) : uidAttr.getStringValue();
            return "\"" + appName + "-" + value + "\"";
        }
    }

    public static class IdAttribute
    implements Attribute {
        private TreeSet<String> possibleValueSet = new TreeSet();
        private boolean scanning = true;
        private int count = 0;

        public String getName() {
            return "id";
        }

        public void scan(Element element, String appName) throws MissingNodeException {
            this.possibleValueSet.add(this.instanceValue(element, appName));
        }

        public String getRange() {
            return ConvertToARFF.collectionToRange(this.possibleValueSet);
        }

        public String getInstanceValue(Element element, String appName) throws MissingNodeException {
            if (this.scanning) {
                this.count = 0;
                this.scanning = false;
            }
            return this.instanceValue(element, appName);
        }

        private String instanceValue(Element element, String appName) {
            org.dom4j.Attribute uidAttr = element.attribute("uid");
            String nextId = uidAttr != null ? uidAttr.getValue() : String.valueOf(this.count++);
            return "\"" + appName + "-" + nextId + "\"";
        }
    }

    public static class PriorityAttribute
    implements Attribute {
        public String getName() {
            return "priority";
        }

        public void scan(Element element, String appName) throws MissingNodeException {
        }

        public String getRange() {
            return "{low,medium,high}";
        }

        public String getInstanceValue(Element element, String appName) throws MissingNodeException {
            org.dom4j.Attribute attribute = element.attribute("priority");
            if (attribute == null) {
                throw new MissingNodeException("Missing priority attribute");
            }
            String value = attribute.getValue();
            try {
                int prio = Integer.parseInt(value);
                switch (prio) {
                    case 1: {
                        return "high";
                    }
                    case 2: {
                        return "medium";
                    }
                    case 3: {
                        return "low";
                    }
                }
                return "?";
            }
            catch (NumberFormatException e) {
                throw new MissingNodeException("Invalid priority value: " + value);
            }
        }
    }

    public static class NumericAttribute
    extends XPathAttribute {
        public NumericAttribute(String name, String xpath) {
            super(name, xpath);
        }

        public void scan(Element element, String appName) throws MissingNodeException {
        }

        public String getRange() {
            return "numeric";
        }
    }

    public static class BinaryClassificationAttribute
    extends AbstractClassificationAttribute {
        public String getRange() {
            return "{bug, not_bug}";
        }

        protected String bugToString(int state) throws MissingNodeException {
            if (state == 1) {
                return "bug";
            }
            if (state == 2 || state == 5) {
                return "not_bug";
            }
            throw new MissingNodeException("unclassified warning");
        }
    }

    public static class ClassificationAttribute
    extends AbstractClassificationAttribute {
        public String getRange() {
            return "{bug,not_bug,harmless_bug}";
        }

        protected String bugToString(int state) throws MissingNodeException {
            if (state == 2) {
                return "not_bug";
            }
            if (state == 1) {
                return "bug";
            }
            if (state == 5) {
                return "harmless_bug";
            }
            throw new MissingNodeException("Unclassified warning");
        }
    }

    public static abstract class AbstractClassificationAttribute
    implements Attribute {
        public String getName() {
            return "classification";
        }

        public void scan(Element element, String appName) throws MissingNodeException {
        }

        public String getInstanceValue(Element element, String appName) throws MissingNodeException {
            String annotationText = element.valueOf("./UserAnnotation[text()]");
            int state = ConvertToARFF.getBugClassification(annotationText);
            return this.bugToString(state);
        }

        protected abstract String bugToString(int var1) throws MissingNodeException;
    }

    public static class BooleanAttribute
    extends XPathAttribute {
        public BooleanAttribute(String name, String xpath) {
            super(name, xpath);
        }

        public void scan(Element element, String appName) throws MissingNodeException {
        }

        public String getRange() {
            return "{true, false}";
        }

        public String getInstanceValue(Element element, String appName) throws MissingNodeException {
            try {
                String value = super.getInstanceValue(element, appName);
                return "\"" + Boolean.valueOf(value).toString() + "\"";
            }
            catch (MissingNodeException e) {
                return "\"false\"";
            }
        }
    }

    public static class NominalAttribute
    extends XPathAttribute {
        private Set<String> possibleValueSet = new TreeSet<String>();

        public NominalAttribute(String name, String xpath) {
            super(name, xpath);
        }

        public void scan(Element element, String appName) {
            try {
                this.possibleValueSet.add(this.getInstanceValue(element, appName));
            }
            catch (MissingNodeException missingNodeException) {
                // empty catch block
            }
        }

        public String getRange() {
            return ConvertToARFF.collectionToRange(this.possibleValueSet);
        }

        public String getInstanceValue(Element element, String appName) throws MissingNodeException {
            return "\"" + super.getInstanceValue(element, appName) + "\"";
        }
    }

    private static abstract class XPathAttribute
    implements Attribute {
        private String name;
        private String xpath;

        public XPathAttribute(String name, String xpath) {
            this.name = name;
            this.xpath = xpath;
        }

        public String getName() {
            return this.name;
        }

        public String getInstanceValue(Element element, String appName) throws MissingNodeException {
            Object value = element.selectObject(this.xpath);
            if (value == null) {
                throw new MissingNodeException("Could not get value from element (path=" + this.xpath + ")");
            }
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) {
                    throw new MissingNodeException("Could not get value from element (path=" + this.xpath + ")");
                }
                value = list.get(0);
            }
            if (value instanceof Node) {
                Node node = (Node)value;
                return node.getText();
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Number) {
                String s = value.toString();
                if (s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                return s;
            }
            throw new IllegalStateException("Unexpected object returned from xpath query: " + value);
        }
    }

    public static interface Attribute {
        public String getName();

        public void scan(Element var1, String var2) throws MissingNodeException;

        public String getRange();

        public String getInstanceValue(Element var1, String var2) throws MissingNodeException;
    }

    private static class MissingNodeException
    extends Exception {
        private static final long serialVersionUID = -5042140832791541208L;

        public MissingNodeException(String msg) {
            super(msg);
        }
    }

    private static class DataFile {
        private Document document;
        private String appName;

        public DataFile(Document document, String appName) {
            this.document = document;
            this.appName = appName;
        }

        public Document getDocument() {
            return this.document;
        }

        public String getAppName() {
            return this.appName;
        }
    }
}

