/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.properties.DetectorConfigurationTab;
import de.tobject.findbugs.properties.FilterFilesTab;
import de.tobject.findbugs.properties.ReportConfigurationTab;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.ProjectUtilities;
import de.tobject.findbugs.util.Util;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindbugsPropertyPage
extends PropertyPage {
    private boolean initialEnabled;
    private UserPreferences origUserPreferences;
    private UserPreferences currentUserPreferences;
    private IProject project;
    private Button chkEnableFindBugs;
    private Button restoreDefaultsButton;
    private ComboViewer effortViewer;
    private EffortPlaceHolder defaultEffortLevel;
    private TabFolder tabFolder;
    private DetectorConfigurationTab detectorTab;
    private FilterFilesTab filterFilesTab;
    private ReportConfigurationTab reportConfigurationTab;
    private Map<DetectorFactory, Boolean> visibleDetectors = new HashMap<DetectorFactory, Boolean>();

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IAdaptable resource = this.getElement();
        this.project = (IProject)resource.getAdapter(IProject.class);
        this.collectUserPreferences();
        this.createGlobalElements(parent);
        this.createConfigurationTabFolder(parent);
        this.createDefaultsButton(parent);
        return parent;
    }

    private void createConfigurationTabFolder(Composite composite) {
        this.tabFolder = new TabFolder(composite, 128);
        GridData layoutData = new GridData(1808);
        layoutData.verticalIndent = -5;
        this.tabFolder.setLayoutData((Object)layoutData);
        this.detectorTab = new DetectorConfigurationTab(this.tabFolder, this, 0);
        this.reportConfigurationTab = new ReportConfigurationTab(this.tabFolder, this, 0);
        this.filterFilesTab = new FilterFilesTab(this.tabFolder, this, 0);
    }

    private void createDefaultsButton(Composite composite) {
        this.restoreDefaultsButton = new Button(composite, 0);
        this.restoreDefaultsButton.setText(this.getMessage("property.restoreSettings"));
        this.restoreDefaultsButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.restoreDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindbugsPropertyPage.this.restoreDefaultSettings();
            }
        });
    }

    private void createGlobalElements(Composite parent) {
        Composite globalGroup = new Composite(parent, 128);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        globalGroup.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.verticalIndent = -2;
        globalGroup.setLayoutData((Object)layoutData);
        this.initialEnabled = this.isEnabled();
        this.chkEnableFindBugs = new Button(globalGroup, 32);
        this.chkEnableFindBugs.setText(this.getMessage("property.runAuto"));
        this.chkEnableFindBugs.setSelection(this.initialEnabled);
        this.chkEnableFindBugs.setToolTipText("Enable / disable FindBugs project builder (disabled by default)");
        Composite prioGroup = new Composite(globalGroup, 0);
        GridLayout prioLayout = new GridLayout(2, false);
        prioGroup.setLayout((Layout)prioLayout);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = -5;
        layoutData.verticalIndent = -5;
        prioGroup.setLayoutData((Object)layoutData);
        Label effortLabel = new Label(prioGroup, 0);
        effortLabel.setText(this.getMessage("property.effort"));
        this.effortViewer = new ComboViewer(prioGroup, 12);
        this.effortViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.effortViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.defaultEffortLevel = new EffortPlaceHolder(this.getMessage("property.effortdefault"), "default");
        EffortPlaceHolder[] effortLevels = new EffortPlaceHolder[]{new EffortPlaceHolder(this.getMessage("property.effortmin"), "min"), this.defaultEffortLevel, new EffortPlaceHolder(this.getMessage("property.effortmax"), "max")};
        this.effortViewer.add((Object[])effortLevels);
        String effort = this.currentUserPreferences.getEffort();
        for (int i = 0; i < effortLevels.length; ++i) {
            if (!effortLevels[i].getEffortLevel().equals(effort)) continue;
            this.effortViewer.setSelection((ISelection)new StructuredSelection((Object)effortLevels[i]), true);
        }
        this.effortViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EffortPlaceHolder placeHolder = (EffortPlaceHolder)((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
                FindbugsPropertyPage.this.currentUserPreferences.setEffort(placeHolder.getEffortLevel());
            }
        });
        effortLabel.setToolTipText("Set FindBugs analysis effort (minimal is faster but less precise)");
        this.effortViewer.getCombo().setToolTipText("Set FindBugs analysis effort (minimal is faster but less precise)");
    }

    private void collectUserPreferences() {
        try {
            this.origUserPreferences = FindbugsPlugin.getUserPreferences(this.project);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not get user preferences for project");
            this.origUserPreferences = UserPreferences.createDefaultUserPreferences();
        }
        this.currentUserPreferences = (UserPreferences)this.origUserPreferences.clone();
    }

    private void restoreDefaultSettings() {
        this.visibleDetectors.clear();
        this.chkEnableFindBugs.setSelection(false);
        this.effortViewer.setSelection((ISelection)new StructuredSelection((Object)this.defaultEffortLevel), true);
        this.getDetectorTab().restoreDefaultSettings();
        this.reportConfigurationTab.restoreDefaultSettings();
        this.filterFilesTab.restoreDefaultSettings();
    }

    public boolean performOk() {
        boolean builderEnabled = this.chkEnableFindBugs.getSelection();
        if (!this.initialEnabled && builderEnabled) {
            this.addNature();
        } else if (this.initialEnabled && !builderEnabled) {
            this.removeNature();
        }
        if (!this.currentUserPreferences.equals((Object)this.origUserPreferences)) {
            try {
                FindbugsPlugin.saveUserPreferences(this.project, this.currentUserPreferences);
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not store FindBugs preferences for project");
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not store FindBugs preferences for project");
            }
            if (builderEnabled) {
                this.runFindbugsBuilder();
            }
        }
        if (!builderEnabled && !this.currentUserPreferences.getFilterSettings().equals((Object)this.origUserPreferences.getFilterSettings())) {
            MarkerUtil.redisplayMarkers(JavaCore.create((IProject)this.project), this.getShell());
        }
        return true;
    }

    private boolean isEnabled() {
        try {
            return this.project.hasNature("edu.umd.cs.findbugs.plugin.eclipse.findbugsNature") && Util.isJavaProject(this.project);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Error while testing FindBugs nature for project " + this.project);
            return false;
        }
    }

    protected IProject getProject() {
        return this.project;
    }

    private void runFindbugsBuilder() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        FindbugsPropertyPage.this.getProject().build(15, "edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder", null, monitor);
                    }
                    catch (OperationCanceledException e) {
                    }
                    catch (CoreException e) {
                        FindbugsPlugin.getDefault().logException(e, "Error while runnning FindBugs builder for project");
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            FindbugsPlugin.getDefault().logException(e, "Error while runnning FindBugs builder for project");
        }
        catch (InterruptedException e) {
            FindbugsPlugin.getDefault().logException(e, "Findbugs builder was interrupted");
        }
    }

    private boolean addNature() {
        try {
            NatureWorker worker = new NatureWorker(true);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.getShell());
            monitor.run(true, true, (IRunnableWithProgress)worker);
            return true;
        }
        catch (InvocationTargetException e) {
            FindbugsPlugin.getDefault().logException(e, "'Add nature' failed");
        }
        catch (InterruptedException e) {
            FindbugsPlugin.getDefault().logException(e, "'Add nature' interrupted");
        }
        return false;
    }

    private boolean removeNature() {
        try {
            NatureWorker worker = new NatureWorker(false);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.getShell());
            monitor.run(true, true, (IRunnableWithProgress)worker);
            return true;
        }
        catch (InvocationTargetException e) {
            FindbugsPlugin.getDefault().logException(e, "'Remove nature' failed");
        }
        catch (InterruptedException e) {
            FindbugsPlugin.getDefault().logException(e, "'Remove nature' interrupted");
        }
        return false;
    }

    protected String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }

    UserPreferences getCurrentUserPreferences() {
        return this.currentUserPreferences;
    }

    UserPreferences getOriginalUserPreferences() {
        return this.origUserPreferences;
    }

    Map<DetectorFactory, Boolean> getVisibleDetectors() {
        return this.visibleDetectors;
    }

    DetectorConfigurationTab getDetectorTab() {
        return this.detectorTab;
    }

    private static final class EffortPlaceHolder
    extends WorkbenchAdapter
    implements IAdaptable {
        private final String name;
        private final String effortLevel;

        public EffortPlaceHolder(String name, String effortLevel) {
            this.name = name;
            this.effortLevel = effortLevel;
        }

        public String getLabel(Object object) {
            return this.name;
        }

        public String getEffortLevel() {
            return this.effortLevel;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(IWorkbenchAdapter.class)) {
                return this;
            }
            return null;
        }
    }

    private final class NatureWorker
    implements IRunnableWithProgress {
        private boolean add = true;

        public NatureWorker(boolean add) {
            this.add = add;
        }

        public void run(IProgressMonitor monitor) {
            try {
                if (this.add) {
                    ProjectUtilities.addFindBugsNature(FindbugsPropertyPage.this.project, monitor);
                } else {
                    ProjectUtilities.removeFindBugsNature(FindbugsPropertyPage.this.project, monitor);
                }
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "Core exception in NatureWorker");
            }
        }
    }
}

