/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.AbstractFindbugsView;
import de.tobject.findbugs.view.UserAnnotationsView;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class DetailsView
extends AbstractFindbugsView {
    private String description = "";
    private String title = "";
    private List annotationList;
    private BugInstance theBug;
    private ISelectionListener selectionListener;
    @CheckForNull
    private StyledText htmlControl;
    private DefaultInformationControl.IInformationPresenterExtension presenter;
    private TextPresentation presentation = new TextPresentation();
    @CheckForNull
    private Browser browser;
    private IFile file;
    private IMarker marker;

    public Composite createRootControl(Composite parent) {
        SashForm sash = new SashForm(parent, 66048);
        this.annotationList = new List((Composite)sash, 2816);
        this.annotationList.setFont(JFaceResources.getDialogFont());
        this.annotationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evnt) {
                DetailsView.this.selectInEditor(false);
            }
        });
        this.annotationList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DetailsView.this.selectInEditor(true);
            }
        });
        try {
            this.browser = new Browser((Composite)sash, 2048);
        }
        catch (SWTError e) {
            this.htmlControl = new StyledText((Composite)sash, 2824);
            this.htmlControl.setEditable(false);
            this.htmlControl.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent evt) {
                    DetailsView.this.updateDisplay();
                }
            });
            try {
                Class<?> presenterClass = Class.forName("org.eclipse.jdt.internal.ui.text.HTMLTextPresenter.HTMLTextPresenter");
                this.presenter = (DefaultInformationControl.IInformationPresenterExtension)presenterClass.getConstructor(Boolean.TYPE).newInstance(false);
            }
            catch (Exception e2) {
                FindbugsPlugin.getDefault().logException(new RuntimeException(e.getMessage(), e), "Could not create a org.eclipse.swt.widgets.Composite.Browser");
            }
        }
        sash.setWeights(new int[]{1, 2});
        ISelectionService theService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
                if (!(theSelection instanceof IStructuredSelection)) {
                    return;
                }
                if (!DetailsView.this.isVisible()) {
                    return;
                }
                IMarker theMarker = null;
                Object elt = ((IStructuredSelection)theSelection).getFirstElement();
                if (elt instanceof IMarker) {
                    theMarker = (IMarker)elt;
                }
                if (theMarker != null) {
                    DetailsView.this.selectMarker(theMarker);
                }
            }
        };
        theService.addSelectionListener(this.selectionListener);
        return sash;
    }

    private static void goToLine(IEditorPart editorPart, int lineNumber) {
        if (!(editorPart instanceof ITextEditor) || lineNumber <= 0) {
            return;
        }
        ITextEditor editor = (ITextEditor)editorPart;
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (document != null) {
            IRegion lineInfo = null;
            try {
                lineInfo = document.getLineInformation(lineNumber - 1);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            if (lineInfo != null) {
                editor.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
            }
        }
    }

    public void setFocus() {
        this.annotationList.setFocus();
    }

    public void dispose() {
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        this.theBug = null;
        this.file = null;
        super.dispose();
    }

    private void updateDisplay() {
        String html = "<b>" + this.title + "</b><br/>" + this.description;
        this.setHTMLText(html);
    }

    private void setHTMLText(String html) {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.setText(html);
        } else if (this.htmlControl != null && !this.htmlControl.isDisposed() && this.presenter != null) {
            Rectangle size = this.htmlControl.getClientArea();
            html = this.presenter.updatePresentation((Drawable)this.getSite().getShell().getDisplay(), html, this.presentation, size.width, size.height);
            this.htmlControl.setText(html);
            TextPresentation.applyTextPresentation((TextPresentation)this.presentation, (StyledText)this.htmlControl);
        }
    }

    private void setContent(BugPattern pattern, BugInstance theBug, String priorityTypeString, IMarker marker) {
        this.marker = marker;
        String abbrev = null;
        if (pattern != null) {
            String shortDescription = pattern.getShortDescription();
            String detailText = pattern.getDetailText();
            abbrev = "[" + pattern.getAbbrev() + "] ";
            this.title = shortDescription == null ? abbrev : abbrev + shortDescription.trim() + " [" + pattern.getType() + "]";
            this.description = detailText == null ? "" : detailText.trim();
        } else {
            this.title = "";
            this.description = "";
            abbrev = "";
        }
        this.theBug = theBug;
        this.file = (IFile)(marker.getResource() instanceof IFile ? marker.getResource() : null);
        if (this.file == null) {
            FindbugsPlugin.getDefault().logError("Could not find file for " + theBug.getMessage());
        }
        this.setContentDescription(abbrev + priorityTypeString);
        this.setTitleToolTip(this.getTitle());
        this.showAnnotations(theBug);
        this.updateDisplay();
        IViewPart viewPart = this.getSite().getPage().findView("de.tobject.findbugs.view.userannotationsview");
        if (viewPart instanceof UserAnnotationsView) {
            UserAnnotationsView.showMarker(marker);
        }
    }

    public static void showMarker(IMarker marker) {
        IWorkbenchPage page = FindbugsPlugin.getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView("de.tobject.findbugs.view.detailsview");
        if (!(viewPart instanceof DetailsView)) {
            viewPart = AbstractFindbugsView.showDetailsView();
        }
        if (viewPart instanceof DetailsView) {
            DetailsView.showInView(marker, (DetailsView)viewPart);
        }
    }

    private static void showInView(IMarker marker, DetailsView detailsView) {
        String bugType = marker.getAttribute("BUGTYPE", "");
        String priorityTypeString = marker.getAttribute("PRIORITY_TYPE", "");
        BugPattern pattern = I18N.instance().lookupBugPattern(bugType);
        BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
        detailsView.setContent(pattern, bug, priorityTypeString, marker);
        detailsView.activate();
    }

    private void selectMarker(IMarker newMarker) {
        if (!this.isVisible()) {
            DetailsView.showMarker(newMarker);
        } else {
            DetailsView.showInView(newMarker, this);
        }
    }

    private void showAnnotations(BugInstance bug) {
        this.annotationList.removeAll();
        if (bug != null) {
            Iterator it = bug.annotationIterator();
            while (it.hasNext()) {
                BugAnnotation ba = (BugAnnotation)it.next();
                this.annotationList.add(ba.toString());
            }
        }
    }

    private void selectInEditor(boolean openEditor) {
        IEditorInput input;
        if (this.theBug == null || this.file == null) {
            return;
        }
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        IEditorInput iEditorInput = input = activeEditor != null ? activeEditor.getEditorInput() : null;
        if (openEditor && !this.matchInput(input)) {
            try {
                activeEditor = IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IFile)this.file);
                input = activeEditor.getEditorInput();
            }
            catch (PartInitException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not open editor for " + this.theBug.getMessage());
            }
        }
        if (this.matchInput(input)) {
            int startLine = this.getLineToSelect();
            DetailsView.goToLine(activeEditor, startLine);
        }
    }

    private boolean matchInput(IEditorInput input) {
        return input instanceof IFileEditorInput && this.file.equals(((IFileEditorInput)input).getFile());
    }

    private int getLineToSelect() {
        int index = this.annotationList.getSelectionIndex();
        Iterator theIterator = this.theBug.annotationIterator();
        BugAnnotation theAnnotation = (BugAnnotation)theIterator.next();
        for (int i = 0; i < index; ++i) {
            theAnnotation = (BugAnnotation)theIterator.next();
        }
        if (!(theAnnotation instanceof SourceLineAnnotation)) {
            return this.marker.getAttribute("lineNumber", -1);
        }
        SourceLineAnnotation sla = (SourceLineAnnotation)theAnnotation;
        int startLine = sla.getStartLine();
        return startLine;
    }

    public IMarker getMarker() {
        return this.marker;
    }
}

