/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.marker.FindBugsMarker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class BugPatternGroup {
    private final String shortPatternDescription;
    private final List<IMarker> children;
    private final IResource parent;

    private BugPatternGroup(IResource parent, String shortPatternDescription) {
        this.parent = parent;
        this.shortPatternDescription = shortPatternDescription;
        this.children = new ArrayList<IMarker>();
    }

    public IMarker[] getChildren() {
        return this.children.toArray(new IMarker[this.children.size()]);
    }

    public String getShortPatternDescription() {
        return this.shortPatternDescription;
    }

    public IResource getParent() {
        return this.parent;
    }

    public IMarker getFirstElement() {
        if (this.children.size() > 0) {
            return this.children.get(0);
        }
        return null;
    }

    public int size() {
        return this.children.size();
    }

    private void addmarker(IMarker marker) {
        this.children.add(marker);
    }

    private void sort() {
        Collections.sort(this.children, new Comparator<IMarker>(){

            @Override
            public int compare(IMarker m1, IMarker m2) {
                try {
                    int ordinal1 = FindBugsMarker.Priority.ordinal(m1.getType());
                    int ordinal2 = FindBugsMarker.Priority.ordinal(m2.getType());
                    int result = ordinal1 - ordinal2;
                    if (result != 0) {
                        return result;
                    }
                    String a1 = m1.getAttribute("message", "");
                    String a2 = m1.getAttribute("message", "");
                    return a1.compareTo(a2);
                }
                catch (CoreException e) {
                    FindbugsPlugin.getDefault().logException(e, "Sort error");
                    return 0;
                }
            }
        });
    }

    static BugPatternGroup[] createGroups(IResource parent) {
        IMarker[] markers = BugPatternGroup.getMarkers(parent);
        HashMap<String, BugPatternGroup> groups = new HashMap<String, BugPatternGroup>();
        for (IMarker marker : markers) {
            String attribute = marker.getAttribute("PATTERN_DESCR_SHORT", "unknown");
            BugPatternGroup group = (BugPatternGroup)groups.get(attribute);
            if (group == null) {
                group = new BugPatternGroup(parent, attribute);
                groups.put(attribute, group);
            }
            group.addmarker(marker);
        }
        Set entrySet = groups.entrySet();
        for (Map.Entry entry : entrySet) {
            ((BugPatternGroup)entry.getValue()).sort();
        }
        return groups.values().toArray(new BugPatternGroup[groups.size()]);
    }

    static IMarker[] getMarkers(IResource resource) {
        try {
            IMarker[] markerArr = resource.findMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
            return markerArr;
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Core exception on getElements for input: " + resource);
            return null;
        }
    }

    public String toString() {
        return this.shortPatternDescription;
    }
}

