/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ReferenceType;

public class BuildNonnullReturnDatabase {
    public static final boolean VERBOSE_DEBUG = SystemProperties.getBoolean((String)"fnd.debug.nullarg.verbose");
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"fnd.debug.nullarg") || VERBOSE_DEBUG;
    protected int returnsReference;
    protected int returnsNonNull;

    public void visitClassContext(ClassContext classContext) {
        boolean fullAnalysis = AnalysisContext.currentAnalysisContext().getBoolProperty(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES);
        if (!fullAnalysis && !AnalysisContext.currentAnalysisContext().getSubtypes().isApplicationClass(classContext.getJavaClass())) {
            return;
        }
        if (VERBOSE_DEBUG) {
            System.out.println("Visiting class " + classContext.getJavaClass().getClassName());
        }
        for (Method m : classContext.getMethodsInCallOrder()) {
            this.considerMethod(classContext, m);
        }
    }

    private void considerMethod(ClassContext classContext, Method method) {
        if (method.getReturnType() instanceof ReferenceType && classContext.getMethodGen(method) != null) {
            if (VERBOSE_DEBUG) {
                System.out.println("Check " + method);
            }
            this.analyzeMethod(classContext, method);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) {
        ++this.returnsReference;
        try {
            CFG cfg = classContext.getCFG(method);
            IsNullValueDataflow inv = classContext.getIsNullValueDataflow(method);
            boolean guaranteedNonNull = true;
            Iterator i = cfg.locationIterator();
            while (i.hasNext()) {
                IsNullValue value;
                IsNullValueFrame frame;
                Location location = (Location)i.next();
                InstructionHandle handle = location.getHandle();
                Instruction ins = handle.getInstruction();
                if (!(ins instanceof ARETURN) || !(frame = (IsNullValueFrame)inv.getFactAtLocation(location)).isValid() || (value = (IsNullValue)frame.getTopValue()).isDefinitelyNotNull()) continue;
                guaranteedNonNull = false;
                break;
            }
            XMethod xmethod = XFactory.createXMethod((JavaClass)classContext.getJavaClass(), (Method)method);
            if (guaranteedNonNull) {
                ++this.returnsNonNull;
                AnalysisContext.currentAnalysisContext().getReturnValueNullnessPropertyDatabase().setProperty((FieldOrMethodDescriptor)xmethod.getMethodDescriptor(), (Object)guaranteedNonNull);
                if (DEBUG) {
                    System.out.println("Unconditional deref: " + xmethod + "=" + guaranteedNonNull);
                }
            }
        }
        catch (CFGBuilderException e) {
            XMethod xmethod = XFactory.createXMethod((JavaClass)classContext.getJavaClass(), (Method)method);
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error analyzing " + xmethod + " for unconditional deref training", (Throwable)e);
        }
        catch (DataflowAnalysisException e) {
            XMethod xmethod = XFactory.createXMethod((JavaClass)classContext.getJavaClass(), (Method)method);
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error analyzing " + xmethod + " for unconditional deref training", (Throwable)e);
        }
    }
}

