/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;

public class CrossSiteScripting
extends OpcodeStackDetector {
    final BugReporter bugReporter;
    final BugAccumulator accumulator;
    Map<String, OpcodeStack.Item> map = new HashMap<String, OpcodeStack.Item>();
    OpcodeStack.Item top = null;
    Pattern xmlSafe = Pattern.compile("\\p{Alnum}+");
    OpcodeStack.Item replaceTop = null;

    public CrossSiteScripting(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code code) {
        super.visit(code);
        this.map.clear();
        this.accumulator.reportAccumulatedBugs();
    }

    private void annotateAndReport(BugInstance bug, OpcodeStack.Item item) {
        assert (item.isServletParameterTainted());
        String s = item.getHttpParameterName();
        int pc = item.getInjectionPC();
        if (s != null && this.xmlSafe.matcher(s).matches()) {
            bug.addString(s).describe("STRING_PARAMETER_NAME");
        }
        SourceLineAnnotation thisLine = SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this);
        if (pc >= 0) {
            SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this, (int)pc);
            if (thisLine.getStartLine() != source.getStartLine()) {
                bug.add((BugAnnotation)source).describe("SOURCE_LINE_GENERATED_AT");
            }
        }
        bug.addOptionalLocalVariable((DismantleBytecode)this, item);
        this.accumulator.accumulateBug(bug, (BytecodeScanningDetector)this);
    }

    public void sawOpcode(int seen) {
        if (this.replaceTop != null) {
            this.stack.replaceTop(this.replaceTop);
            this.replaceTop = null;
        }
        OpcodeStack.Item oldTop = this.top;
        this.top = null;
        if (seen == 183) {
            String calledClassName = this.getClassConstantOperand();
            String calledMethodName = this.getNameConstantOperand();
            String calledMethodSig = this.getSigConstantOperand();
            if (calledClassName.equals("javax/servlet/http/Cookie") && calledMethodName.equals("<init>") && calledMethodSig.equals("(Ljava/lang/String;Ljava/lang/String;)V")) {
                OpcodeStack.Item value = this.stack.getStackItem(0);
                OpcodeStack.Item name = this.stack.getStackItem(1);
                if (value.isServletParameterTainted() || name.isServletParameterTainted()) {
                    int priority = Math.min(this.taintPriority(value), this.taintPriority(name));
                    this.annotateAndReport(new BugInstance((Detector)this, "HRS_REQUEST_PARAMETER_TO_COOKIE", priority).addClassAndMethod((PreorderVisitor)this), value.isServletParameterTainted() ? value : name);
                }
            }
        } else if (seen == 185) {
            OpcodeStack.Item writing;
            String calledClassName = this.getClassConstantOperand();
            String calledMethodName = this.getNameConstantOperand();
            String calledMethodSig = this.getSigConstantOperand();
            if (calledClassName.equals("javax/servlet/http/HttpSession") && calledMethodName.equals("setAttribute")) {
                OpcodeStack.Item value = this.stack.getStackItem(0);
                OpcodeStack.Item name = this.stack.getStackItem(1);
                Object nameConstant = name.getConstant();
                if (nameConstant instanceof String) {
                    this.map.put((String)nameConstant, value);
                }
            } else if (calledClassName.equals("javax/servlet/http/HttpSession") && calledMethodName.equals("getAttribute")) {
                OpcodeStack.Item name = this.stack.getStackItem(0);
                Object nameConstant = name.getConstant();
                if (nameConstant instanceof String) {
                    this.top = this.map.get((String)nameConstant);
                    if (this.isTainted(this.top)) {
                        this.replaceTop = this.top;
                    }
                }
            } else if (calledClassName.equals("javax/servlet/http/HttpServletResponse") && (calledMethodName.startsWith("send") || calledMethodName.endsWith("Header")) && calledMethodSig.endsWith("Ljava/lang/String;)V") && this.isTainted(writing = this.stack.getStackItem(0))) {
                if (calledMethodName.equals("sendError")) {
                    this.annotateAndReport(new BugInstance((Detector)this, "XSS_REQUEST_PARAMETER_TO_SEND_ERROR", this.taintPriority(writing)).addClassAndMethod((PreorderVisitor)this), writing);
                } else {
                    this.annotateAndReport(new BugInstance((Detector)this, "HRS_REQUEST_PARAMETER_TO_HTTP_HEADER", this.taintPriority(writing)).addClassAndMethod((PreorderVisitor)this), writing);
                }
            }
        } else if (seen == 182) {
            String calledClassName = this.getClassConstantOperand();
            String calledMethodName = this.getNameConstantOperand();
            String calledMethodSig = this.getSigConstantOperand();
            if ((calledMethodName.startsWith("print") || calledMethodName.equals("write")) && calledClassName.equals("javax/servlet/jsp/JspWriter") && (calledMethodSig.equals("(Ljava/lang/Object;)V") || calledMethodSig.equals("(Ljava/lang/String;)V"))) {
                OpcodeStack.Item writing = this.stack.getStackItem(0);
                if (this.isTainted(writing)) {
                    this.annotateAndReport(new BugInstance((Detector)this, "XSS_REQUEST_PARAMETER_TO_JSP_WRITER", this.taintPriority(writing)).addClassAndMethod((PreorderVisitor)this), writing);
                } else if (this.isTainted(oldTop)) {
                    this.annotateAndReport(new BugInstance((Detector)this, "XSS_REQUEST_PARAMETER_TO_JSP_WRITER", 2).addClassAndMethod((PreorderVisitor)this), oldTop);
                }
            } else if (calledMethodName.startsWith("print") && calledClassName.equals("java/io/PrintWriter") && (calledMethodSig.equals("(Ljava/lang/Object;)V") || calledMethodSig.equals("(Ljava/lang/String;)V"))) {
                OpcodeStack.Item writing = this.stack.getStackItem(0);
                OpcodeStack.Item writingTo = this.stack.getStackItem(1);
                if (this.isTainted(writing) && this.isServletWriter(writingTo)) {
                    this.annotateAndReport(new BugInstance((Detector)this, "XSS_REQUEST_PARAMETER_TO_SERVLET_WRITER", this.taintPriority(writing)).addClassAndMethod((PreorderVisitor)this), writing);
                } else if (this.isTainted(oldTop) && this.isServletWriter(writingTo)) {
                    this.annotateAndReport(new BugInstance((Detector)this, "XSS_REQUEST_PARAMETER_TO_SERVLET_WRITER", 2).addClassAndMethod((PreorderVisitor)this), writing);
                }
            }
        }
    }

    private boolean isTainted(OpcodeStack.Item writing) {
        if (writing == null) {
            return false;
        }
        return writing.isServletParameterTainted();
    }

    private int taintPriority(OpcodeStack.Item writing) {
        if (writing == null) {
            return 2;
        }
        XMethod method = writing.getReturnValueOf();
        if (method != null && method.getName().equals("getParameter") && method.getClassName().equals("javax.servlet.http.HttpServletRequest")) {
            return 1;
        }
        return 2;
    }

    private boolean isServletWriter(OpcodeStack.Item writingTo) {
        XMethod writingToSource = writingTo.getReturnValueOf();
        return writingToSource != null && writingToSource.getClassName().equals("javax.servlet.http.HttpServletResponse") && writingToSource.getName().equals("getWriter");
    }
}

