/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class FieldItemSummary
extends OpcodeStackDetector
implements NonReportingDetector {
    FieldSummary fieldSummary = new FieldSummary();
    Set<XField> touched = new HashSet<XField>();
    boolean sawInitializeSuper;

    public FieldItemSummary(BugReporter bugReporter) {
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        context.setFieldSummary(this.fieldSummary);
    }

    public void sawOpcode(int seen) {
        if (seen == 183 && this.getMethodName().equals("<init>") && this.getNameConstantOperand().equals("<init>") && !this.getClassConstantOperand().equals(this.getClassName())) {
            this.sawInitializeSuper = true;
        }
        if (seen == 181 || seen == 179) {
            XField fieldOperand = this.getXFieldOperand();
            if (fieldOperand == null) {
                return;
            }
            this.touched.add(fieldOperand);
            if (!fieldOperand.getClassDescriptor().getClassName().equals(this.getClassName())) {
                this.fieldSummary.addWrittenOutsideOfConstructor(fieldOperand);
            } else if (seen == 181) {
                OpcodeStack.Item addr = this.stack.getStackItem(1);
                if (addr.getRegisterNumber() != 0 || !this.getMethodName().equals("<init>")) {
                    this.fieldSummary.addWrittenOutsideOfConstructor(fieldOperand);
                }
            } else if (seen == 179 && !this.getMethodName().equals("<clinit>")) {
                this.fieldSummary.addWrittenOutsideOfConstructor(fieldOperand);
            }
            OpcodeStack.Item top = this.stack.getStackItem(0);
            this.fieldSummary.mergeSummary(fieldOperand, top);
        }
    }

    public void visit(Code obj) {
        this.sawInitializeSuper = false;
        super.visit(obj);
        this.fieldSummary.setFieldsWritten(this.getXMethod(), this.touched);
        if (this.getMethodName().equals("<init>") && this.sawInitializeSuper) {
            XClass thisClass = this.getXClass();
            for (XField f : thisClass.getXFields()) {
                if (this.touched.contains(f)) continue;
                char firstChar = f.getSignature().charAt(0);
                OpcodeStack.Item item = firstChar == 'L' || firstChar == '[' ? OpcodeStack.Item.nullItem((String)f.getSignature()) : (firstChar == 'I' ? new OpcodeStack.Item("I", (Object)0) : (firstChar == 'J' ? new OpcodeStack.Item("J", (Object)0L) : new OpcodeStack.Item(f.getSignature())));
                this.fieldSummary.mergeSummary(f, item);
            }
        }
        this.touched.clear();
    }

    public void report() {
        this.fieldSummary.setComplete(true);
    }
}

