/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;

public class FindHEmismatch
extends OpcodeStackDetector
implements StatelessDetector {
    boolean hasFields = false;
    boolean visibleOutsidePackage = false;
    boolean hasHashCode = false;
    boolean hasEqualsObject = false;
    boolean hashCodeIsAbstract = false;
    boolean equalsObjectIsAbstract = false;
    boolean equalsMethodIsInstanceOfEquals = false;
    boolean hasCompareToObject = false;
    boolean hasCompareToBridgeMethod = false;
    boolean hasEqualsSelf = false;
    boolean hasEqualsOther = false;
    boolean hasCompareToSelf = false;
    boolean extendsObject = false;
    MethodAnnotation equalsMethod = null;
    MethodAnnotation equalsOtherMethod = null;
    ClassDescriptor equalsOtherClass = null;
    MethodAnnotation compareToMethod = null;
    MethodAnnotation compareToObjectMethod = null;
    MethodAnnotation compareToSelfMethod = null;
    MethodAnnotation hashCodeMethod = null;
    HashSet<String> nonHashableClasses = new HashSet();
    Map<String, BugInstance> potentialBugs = new HashMap<String, BugInstance>();
    private BugReporter bugReporter;
    static final Pattern predicateOverAnInstance = Pattern.compile("\\(L([^;]+);\\)Z");
    static final Pattern mapPattern = Pattern.compile("HashMap<L([^;<]*);");
    static final Pattern hashTablePattern = Pattern.compile("Hashtable<L([^;<]*);");
    static final Pattern setPattern = Pattern.compile("HashSet<L([^;<]*);");

    public boolean isHashableClassName(String dottedClassName) {
        return !this.nonHashableClasses.contains(dottedClassName);
    }

    public FindHEmismatch(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitAfter(JavaClass obj) {
        if (!obj.isClass()) {
            return;
        }
        if (this.getDottedClassName().equals("java.lang.Object")) {
            return;
        }
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 0x200) != 0) {
            return;
        }
        this.visibleOutsidePackage = obj.isPublic() || obj.isProtected();
        String whereEqual = this.getDottedClassName();
        boolean inheritedHashCodeIsFinal = false;
        boolean inheritedEqualsIsFinal = false;
        boolean inheritedEqualsIsAbstract = false;
        boolean inheritedEqualsFromAbstractClass = false;
        XMethod inheritedEquals = null;
        if (!this.hasEqualsObject) {
            XClass we = Lookup.findImplementor((XClass)this.getXClass(), (String)"equals", (String)"(Ljava/lang/Object;)Z", (boolean)false, (BugReporter)this.bugReporter);
            if (we == null || we.equals(this.getXClass())) {
                whereEqual = "java.lang.Object";
            } else {
                inheritedEqualsFromAbstractClass = we.isAbstract();
                whereEqual = we.getClassDescriptor().getDottedClassName();
                inheritedEquals = we.findMethod("equals", "(Ljava/lang/Object;)Z", false);
                if (inheritedEquals != null) {
                    inheritedEqualsIsFinal = inheritedEquals.isFinal();
                    inheritedEqualsIsAbstract = inheritedEquals.isAbstract();
                }
            }
        }
        boolean usesDefaultEquals = whereEqual.equals("java.lang.Object");
        String whereHashCode = this.getDottedClassName();
        if (!this.hasHashCode) {
            XClass wh = Lookup.findSuperImplementor((XClass)this.getXClass(), (String)"hashCode", (String)"()I", (boolean)false, (BugReporter)this.bugReporter);
            if (wh == null) {
                whereHashCode = "java.lang.Object";
            } else {
                whereHashCode = wh.getClassDescriptor().getDottedClassName();
                XMethod m = wh.findMethod("hashCode", "()I", false);
                if (m != null && m.isFinal()) {
                    inheritedHashCodeIsFinal = true;
                }
            }
        }
        boolean usesDefaultHashCode = whereHashCode.equals("java.lang.Object");
        if (!this.hasEqualsObject && !this.hasEqualsSelf && this.hasEqualsOther) {
            BugInstance bug = new BugInstance((Detector)this, usesDefaultEquals ? "EQ_OTHER_USE_OBJECT" : "EQ_OTHER_NO_OBJECT", 2).addClass((PreorderVisitor)this).addMethod(this.equalsOtherMethod).addClass(this.equalsOtherClass);
            this.bugReporter.reportBug(bug);
        }
        if (!this.hasEqualsObject && this.hasEqualsSelf) {
            String bugPattern;
            if (usesDefaultEquals) {
                int priority = 1;
                if (usesDefaultHashCode || obj.isAbstract()) {
                    ++priority;
                }
                if (!this.visibleOutsidePackage) {
                    ++priority;
                }
                bugPattern = "EQ_SELF_USE_OBJECT";
                BugInstance bug = new BugInstance((Detector)this, bugPattern, priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            } else {
                int priority = 2;
                if (this.hasFields) {
                    --priority;
                }
                if (obj.isAbstract()) {
                    ++priority;
                }
                bugPattern = "EQ_SELF_NO_OBJECT";
                String superclassName = obj.getSuperclassName();
                if (superclassName.equals("java.lang.Enum")) {
                    bugPattern = "EQ_DONT_DEFINE_EQUALS_FOR_ENUM";
                    priority = 1;
                }
                BugInstance bug = new BugInstance((Detector)this, bugPattern, priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            }
        }
        if ((this.hasCompareToObject || this.hasCompareToSelf) && usesDefaultEquals) {
            BugInstance bug = new BugInstance((Detector)this, "EQ_COMPARETO_USE_OBJECT_EQUALS", obj.isAbstract() ? 3 : 2).addClass((PreorderVisitor)this);
            if (this.compareToSelfMethod != null) {
                bug.addMethod(this.compareToSelfMethod);
            } else {
                bug.addMethod(this.compareToObjectMethod);
            }
            this.bugReporter.reportBug(bug);
        }
        if (!this.hasCompareToObject && !this.hasCompareToBridgeMethod && this.hasCompareToSelf && !this.extendsObject) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "CO_SELF_NO_OBJECT", 2).addClass(this.getDottedClassName()).addMethod(this.compareToMethod));
        }
        if (this.hasHashCode && !this.hashCodeIsAbstract && !this.hasEqualsObject && !this.hasEqualsSelf) {
            int priority = 3;
            if (usesDefaultEquals) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "HE_HASHCODE_USE_OBJECT_EQUALS", priority).addClass(this.getDottedClassName()).addMethod(this.hashCodeMethod));
            } else if (!inheritedEqualsIsFinal) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "HE_HASHCODE_NO_EQUALS", priority).addClass(this.getDottedClassName()).addMethod(this.hashCodeMethod));
            }
        }
        if (!this.hasHashCode && (this.hasEqualsObject && !this.equalsObjectIsAbstract || this.hasEqualsSelf)) {
            BugInstance bug;
            if (usesDefaultHashCode) {
                int priority = 1;
                if (this.equalsMethodIsInstanceOfEquals) {
                    priority += 2;
                } else if (obj.isAbstract() || !this.hasEqualsObject) {
                    ++priority;
                }
                if (priority == 1) {
                    this.nonHashableClasses.add(this.getDottedClassName());
                }
                if (!this.visibleOutsidePackage) {
                    ++priority;
                }
                bug = new BugInstance((Detector)this, "HE_EQUALS_USE_HASHCODE", priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            } else if (!inheritedHashCodeIsFinal && !whereHashCode.startsWith("java.util.Abstract")) {
                int priority = 3;
                if (this.hasEqualsObject && inheritedEqualsIsAbstract) {
                    ++priority;
                }
                if (this.hasFields) {
                    --priority;
                }
                if (this.equalsMethodIsInstanceOfEquals || !this.hasEqualsObject) {
                    priority += 2;
                } else if (obj.isAbstract()) {
                    ++priority;
                }
                bug = new BugInstance((Detector)this, "HE_EQUALS_NO_HASHCODE", priority).addClass(this.getDottedClassName());
                if (this.equalsMethod != null) {
                    bug.addMethod(this.equalsMethod);
                }
                this.bugReporter.reportBug(bug);
            }
        }
        if (!(this.hasHashCode || this.hasEqualsObject || this.hasEqualsSelf || usesDefaultEquals || !usesDefaultHashCode || obj.isAbstract() || !inheritedEqualsFromAbstractClass)) {
            BugInstance bug = new BugInstance((Detector)this, "HE_INHERITS_EQUALS_USE_HASHCODE", 2).addClass(this.getDottedClassName());
            if (this.equalsMethod != null) {
                bug.addMethod(this.equalsMethod);
            }
            this.bugReporter.reportBug(bug);
        }
        if (!(this.hasEqualsObject || this.hasEqualsSelf || usesDefaultEquals || obj.isAbstract() || !this.hasFields || inheritedEquals == null || inheritedEqualsIsFinal || inheritedEqualsFromAbstractClass || inheritedEquals.getClassDescriptor().getSimpleName().startsWith("Abstract") || inheritedEquals.getClassDescriptor().getClassName().equals("java/lang/Enum"))) {
            BugInstance bug = new BugInstance((Detector)this, "EQ_DOESNT_OVERRIDE_EQUALS", 2).addClass((PreorderVisitor)this).addMethod(inheritedEquals);
            this.bugReporter.reportBug(bug);
        }
    }

    public void visit(JavaClass obj) {
        this.extendsObject = this.getDottedSuperclassName().equals("java.lang.Object");
        this.hasFields = false;
        this.hasHashCode = false;
        this.hasCompareToObject = false;
        this.hasCompareToBridgeMethod = false;
        this.hasCompareToSelf = false;
        this.hasEqualsObject = false;
        this.hasEqualsSelf = false;
        this.hasEqualsOther = false;
        this.hashCodeIsAbstract = false;
        this.equalsObjectIsAbstract = false;
        this.equalsMethodIsInstanceOfEquals = false;
        this.equalsMethod = null;
        this.equalsOtherMethod = null;
        this.compareToMethod = null;
        this.compareToSelfMethod = null;
        this.compareToObjectMethod = null;
        this.hashCodeMethod = null;
        this.equalsOtherClass = null;
    }

    public void visit(Field obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        if (!(obj.getName().startsWith("this$") || obj.isSynthetic() || obj.isTransient())) {
            this.hasFields = true;
        }
    }

    public void visit(Method obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        String name = obj.getName();
        String sig = obj.getSignature();
        if ((accessFlags & 0x400) != 0) {
            if (name.equals("equals") && sig.equals("(L" + this.getClassName() + ";)Z")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_ABSTRACT_SELF", 3).addClass(this.getDottedClassName()));
                return;
            }
            if (name.equals("compareTo") && sig.equals("(L" + this.getClassName() + ";)I")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "CO_ABSTRACT_SELF", 3).addClass(this.getDottedClassName()));
                return;
            }
        }
        boolean sigIsObject = sig.equals("(Ljava/lang/Object;)Z");
        if (name.equals("hashCode") && sig.equals("()I")) {
            this.hasHashCode = true;
            if (obj.isAbstract()) {
                this.hashCodeIsAbstract = true;
            }
            this.hashCodeMethod = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
        } else if (obj.isPublic() && name.equals("equals")) {
            Matcher m = predicateOverAnInstance.matcher(sig);
            if (m.matches()) {
                if (sigIsObject) {
                    Code code;
                    byte[] codeBytes;
                    this.equalsMethod = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
                    this.hasEqualsObject = true;
                    if (obj.isAbstract()) {
                        this.equalsObjectIsAbstract = true;
                    } else if (!obj.isNative() && ((codeBytes = (code = obj.getCode()).getCode()).length == 5 && (codeBytes[1] & 0xFF) == 193 || codeBytes.length == 15 && (codeBytes[1] & 0xFF) == 193 && (codeBytes[11] & 0xFF) == 183)) {
                        this.equalsMethodIsInstanceOfEquals = true;
                    }
                } else if (sig.equals("(L" + this.getClassName() + ";)Z")) {
                    this.hasEqualsSelf = true;
                    if (this.equalsMethod == null) {
                        this.equalsMethod = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
                    }
                } else {
                    JavaClass findSuperImplementor;
                    String arg = m.group(1);
                    if (this.getSuperclassName().equals(arg) && (findSuperImplementor = Lookup.findSuperDefiner((JavaClass)this.getThisClass(), (String)name, (String)sig, (BugReporter)this.bugReporter)) == null) {
                        this.hasEqualsOther = true;
                        this.equalsOtherMethod = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
                        this.equalsOtherClass = DescriptorFactory.createClassDescriptor((String)arg);
                    }
                }
            }
        } else if (name.equals("compareTo") && sig.endsWith(")I") && !obj.isStatic()) {
            MethodAnnotation tmp = MethodAnnotation.fromVisitedMethod((PreorderVisitor)this);
            if (obj.isSynthetic()) {
                this.hasCompareToBridgeMethod = true;
            }
            if (sig.equals("(Ljava/lang/Object;)I")) {
                this.hasCompareToObject = true;
                this.compareToObjectMethod = this.compareToMethod = tmp;
            } else if (sig.equals("(L" + this.getClassName() + ";)I")) {
                this.hasCompareToSelf = true;
                this.compareToSelfMethod = this.compareToMethod = tmp;
            }
        }
    }

    Method findMethod(JavaClass clazz, String name, String sig) {
        Method[] m;
        for (Method aM : m = clazz.getMethods()) {
            if (!aM.getName().equals(name) || !aM.getSignature().equals(sig)) continue;
            return aM;
        }
        return null;
    }

    public void sawOpcode(int seen) {
        if (seen == 182) {
            String className = this.getClassConstantOperand();
            if (className.equals("java/util/Map") || className.equals("java/util/HashMap") || className.equals("java/util/LinkedHashMap") || className.equals("java/util/concurrent/ConcurrentHashMap")) {
                if (this.getNameConstantOperand().equals("put") && this.getSigConstantOperand().equals("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;") && this.stack.getStackDepth() >= 3) {
                    this.check(1);
                } else if ((this.getNameConstantOperand().equals("get") || this.getNameConstantOperand().equals("remove")) && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && this.stack.getStackDepth() >= 2) {
                    this.check(0);
                }
            } else if ((className.equals("java/util/Set") || className.equals("java/util/HashSet")) && (this.getNameConstantOperand().equals("add") || this.getNameConstantOperand().equals("contains") || this.getNameConstantOperand().equals("remove") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z") && this.stack.getStackDepth() >= 2)) {
                this.check(0);
            }
        }
    }

    private void check(int pos) {
        OpcodeStack.Item item = this.stack.getStackItem(pos);
        JavaClass type = null;
        try {
            type = item.getJavaClass();
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
        if (type == null) {
            return;
        }
        int priority = 2;
        if (this.getClassConstantOperand().indexOf("Hash") >= 0) {
            --priority;
        }
        if (!AnalysisContext.currentAnalysisContext().getSubtypes().isApplicationClass(type)) {
            ++priority;
        }
        if (type.isAbstract() || type.isInterface()) {
            ++priority;
        }
        this.potentialBugs.put(type.getClassName(), new BugInstance((Detector)this, "HE_USE_OF_UNHASHABLE_CLASS", priority).addClassAndMethod((PreorderVisitor)this).addTypeOfNamedClass(type.getClassName()).describe("TYPE_UNHASHABLE").addTypeOfNamedClass(this.getClassConstantOperand()).addSourceLine((BytecodeScanningDetector)this));
    }

    @CheckForNull
    String findHashedClassInSignature(String sig) {
        Matcher m = mapPattern.matcher(sig);
        if (m.find()) {
            return m.group(1).replace('/', '.');
        }
        m = hashTablePattern.matcher(sig);
        if (m.find()) {
            return m.group(1).replace('/', '.');
        }
        m = setPattern.matcher(sig);
        if (m.find()) {
            return m.group(1).replace('/', '.');
        }
        return null;
    }

    public void visit(Signature obj) {
        String sig = obj.getSignature();
        String className = this.findHashedClassInSignature(sig);
        if (className == null) {
            return;
        }
        JavaClass type = null;
        try {
            type = Repository.lookupClass((String)className);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
        if (type == null) {
            return;
        }
        int priority = 2;
        if (sig.indexOf("Hash") >= 0) {
            --priority;
        }
        if (type.isAbstract() || type.isInterface()) {
            ++priority;
        }
        if (!AnalysisContext.currentAnalysisContext().getSubtypes().isApplicationClass(type)) {
            ++priority;
        }
        BugInstance bug = null;
        bug = this.visitingField() ? new BugInstance((Detector)this, "HE_USE_OF_UNHASHABLE_CLASS", priority).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this).addTypeOfNamedClass(className).describe("TYPE_UNHASHABLE") : (this.visitingMethod() ? new BugInstance((Detector)this, "HE_USE_OF_UNHASHABLE_CLASS", priority).addClassAndMethod((PreorderVisitor)this).addTypeOfNamedClass(className).describe("TYPE_UNHASHABLE") : new BugInstance((Detector)this, "HE_USE_OF_UNHASHABLE_CLASS", priority).addClass((PreorderVisitor)this).addClass((PreorderVisitor)this).addTypeOfNamedClass(className).describe("TYPE_UNHASHABLE"));
        this.potentialBugs.put(className, bug);
    }

    public void report() {
        for (Map.Entry<String, BugInstance> e : this.potentialBugs.entrySet()) {
            if (this.isHashableClassName(e.getKey())) continue;
            BugInstance bug = e.getValue();
            this.bugReporter.reportBug(bug);
        }
    }
}

